/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import com.google.common.base.Objects;

public class IndexIdentifier {
    public final String keyspaceName;
    public final String tableName;
    public final String indexName;

    public IndexIdentifier(String keyspaceName, String tableName, String indexName) {
        this.keyspaceName = keyspaceName;
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public String logMessage(String message) {
        return String.format("[%s.%s.%s] %s", this.keyspaceName, this.tableName, this.indexName, message);
    }

    public String toString() {
        return String.format("%s.%s", this.keyspaceName, this.indexName);
    }

    public int hashCode() {
        return Objects.hashCode(this.keyspaceName, this.tableName, this.indexName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IndexIdentifier other = (IndexIdentifier)obj;
        return Objects.equal(this.keyspaceName, other.keyspaceName) && Objects.equal(this.tableName, other.tableName) && Objects.equal(this.indexName, other.indexName);
    }
}

