/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.base.Stopwatch;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.io.SeekingRandomAccessInput;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreePostingsIndex;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWalker;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWriter;
import org.apache.cassandra.index.sai.disk.v1.postings.FilteringPostingList;
import org.apache.cassandra.index.sai.disk.v1.postings.MergePostingList;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingsReader;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.postings.PeekablePostingList;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.Throwables;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.DirectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBalancedTreeReader
extends BlockBalancedTreeWalker
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Comparator<PeekablePostingList> COMPARATOR = Comparator.comparingLong(PeekablePostingList::peek);
    private final IndexIdentifier indexIdentifier;
    private final FileHandle postingsFile;
    private final BlockBalancedTreePostingsIndex postingsIndex;
    private final int leafOrderMapBitsRequired;

    public BlockBalancedTreeReader(IndexIdentifier indexIdentifier, FileHandle treeIndexFile, long treeIndexRoot, FileHandle postingsFile, long treePostingsRoot) throws IOException {
        super(treeIndexFile, treeIndexRoot);
        this.indexIdentifier = indexIdentifier;
        this.postingsFile = postingsFile;
        this.postingsIndex = new BlockBalancedTreePostingsIndex(postingsFile, treePostingsRoot);
        this.leafOrderMapBitsRequired = DirectWriter.unsignedBitsRequired(this.maxValuesInLeafNode - 1);
    }

    public int getBytesPerValue() {
        return this.bytesPerValue;
    }

    public long getPointCount() {
        return this.valueCount;
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.postingsFile);
    }

    public PostingList intersect(IntersectVisitor visitor, QueryEventListener.BalancedTreeEventListener listener, QueryContext context) {
        PointValues.Relation relation = visitor.compare(this.minPackedValue, this.maxPackedValue);
        if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            listener.onIntersectionEarlyExit();
            return null;
        }
        listener.onSegmentHit();
        IndexInput treeInput = IndexFileUtils.instance.openInput(this.treeIndexFile);
        IndexInput postingsInput = IndexFileUtils.instance.openInput(this.postingsFile);
        IndexInput postingsSummaryInput = IndexFileUtils.instance.openInput(this.postingsFile);
        Intersection intersection = relation == PointValues.Relation.CELL_INSIDE_QUERY ? new Intersection(treeInput, postingsInput, postingsSummaryInput, listener, context) : new FilteringIntersection(treeInput, postingsInput, postingsSummaryInput, visitor, listener, context);
        return intersection.execute();
    }

    public static interface IntersectVisitor {
        public boolean contains(byte[] var1);

        public PointValues.Relation compare(byte[] var1, byte[] var2);
    }

    private class FilteringIntersection
    extends Intersection {
        private final IntersectVisitor visitor;
        private final byte[] packedValue;
        private final short[] origIndex;

        FilteringIntersection(IndexInput treeInput, IndexInput postingsInput, IndexInput postingsSummaryInput, IntersectVisitor visitor, QueryEventListener.BalancedTreeEventListener listener, QueryContext context) {
            super(treeInput, postingsInput, postingsSummaryInput, listener, context);
            this.visitor = visitor;
            this.packedValue = new byte[BlockBalancedTreeReader.this.bytesPerValue];
            this.origIndex = new short[BlockBalancedTreeReader.this.maxValuesInLeafNode];
        }

        @Override
        public void executeInternal() throws IOException {
            this.collectPostingLists(BlockBalancedTreeReader.this.minPackedValue, BlockBalancedTreeReader.this.maxPackedValue);
        }

        private void collectPostingLists(byte[] minPackedValue, byte[] maxPackedValue) throws IOException {
            this.context.checkpoint();
            PointValues.Relation r = this.visitor.compare(minPackedValue, maxPackedValue);
            if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return;
            }
            if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                super.collectPostingLists();
                return;
            }
            if (this.state.atLeafNode()) {
                if (this.state.nodeExists()) {
                    this.filterLeaf();
                }
                return;
            }
            this.visitNode(minPackedValue, maxPackedValue);
        }

        private void filterLeaf() throws IOException {
            this.treeInput.seek(this.state.getLeafBlockFP());
            int count = this.treeInput.readVInt();
            int orderMapLength = this.treeInput.readVInt();
            long orderMapPointer = this.treeInput.getFilePointer();
            SeekingRandomAccessInput randomAccessInput = new SeekingRandomAccessInput(this.treeInput);
            LongValues leafOrderMapReader = DirectReader.getInstance(randomAccessInput, BlockBalancedTreeReader.this.leafOrderMapBitsRequired, orderMapPointer);
            for (int index = 0; index < count; ++index) {
                this.origIndex[index] = (short)Math.toIntExact(leafOrderMapReader.get(index));
            }
            this.treeInput.seek(orderMapPointer + (long)orderMapLength);
            FixedBitSet fixedBitSet = this.buildPostingsFilter(this.treeInput, count, this.visitor, this.origIndex);
            if (BlockBalancedTreeReader.this.postingsIndex.exists(this.state.nodeID) && fixedBitSet.cardinality() > 0) {
                long pointer = BlockBalancedTreeReader.this.postingsIndex.getPostingsFilePointer(this.state.nodeID);
                this.postingLists.add(this.initFilteringPostingReader(pointer, fixedBitSet));
            }
        }

        void visitNode(byte[] minPackedValue, byte[] maxPackedValue) throws IOException {
            assert (!this.state.atLeafNode()) : "Cannot recurse down tree because nodeID " + this.state.nodeID + " is a leaf node";
            byte[] splitValue = this.state.getSplitValue();
            if (BlockBalancedTreeWriter.DEBUG) {
                assert (ByteArrayUtil.compareUnsigned(minPackedValue, 0, splitValue, 0, BlockBalancedTreeReader.this.bytesPerValue) <= 0) : "bytesPerValue=" + BlockBalancedTreeReader.this.bytesPerValue;
                assert (ByteArrayUtil.compareUnsigned(maxPackedValue, 0, splitValue, 0, BlockBalancedTreeReader.this.bytesPerValue) >= 0) : "bytesPerValue=" + BlockBalancedTreeReader.this.bytesPerValue;
            }
            this.state.pushLeft();
            this.collectPostingLists(minPackedValue, splitValue);
            this.state.pop();
            this.state.pushRight();
            this.collectPostingLists(splitValue, maxPackedValue);
            this.state.pop();
        }

        private PeekablePostingList initFilteringPostingReader(long offset, FixedBitSet filter) throws IOException {
            PostingsReader.BlocksSummary summary = new PostingsReader.BlocksSummary(this.postingsSummaryInput, offset);
            PostingsReader postingsReader = new PostingsReader(this.postingsInput, summary, this.listener.postingListEventListener());
            return PeekablePostingList.makePeekable(new FilteringPostingList(filter, postingsReader));
        }

        private FixedBitSet buildPostingsFilter(IndexInput in, int count, IntersectVisitor visitor, short[] origIndex) throws IOException {
            int commonPrefixLength = this.readCommonPrefixLength(in);
            return commonPrefixLength == BlockBalancedTreeReader.this.bytesPerValue ? this.buildPostingsFilterForSingleValueLeaf(count, visitor, origIndex) : this.buildPostingsFilterForMultiValueLeaf(commonPrefixLength, in, count, visitor, origIndex);
        }

        private FixedBitSet buildPostingsFilterForMultiValueLeaf(int commonPrefixLength, IndexInput in, int count, IntersectVisitor visitor, short[] origIndex) throws IOException {
            int i;
            int runLen;
            int compressedByteOffset = commonPrefixLength++;
            FixedBitSet fixedBitSet = new FixedBitSet(BlockBalancedTreeReader.this.maxValuesInLeafNode);
            for (i = 0; i < count; i += runLen) {
                this.packedValue[compressedByteOffset] = in.readByte();
                runLen = Byte.toUnsignedInt(in.readByte());
                for (int j = 0; j < runLen; ++j) {
                    in.readBytes(this.packedValue, commonPrefixLength, BlockBalancedTreeReader.this.bytesPerValue - commonPrefixLength);
                    short rowIDIndex = origIndex[i + j];
                    if (!visitor.contains(this.packedValue)) continue;
                    fixedBitSet.set(rowIDIndex);
                }
            }
            if (i != count) {
                throw new CorruptIndexException(String.format("Expected %d sub-blocks but read %d.", count, i), in);
            }
            return fixedBitSet;
        }

        private FixedBitSet buildPostingsFilterForSingleValueLeaf(int count, IntersectVisitor visitor, short[] origIndex) {
            FixedBitSet fixedBitSet = new FixedBitSet(BlockBalancedTreeReader.this.maxValuesInLeafNode);
            if (visitor.contains(this.packedValue)) {
                for (int i = 0; i < count; ++i) {
                    fixedBitSet.set(origIndex[i]);
                }
            }
            return fixedBitSet;
        }

        private int readCommonPrefixLength(IndexInput in) throws IOException {
            int prefixLength = in.readVInt();
            if (prefixLength > 0) {
                in.readBytes(this.packedValue, 0, prefixLength);
            }
            return prefixLength;
        }
    }

    private class Intersection {
        private final Stopwatch queryExecutionTimer = Stopwatch.createStarted();
        final QueryContext context;
        final BlockBalancedTreeWalker.TraversalState state;
        final IndexInput treeInput;
        final IndexInput postingsInput;
        final IndexInput postingsSummaryInput;
        final QueryEventListener.BalancedTreeEventListener listener;
        final PriorityQueue<PeekablePostingList> postingLists;

        Intersection(IndexInput treeInput, IndexInput postingsInput, IndexInput postingsSummaryInput, QueryEventListener.BalancedTreeEventListener listener, QueryContext context) {
            this.state = BlockBalancedTreeReader.this.newTraversalState();
            this.treeInput = treeInput;
            this.postingsInput = postingsInput;
            this.postingsSummaryInput = postingsSummaryInput;
            this.listener = listener;
            this.context = context;
            this.postingLists = new PriorityQueue<PeekablePostingList>(BlockBalancedTreeReader.this.numLeaves, COMPARATOR);
        }

        public PostingList execute() {
            try {
                this.executeInternal();
                FileUtils.closeQuietly(this.treeInput);
                return this.mergePostings();
            }
            catch (Throwable t2) {
                if (!(t2 instanceof QueryCancelledException)) {
                    logger.error(BlockBalancedTreeReader.this.indexIdentifier.logMessage("Balanced tree intersection failed on {}"), (Object)BlockBalancedTreeReader.this.treeIndexFile.path(), (Object)t2);
                }
                this.closeOnException();
                throw Throwables.cleaned(t2);
            }
        }

        protected void executeInternal() throws IOException {
            this.collectPostingLists();
        }

        protected void closeOnException() {
            FileUtils.closeQuietly(this.treeInput);
            FileUtils.closeQuietly(this.postingsInput);
            FileUtils.closeQuietly(this.postingsSummaryInput);
        }

        protected PostingList mergePostings() {
            long elapsedMicros = this.queryExecutionTimer.stop().elapsed(TimeUnit.MICROSECONDS);
            this.listener.onIntersectionComplete(elapsedMicros, TimeUnit.MICROSECONDS);
            this.listener.postingListsHit(this.postingLists.size());
            if (this.postingLists.isEmpty()) {
                FileUtils.closeQuietly(this.postingsInput);
                FileUtils.closeQuietly(this.postingsSummaryInput);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace(BlockBalancedTreeReader.this.indexIdentifier.logMessage("[{}] Intersection completed in {} microseconds. {} leaf and internal posting lists hit."), new Object[]{BlockBalancedTreeReader.this.treeIndexFile.path(), elapsedMicros, this.postingLists.size()});
            }
            return MergePostingList.merge(this.postingLists, () -> FileUtils.close(this.postingsInput, this.postingsSummaryInput));
        }

        private void collectPostingLists() throws IOException {
            this.context.checkpoint();
            if (BlockBalancedTreeReader.this.postingsIndex.exists(this.state.nodeID)) {
                this.postingLists.add(this.initPostingReader(BlockBalancedTreeReader.this.postingsIndex.getPostingsFilePointer(this.state.nodeID)));
                return;
            }
            if (this.state.atLeafNode()) {
                throw new CorruptIndexException(BlockBalancedTreeReader.this.indexIdentifier.logMessage(String.format("Leaf node %s does not have balanced tree postings.", this.state.nodeID)), "");
            }
            this.state.pushLeft();
            this.collectPostingLists();
            this.state.pop();
            this.state.pushRight();
            this.collectPostingLists();
            this.state.pop();
        }

        private PeekablePostingList initPostingReader(long offset) throws IOException {
            PostingsReader.BlocksSummary summary = new PostingsReader.BlocksSummary(this.postingsSummaryInput, offset);
            return PeekablePostingList.makePeekable(new PostingsReader(this.postingsInput, summary, this.listener.postingListEventListener()));
        }
    }
}

