/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.MetadataSource;
import org.apache.cassandra.index.sai.disk.v1.bitpack.BlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.MonotonicBlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookup;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;

@NotThreadSafe
public class SkinnyPrimaryKeyMap
implements PrimaryKeyMap {
    protected final LongArray rowIdToTokenArray;
    protected final LongArray rowIdToPartitionIdArray;
    protected final KeyLookup.Cursor partitionKeyCursor;
    protected final PrimaryKey.Factory primaryKeyFactory;

    protected SkinnyPrimaryKeyMap(LongArray rowIdToTokenArray, LongArray rowIdToPartitionIdArray, KeyLookup.Cursor partitionKeyCursor, PrimaryKey.Factory primaryKeyFactory) {
        this.rowIdToTokenArray = rowIdToTokenArray;
        this.rowIdToPartitionIdArray = rowIdToPartitionIdArray;
        this.partitionKeyCursor = partitionKeyCursor;
        this.primaryKeyFactory = primaryKeyFactory;
    }

    @Override
    public PrimaryKey primaryKeyFromRowId(long sstableRowId) {
        return this.primaryKeyFactory.create(this.readPartitionKey(sstableRowId));
    }

    @Override
    public long rowIdFromPrimaryKey(PrimaryKey primaryKey) {
        long rowId = this.rowIdToTokenArray.indexOf(primaryKey.token().getLongValue());
        if (primaryKey.kind() == PrimaryKey.Kind.TOKEN || rowId < 0L || rowId + 1L == this.rowIdToTokenArray.length() || this.rowIdToTokenArray.get(rowId) != primaryKey.token().getLongValue()) {
            return rowId;
        }
        return this.tokenCollisionDetection(primaryKey, rowId);
    }

    @Override
    public long ceiling(Token token) {
        return this.rowIdToTokenArray.indexOf(token.getLongValue());
    }

    @Override
    public long floor(Token token) {
        if (token.isMinimum()) {
            return Long.MIN_VALUE;
        }
        return this.rowIdToTokenArray.indexOf(token.getLongValue());
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(Arrays.asList(this.partitionKeyCursor, this.rowIdToTokenArray, this.rowIdToPartitionIdArray));
    }

    protected long tokenCollisionDetection(PrimaryKey primaryKey, long rowId) {
        while (rowId + 1L < this.rowIdToTokenArray.length() && primaryKey.token().getLongValue() == this.rowIdToTokenArray.get(rowId + 1L)) {
            if (this.readPartitionKey(rowId).compareTo(primaryKey.partitionKey()) >= 0) {
                return rowId;
            }
            ++rowId;
        }
        return rowId;
    }

    protected DecoratedKey readPartitionKey(long sstableRowId) {
        return this.primaryKeyFactory.partitionKeyFromComparableBytes(this.partitionKeyCursor.seekToPointId(this.rowIdToPartitionIdArray.get(sstableRowId)));
    }

    @ThreadSafe
    public static class Factory
    implements PrimaryKeyMap.Factory {
        protected final MetadataSource metadataSource;
        protected final LongArray.Factory rowToTokenReaderFactory;
        protected final LongArray.Factory rowToPartitionReaderFactory;
        protected final KeyLookup partitionKeyReader;
        protected final PrimaryKey.Factory primaryKeyFactory;
        private final FileHandle rowToTokenFile;
        private final FileHandle rowToPartitionFile;
        private final FileHandle partitionKeyBlockOffsetsFile;
        private final FileHandle partitionKeyBlocksFile;

        public Factory(IndexDescriptor indexDescriptor) {
            this.rowToTokenFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.ROW_TO_TOKEN, this::close);
            this.rowToPartitionFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.ROW_TO_PARTITION, this::close);
            this.partitionKeyBlockOffsetsFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_KEY_BLOCK_OFFSETS, this::close);
            this.partitionKeyBlocksFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_KEY_BLOCKS, this::close);
            try {
                this.metadataSource = MetadataSource.loadGroupMetadata(indexDescriptor);
                NumericValuesMeta tokensMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.ROW_TO_TOKEN)));
                this.rowToTokenReaderFactory = new BlockPackedReader(this.rowToTokenFile, tokensMeta);
                NumericValuesMeta partitionsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.ROW_TO_PARTITION)));
                this.rowToPartitionReaderFactory = new MonotonicBlockPackedReader(this.rowToPartitionFile, partitionsMeta);
                NumericValuesMeta partitionKeyBlockOffsetsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_KEY_BLOCK_OFFSETS)));
                KeyLookupMeta partitionKeysMeta = new KeyLookupMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_KEY_BLOCKS)));
                this.partitionKeyReader = new KeyLookup(this.partitionKeyBlocksFile, this.partitionKeyBlockOffsetsFile, partitionKeysMeta, partitionKeyBlockOffsetsMeta);
                this.primaryKeyFactory = indexDescriptor.primaryKeyFactory;
            }
            catch (Throwable t2) {
                throw Throwables.unchecked(t2);
            }
        }

        @Override
        public PrimaryKeyMap newPerSSTablePrimaryKeyMap() throws IOException {
            LongArray.DeferredLongArray rowIdToToken = new LongArray.DeferredLongArray(this.rowToTokenReaderFactory::open);
            LongArray.DeferredLongArray rowIdToPartitionId = new LongArray.DeferredLongArray(this.rowToPartitionReaderFactory::open);
            return new SkinnyPrimaryKeyMap(rowIdToToken, rowIdToPartitionId, this.partitionKeyReader.openCursor(), this.primaryKeyFactory);
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(Arrays.asList(this.rowToTokenFile, this.rowToPartitionFile, this.partitionKeyBlocksFile, this.partitionKeyBlockOffsetsFile));
        }
    }
}

