/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.AbstractCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public class ArrayCell
extends AbstractCell<byte[]> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ArrayCell(ColumnMetadata.regularColumn("", "", "", ByteType.instance), 0L, 0, 0, ByteArrayUtil.EMPTY_BYTE_ARRAY, null));
    private final long timestamp;
    private final int ttl;
    private final int localDeletionTimeUnsignedInteger;
    private final byte[] value;
    private final CellPath path;

    public ArrayCell(ColumnMetadata column, long timestamp, int ttl, long localDeletionTime, byte[] value, CellPath path) {
        this(column, timestamp, ttl, Cell.deletionTimeLongToUnsignedInteger(localDeletionTime), value, path);
    }

    public ArrayCell(ColumnMetadata column, long timestamp, int ttl, int localDeletionTimeUnsignedInteger, byte[] value, CellPath path) {
        super(column);
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTimeUnsignedInteger = localDeletionTimeUnsignedInteger;
        this.value = value;
        this.path = path;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int ttl() {
        return this.ttl;
    }

    @Override
    public byte[] value() {
        return this.value;
    }

    @Override
    public ValueAccessor<byte[]> accessor() {
        return ByteArrayAccessor.instance;
    }

    @Override
    public CellPath path() {
        return this.path;
    }

    @Override
    public Cell<?> withUpdatedColumn(ColumnMetadata newColumn) {
        return new ArrayCell(newColumn, this.timestamp, this.ttl, this.localDeletionTimeUnsignedInteger, this.value, this.path);
    }

    @Override
    public Cell<?> withUpdatedValue(ByteBuffer newValue) {
        return new ArrayCell(this.column, this.timestamp, this.ttl, this.localDeletionTimeUnsignedInteger, ByteBufferUtil.getArray(newValue), this.path);
    }

    @Override
    public Cell<?> withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, long newLocalDeletionTime) {
        return new ArrayCell(this.column, newTimestamp, this.ttl, newLocalDeletionTime, this.value, this.path);
    }

    @Override
    public Cell<?> withSkippedValue() {
        return new ArrayCell(this.column, this.timestamp, this.ttl, this.localDeletionTimeUnsignedInteger, ByteArrayUtil.EMPTY_BYTE_ARRAY, this.path);
    }

    @Override
    public Cell<?> clone(ByteBufferCloner cloner) {
        if (this.value.length == 0 && this.path == null) {
            return this;
        }
        return super.clone(cloner);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.value) + (this.path == null ? 0L : this.path.unsharedHeapSize());
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.value) - (long)this.value.length + (this.path == null ? 0L : this.path.unsharedHeapSizeExcludingData());
    }

    @Override
    protected int localDeletionTimeAsUnsignedInt() {
        return this.localDeletionTimeUnsignedInteger;
    }
}

