/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.memtable.AbstractMemtableWithCommitlog;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.AsyncPromise;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapPool;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.apache.cassandra.utils.memory.NativePool;
import org.apache.cassandra.utils.memory.SlabPool;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAllocatorMemtable
extends AbstractMemtableWithCommitlog {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAllocatorMemtable.class);
    public static final MemtablePool MEMORY_POOL = AbstractAllocatorMemtable.createMemtableAllocatorPool();
    @Unmetered
    protected final Memtable.Owner owner;
    @Unmetered
    protected final MemtableAllocator allocator;
    @Unmetered
    protected final ClusteringComparator initialComparator;
    @Unmetered
    public final Memtable.Factory initialFactory;
    private final long creationNano = Clock.Global.nanoTime();

    @VisibleForTesting
    static MemtablePool createMemtableAllocatorPool() {
        Config.MemtableAllocationType allocationType = DatabaseDescriptor.getMemtableAllocationType();
        long heapLimit = DatabaseDescriptor.getMemtableHeapSpaceInMiB() << 20;
        long offHeapLimit = DatabaseDescriptor.getMemtableOffheapSpaceInMiB() << 20;
        float memtableCleanupThreshold = DatabaseDescriptor.getMemtableCleanupThreshold().floatValue();
        MemtableCleaner cleaner = AbstractAllocatorMemtable::flushLargestMemtable;
        return AbstractAllocatorMemtable.createMemtableAllocatorPoolInternal(allocationType, heapLimit, offHeapLimit, memtableCleanupThreshold, cleaner);
    }

    @VisibleForTesting
    public static MemtablePool createMemtableAllocatorPoolInternal(Config.MemtableAllocationType allocationType, long heapLimit, long offHeapLimit, float memtableCleanupThreshold, MemtableCleaner cleaner) {
        switch (allocationType) {
            case unslabbed_heap_buffers_logged: {
                return new HeapPool.Logged(heapLimit, memtableCleanupThreshold, cleaner);
            }
            case unslabbed_heap_buffers: {
                logger.debug("Memtables allocating with on-heap buffers");
                return new HeapPool(heapLimit, memtableCleanupThreshold, cleaner);
            }
            case heap_buffers: {
                logger.debug("Memtables allocating with on-heap slabs");
                return new SlabPool(heapLimit, 0L, memtableCleanupThreshold, cleaner);
            }
            case offheap_buffers: {
                logger.debug("Memtables allocating with off-heap buffers");
                return new SlabPool(heapLimit, offHeapLimit, memtableCleanupThreshold, cleaner);
            }
            case offheap_objects: {
                logger.debug("Memtables allocating with off-heap objects");
                return new NativePool(heapLimit, offHeapLimit, memtableCleanupThreshold, cleaner);
            }
        }
        throw new AssertionError();
    }

    public AbstractAllocatorMemtable(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner) {
        super(metadataRef, commitLogLowerBound);
        this.allocator = MEMORY_POOL.newAllocator(metadataRef.toString());
        this.initialComparator = this.metadata.get().comparator;
        this.initialFactory = this.metadata().params.memtable.factory();
        this.owner = owner;
        this.scheduleFlush();
    }

    public MemtableAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public boolean shouldSwitch(ColumnFamilyStore.FlushReason reason) {
        switch (reason) {
            case SCHEMA_CHANGE: {
                return this.initialComparator != this.metadata().comparator || !this.initialFactory.equals(this.metadata().params.memtable.factory());
            }
            case OWNED_RANGES_CHANGE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void metadataUpdated() {
        this.scheduleFlush();
    }

    @Override
    public void localRangesUpdated() {
    }

    @Override
    public void performSnapshot(String snapshotName) {
        throw new AssertionError((Object)"performSnapshot must be implemented if shouldSwitch(SNAPSHOT) can return false.");
    }

    @Override
    public void switchOut(OpOrder.Barrier writeBarrier, AtomicReference<CommitLogPosition> commitLogUpperBound) {
        super.switchOut(writeBarrier, commitLogUpperBound);
        this.allocator.setDiscarding();
    }

    @Override
    public void discard() {
        super.discard();
        this.allocator.setDiscarded();
    }

    public String toString() {
        Memtable.MemoryUsage usage = Memtable.getMemoryUsage(this);
        return String.format("Memtable-%s@%s(%s serialized bytes, %s ops, %s)", this.metadata.get().name, this.hashCode(), FBUtilities.prettyPrintMemory(this.getLiveDataSize()), this.operationCount(), usage);
    }

    @Override
    public void addMemoryUsageTo(Memtable.MemoryUsage stats) {
        stats.ownershipRatioOnHeap += this.getAllocator().onHeap().ownershipRatio();
        stats.ownershipRatioOffHeap += this.getAllocator().offHeap().ownershipRatio();
        stats.ownsOnHeap += this.getAllocator().onHeap().owns();
        stats.ownsOffHeap += this.getAllocator().offHeap().owns();
    }

    @Override
    public void markExtraOnHeapUsed(long additionalSpace, OpOrder.Group opGroup) {
        this.getAllocator().onHeap().allocate(additionalSpace, opGroup);
    }

    @Override
    public void markExtraOffHeapUsed(long additionalSpace, OpOrder.Group opGroup) {
        this.getAllocator().offHeap().allocate(additionalSpace, opGroup);
    }

    void scheduleFlush() {
        int period = this.metadata().params.memtableFlushPeriodInMs;
        if (period > 0) {
            AbstractAllocatorMemtable.scheduleFlush(this.owner, period);
        }
    }

    private static void scheduleFlush(final Memtable.Owner owner, int period) {
        logger.trace("scheduling flush in {} ms", (Object)period);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() {
                Memtable current = owner.getCurrentMemtable();
                if (current instanceof AbstractAllocatorMemtable) {
                    ((AbstractAllocatorMemtable)current).flushIfPeriodExpired();
                }
            }
        };
        ScheduledExecutors.scheduledTasks.scheduleSelfRecurring(runnable, period, TimeUnit.MILLISECONDS);
    }

    private void flushIfPeriodExpired() {
        int period = this.metadata().params.memtableFlushPeriodInMs;
        if (period > 0 && Clock.Global.nanoTime() - this.creationNano >= TimeUnit.MILLISECONDS.toNanos(period)) {
            if (this.isClean()) {
                AbstractAllocatorMemtable.scheduleFlush(this.owner, period);
            } else {
                this.owner.signalFlushRequired(this, ColumnFamilyStore.FlushReason.MEMTABLE_PERIOD_EXPIRED);
            }
        }
    }

    public static Future<Boolean> flushLargestMemtable() {
        float largestRatio = 0.0f;
        AbstractAllocatorMemtable largestMemtable = null;
        Memtable.MemoryUsage largestUsage = null;
        float liveOnHeap = 0.0f;
        float liveOffHeap = 0.0f;
        for (Memtable currentMemtable : ColumnFamilyStore.activeMemtables()) {
            if (!(currentMemtable instanceof AbstractAllocatorMemtable)) continue;
            AbstractAllocatorMemtable current = (AbstractAllocatorMemtable)currentMemtable;
            Memtable.MemoryUsage usage = Memtable.newMemoryUsage();
            current.addMemoryUsageTo(usage);
            for (Memtable indexMemtable : current.owner.getIndexMemtables()) {
                if (!(indexMemtable instanceof AbstractAllocatorMemtable)) continue;
                indexMemtable.addMemoryUsageTo(usage);
            }
            float ratio = Math.max(usage.ownershipRatioOnHeap, usage.ownershipRatioOffHeap);
            if (ratio > largestRatio) {
                largestMemtable = current;
                largestUsage = usage;
                largestRatio = ratio;
            }
            liveOnHeap += usage.ownershipRatioOnHeap;
            liveOffHeap += usage.ownershipRatioOffHeap;
        }
        AsyncPromise<Boolean> returnFuture = new AsyncPromise<Boolean>();
        if (largestMemtable != null) {
            float usedOnHeap = AbstractAllocatorMemtable.MEMORY_POOL.onHeap.usedRatio();
            float usedOffHeap = AbstractAllocatorMemtable.MEMORY_POOL.offHeap.usedRatio();
            float flushingOnHeap = AbstractAllocatorMemtable.MEMORY_POOL.onHeap.reclaimingRatio();
            float flushingOffHeap = AbstractAllocatorMemtable.MEMORY_POOL.offHeap.reclaimingRatio();
            logger.info("Flushing largest {} to free up room. Used total: {}, live: {}, flushing: {}, this: {}", new Object[]{largestMemtable.owner, AbstractAllocatorMemtable.ratio(usedOnHeap, usedOffHeap), AbstractAllocatorMemtable.ratio(liveOnHeap, liveOffHeap), AbstractAllocatorMemtable.ratio(flushingOnHeap, flushingOffHeap), AbstractAllocatorMemtable.ratio(largestUsage.ownershipRatioOnHeap, largestUsage.ownershipRatioOffHeap)});
            Future<CommitLogPosition> flushFuture = largestMemtable.owner.signalFlushRequired(largestMemtable, ColumnFamilyStore.FlushReason.MEMTABLE_LIMIT);
            flushFuture.addListener(() -> {
                try {
                    flushFuture.get();
                    returnFuture.trySuccess(true);
                }
                catch (Throwable t2) {
                    returnFuture.tryFailure(t2);
                }
            }, ImmediateExecutor.INSTANCE);
        } else {
            logger.debug("Flushing of largest memtable, not done, no memtable found");
            returnFuture.trySuccess(false);
        }
        return returnFuture;
    }

    private static String ratio(float onHeap, float offHeap) {
        return String.format("%.2f/%.2f", Float.valueOf(onHeap), Float.valueOf(offHeap));
    }
}

