/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.PartiallyAppliedScalarFunction;
import org.apache.cassandra.cql3.functions.PreComputedScalarFunction;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public interface ScalarFunction
extends Function {
    public boolean isCalledOnNullInput();

    default public boolean isMonotonic() {
        return false;
    }

    public ByteBuffer execute(Arguments var1) throws InvalidRequestException;

    default public ScalarFunction partialApplication(ProtocolVersion protocolVersion, List<ByteBuffer> partialArguments) {
        int unresolvedCount = 0;
        for (ByteBuffer argument : partialArguments) {
            if (argument != UNRESOLVED) continue;
            ++unresolvedCount;
        }
        if (unresolvedCount == this.argTypes().size()) {
            return this;
        }
        if (this.isPure() && unresolvedCount == 0) {
            Arguments arguments = this.newArguments(protocolVersion);
            int m4 = partialArguments.size();
            for (int i = 0; i < m4; ++i) {
                arguments.set(i, partialArguments.get(i));
            }
            return new PreComputedScalarFunction(this.returnType(), this.execute(arguments), protocolVersion, this, partialArguments);
        }
        return new PartiallyAppliedScalarFunction(this, partialArguments, unresolvedCount);
    }
}

