/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.util.Map;
import net.openhft.chronicle.wire.WireOut;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.binlog.BinLog;
import org.apache.cassandra.utils.concurrent.WeightedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinAuditLogger
implements IAuditLogger {
    public static final long CURRENT_VERSION = 0L;
    public static final String AUDITLOG_TYPE = "audit";
    public static final String AUDITLOG_MESSAGE = "message";
    private static final Logger logger = LoggerFactory.getLogger(BinAuditLogger.class);
    private volatile BinLog binLog;

    public BinAuditLogger(AuditLogOptions auditLoggingOptions) {
        this.binLog = new BinLog.Builder().path(File.getPath(auditLoggingOptions.audit_logs_dir, new String[0])).rollCycle(auditLoggingOptions.roll_cycle).blocking(auditLoggingOptions.block).maxQueueWeight(auditLoggingOptions.max_queue_weight).maxLogSize(auditLoggingOptions.max_log_size).archiveCommand(auditLoggingOptions.archive_command).maxArchiveRetries(auditLoggingOptions.max_archive_retries).build(false);
    }

    public BinAuditLogger(Map<String, String> params) {
        this(DatabaseDescriptor.getAuditLoggingOptions());
    }

    @Override
    public synchronized void stop() {
        try {
            logger.info("Deactivation of audit log requested.");
            if (this.binLog != null) {
                logger.info("Stopping audit logger");
                this.binLog.stop();
                this.binLog = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.binLog != null;
    }

    @Override
    public void log(AuditLogEntry auditLogEntry) {
        BinLog binLog = this.binLog;
        if (binLog == null || auditLogEntry == null) {
            return;
        }
        binLog.logRecord(new Message(auditLogEntry.getLogString()));
    }

    @VisibleForTesting
    public static class Message
    extends BinLog.ReleaseableWriteMarshallable
    implements WeightedQueue.Weighable {
        private static final long EMPTY_SIZE = ObjectSizes.measure(new Message(""));
        private final String message;

        public Message(String message) {
            this.message = message;
        }

        @Override
        protected long version() {
            return 0L;
        }

        @Override
        protected String type() {
            return BinAuditLogger.AUDITLOG_TYPE;
        }

        @Override
        public void writeMarshallablePayload(WireOut wire) {
            wire.write((CharSequence)BinAuditLogger.AUDITLOG_MESSAGE).text(this.message);
        }

        @Override
        public void release() {
        }

        @Override
        public int weight() {
            return Ints.checkedCast(EMPTY_SIZE + ObjectSizes.sizeOf(this.message));
        }
    }
}

