/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jctools.queues.MpmcArrayQueue;

public abstract class PoolingSupport<T> {
    public static <T> PoolingSupport<T> newThreadBased(Supplier<T> initialValue) {
        return new ThreadPooling<T>(initialValue);
    }

    public static <T> PoolingSupport<T> newThreadBased(int threadLimit, Supplier<T> initialValue) {
        return new ThreadPooling<T>(threadLimit, initialValue);
    }

    public static <T> PoolingSupport<T> newNoPooling(T fixedValue) {
        return new NoPooling<T>(fixedValue);
    }

    private PoolingSupport() {
    }

    public abstract Pooled<T> get();

    public abstract Stream<T> stream();

    protected abstract void onClosed(T var1);

    static class ThreadPooling<T>
    extends PoolingSupport<T> {
        private final int limit;
        private final AtomicInteger created;
        private final MpmcArrayQueue<T> queue;
        private final Supplier<T> initialValue;

        private ThreadPooling(Supplier<T> initialValue) {
            this(Runtime.getRuntime().availableProcessors() + 1, initialValue);
        }

        private ThreadPooling(int threadLimit, Supplier<T> initialValue) {
            this.limit = threadLimit;
            this.created = new AtomicInteger(0);
            this.queue = new MpmcArrayQueue(threadLimit);
            this.initialValue = initialValue;
        }

        @Override
        public Pooled<T> get() {
            T t2 = this.queue.poll();
            if (t2 != null) {
                return new Pooled<T>(this, t2);
            }
            if (this.created.incrementAndGet() > this.limit) {
                this.created.decrementAndGet();
                throw new IllegalStateException("Number of outstanding pooled objects has gone beyond the limit of " + this.limit);
            }
            return new Pooled<T>(this, this.initialValue.get());
        }

        @Override
        public Stream<T> stream() {
            if (this.queue.size() < this.created.get()) {
                throw new IllegalStateException("close() was not called on all pooled objects yet");
            }
            return this.queue.stream();
        }

        @Override
        protected void onClosed(T value) {
            this.queue.offer(value);
        }
    }

    static class NoPooling<T>
    extends PoolingSupport<T> {
        private final T value;
        private final Pooled<T> staticPooled;

        private NoPooling(T value) {
            this.value = value;
            this.staticPooled = new Pooled<T>(this, this.value);
        }

        @Override
        public Pooled<T> get() {
            return this.staticPooled;
        }

        @Override
        public Stream<T> stream() {
            return Stream.of(this.value);
        }

        @Override
        protected void onClosed(T value) {
        }
    }

    public static class Pooled<T>
    implements AutoCloseable {
        private final T value;
        private final PoolingSupport<T> owner;

        private Pooled(PoolingSupport<T> owner, T value) {
            this.owner = owner;
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        @Override
        public void close() {
            this.owner.onClosed(this.value);
        }
    }
}

