/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.CloudConfig;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SniEndPoint;
import com.datastax.driver.core.SniSSLOptions;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.net.HostAndPort;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

class CloudConfigFactory {
    CloudConfigFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloudConfig createCloudConfig(InputStream cloudConfig) throws IOException, GeneralSecurityException {
        JsonNode proxyMetadataJson;
        Preconditions.checkNotNull(cloudConfig, "cloudConfig cannot be null");
        JsonNode configJson = null;
        ByteArrayOutputStream keyStoreOutputStream = null;
        ByteArrayOutputStream trustStoreOutputStream = null;
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry entry;
            zipInputStream = new ZipInputStream(cloudConfig);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String fileName = entry.getName();
                if (fileName.equals("config.json")) {
                    configJson = mapper.readTree((InputStream)zipInputStream);
                    continue;
                }
                if (fileName.equals("identity.jks")) {
                    keyStoreOutputStream = new ByteArrayOutputStream();
                    ByteStreams.copy(zipInputStream, keyStoreOutputStream);
                    continue;
                }
                if (!fileName.equals("trustStore.jks")) continue;
                trustStoreOutputStream = new ByteArrayOutputStream();
                ByteStreams.copy(zipInputStream, trustStoreOutputStream);
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        if (configJson == null) {
            throw new IllegalStateException("Invalid bundle: missing file config.json");
        }
        if (keyStoreOutputStream == null) {
            throw new IllegalStateException("Invalid bundle: missing file identity.jks");
        }
        if (trustStoreOutputStream == null) {
            throw new IllegalStateException("Invalid bundle: missing file trustStore.jks");
        }
        char[] keyStorePassword = this.getKeyStorePassword(configJson);
        char[] trustStorePassword = this.getTrustStorePassword(configJson);
        ByteArrayInputStream keyStoreInputStream = new ByteArrayInputStream(keyStoreOutputStream.toByteArray());
        ByteArrayInputStream trustStoreInputStream = new ByteArrayInputStream(trustStoreOutputStream.toByteArray());
        SSLContext sslContext = this.createSslContext(keyStoreInputStream, keyStorePassword, trustStoreInputStream, trustStorePassword);
        URL metadataServiceUrl = this.getMetadataServiceUrl(configJson);
        BufferedReader proxyMetadata = null;
        try {
            proxyMetadata = this.fetchProxyMetadata(metadataServiceUrl, sslContext);
            proxyMetadataJson = mapper.readTree((Reader)proxyMetadata);
        }
        finally {
            if (proxyMetadata != null) {
                proxyMetadata.close();
            }
        }
        InetSocketAddress sniProxyAddress = this.getSniProxyAddress(proxyMetadataJson);
        List<EndPoint> endPoints = this.getEndPoints(proxyMetadataJson, sniProxyAddress);
        String localDatacenter = this.getLocalDatacenter(proxyMetadataJson);
        SSLOptions sslOptions = this.getSSLOptions(sslContext);
        AuthProvider authProvider = this.getAuthProvider(configJson);
        return new CloudConfig(sniProxyAddress, endPoints, localDatacenter, sslOptions, authProvider);
    }

    protected char[] getKeyStorePassword(JsonNode configFile) {
        if (configFile.has("keyStorePassword")) {
            return configFile.get("keyStorePassword").asText().toCharArray();
        }
        throw new IllegalStateException("Invalid config.json: missing field keyStorePassword");
    }

    protected char[] getTrustStorePassword(JsonNode configFile) {
        if (configFile.has("trustStorePassword")) {
            return configFile.get("trustStorePassword").asText().toCharArray();
        }
        throw new IllegalStateException("Invalid config.json: missing field trustStorePassword");
    }

    protected URL getMetadataServiceUrl(JsonNode configFile) throws MalformedURLException {
        if (configFile.has("host")) {
            String metadataServiceHost = configFile.get("host").asText();
            if (configFile.has("port")) {
                int metadataServicePort = configFile.get("port").asInt();
                return new URL("https", metadataServiceHost, metadataServicePort, "/metadata");
            }
            throw new IllegalStateException("Invalid config.json: missing field port");
        }
        throw new IllegalStateException("Invalid config.json: missing field host");
    }

    protected AuthProvider getAuthProvider(JsonNode configFile) {
        if (configFile.has("username")) {
            String username = configFile.get("username").asText();
            if (configFile.has("password")) {
                String password = configFile.get("password").asText();
                return new PlainTextAuthProvider(username, password);
            }
        }
        return null;
    }

    protected SSLContext createSslContext(ByteArrayInputStream keyStoreInputStream, char[] keyStorePassword, ByteArrayInputStream trustStoreInputStream, char[] trustStorePassword) throws IOException, GeneralSecurityException {
        KeyManagerFactory kmf = this.createKeyManagerFactory(keyStoreInputStream, keyStorePassword);
        TrustManagerFactory tmf = this.createTrustManagerFactory(trustStoreInputStream, trustStorePassword);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    protected KeyManagerFactory createKeyManagerFactory(InputStream keyStoreInputStream, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(keyStoreInputStream, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword);
        Arrays.fill(keyStorePassword, '\u0000');
        return kmf;
    }

    protected TrustManagerFactory createTrustManagerFactory(InputStream trustStoreInputStream, char[] trustStorePassword) throws IOException, GeneralSecurityException {
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(trustStoreInputStream, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        Arrays.fill(trustStorePassword, '\u0000');
        return tmf;
    }

    protected BufferedReader fetchProxyMetadata(URL metadataServiceUrl, SSLContext sslContext) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)metadataServiceUrl.openConnection();
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        connection.setRequestMethod("GET");
        return new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
    }

    protected String getLocalDatacenter(JsonNode proxyMetadata) {
        JsonNode contactInfo = this.getContactInfo(proxyMetadata);
        if (contactInfo.has("local_dc")) {
            return contactInfo.get("local_dc").asText();
        }
        throw new IllegalStateException("Invalid proxy metadata: missing field local_dc");
    }

    protected InetSocketAddress getSniProxyAddress(JsonNode proxyMetadata) {
        JsonNode contactInfo = this.getContactInfo(proxyMetadata);
        if (contactInfo.has("sni_proxy_address")) {
            HostAndPort sniProxyHostAndPort = HostAndPort.fromString(contactInfo.get("sni_proxy_address").asText());
            if (!sniProxyHostAndPort.hasPort()) {
                throw new IllegalStateException("Invalid proxy metadata: missing port from field sni_proxy_address");
            }
            String host = GuavaCompatibility.INSTANCE.getHost(sniProxyHostAndPort);
            return InetSocketAddress.createUnresolved(host, sniProxyHostAndPort.getPort());
        }
        throw new IllegalStateException("Invalid proxy metadata: missing field sni_proxy_address");
    }

    protected List<EndPoint> getEndPoints(JsonNode proxyMetadata, InetSocketAddress sniProxyAddress) {
        JsonNode contactInfo = this.getContactInfo(proxyMetadata);
        if (contactInfo.has("contact_points")) {
            ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
            JsonNode hostIdsJson = contactInfo.get("contact_points");
            for (int i = 0; i < hostIdsJson.size(); ++i) {
                endPoints.add(new SniEndPoint(sniProxyAddress, hostIdsJson.get(i).asText()));
            }
            return endPoints;
        }
        throw new IllegalStateException("Invalid proxy metadata: missing field contact_points");
    }

    protected JsonNode getContactInfo(JsonNode proxyMetadata) {
        if (proxyMetadata.has("contact_info")) {
            return proxyMetadata.get("contact_info");
        }
        throw new IllegalStateException("Invalid proxy metadata: missing field contact_info");
    }

    protected SSLOptions getSSLOptions(SSLContext sslContext) {
        try {
            return SniSSLOptions.builder().withSSLContext(sslContext).build();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

