/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.internal.PowerIterator;
import java.math.BigDecimal;
import java.math.MathContext;

public class PowerNIterator
implements PowerIterator {
    private final BigDecimal x;
    private final MathContext mathContext;
    private BigDecimal powerOfX;

    public PowerNIterator(BigDecimal x, MathContext mathContext) {
        this.x = x;
        this.mathContext = mathContext;
        this.powerOfX = BigDecimal.ONE;
    }

    @Override
    public BigDecimal getCurrentPower() {
        return this.powerOfX;
    }

    @Override
    public void calculateNextPower() {
        this.powerOfX = this.powerOfX.multiply(this.x, this.mathContext);
    }
}

