/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.secrets.TestSecretsProvider;
import org.apache.cassandra.spark.validation.KeyStoreValidation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyStoreValidationTests {
    @Test
    public void testUnconfiguredKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.notConfigured();
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isNull();
    }

    @Test
    public void testMissingKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-missing.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("KeyStore is empty");
    }

    @Test
    public void testMalformedKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-malformed.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("KeyStore is misconfigured");
    }

    @Test
    public void testEmptyKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-empty.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("KeyStore is empty");
    }

    @Test
    public void testInvalidKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-secret.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).isEqualTo("KeyStore contains no private keys");
    }

    @Test
    public void testValidKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-private.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isNull();
    }

    @Test
    public void testExpiredKeyStore() {
        SecretsProvider secrets = TestSecretsProvider.forKeyStore("PKCS12", "keystore-expired.p12", "qwerty");
        KeyStoreValidation validation = new KeyStoreValidation(secrets);
        Throwable throwable = validation.perform();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).startsWith((CharSequence)"Certificate with alias '1' is expired.");
    }
}

