/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.partitioner.SingleReplicaTests;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

public class JDKSerializationTests
extends VersionRunner {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCassandraRing(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.partitioners(), SourceDSL.arbitrary().pick(Arrays.asList(1, 3, 6, 12, 128))).checkAssert((partitioner, numInstances) -> {
            CassandraRing ring = numInstances > 4 ? TestUtils.createRing(partitioner, (Map<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)(numInstances / 2), (Object)"DC2", (Object)(numInstances / 2))) : TestUtils.createRing(partitioner, numInstances);
            byte[] bytes = bridge.javaSerialize((Serializable)ring);
            CassandraRing deserialized = (CassandraRing)bridge.javaDeserialize(bytes, CassandraRing.class);
            Assertions.assertThat((Object)deserialized).isNotNull();
            Assertions.assertThat((Object)deserialized.rangeMap()).isNotNull();
            Assertions.assertThat((Object)deserialized.tokenRanges()).isNotNull();
            Assertions.assertThat((Object)deserialized).isEqualTo((Object)ring);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testTokenPartitioner(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.partitioners(), SourceDSL.arbitrary().pick(Arrays.asList(1, 3, 6, 12, 128)), SourceDSL.arbitrary().pick(Arrays.asList(1, 4, 8, 16, 32, 1024))).checkAssert((partitioner, numInstances, numCores) -> {
            CassandraRing ring = TestUtils.createRing(partitioner, numInstances);
            TokenPartitioner tokenPartitioner = new TokenPartitioner(ring, 4, numCores.intValue());
            byte[] bytes = bridge.javaSerialize((Serializable)tokenPartitioner);
            TokenPartitioner deserialized = (TokenPartitioner)bridge.javaDeserialize(bytes, TokenPartitioner.class);
            Assertions.assertThat((Object)deserialized.ring()).isEqualTo((Object)tokenPartitioner.ring());
            Assertions.assertThat((int)deserialized.numPartitions()).isEqualTo(tokenPartitioner.numPartitions());
            Assertions.assertThat((List)deserialized.subRanges()).isEqualTo((Object)tokenPartitioner.subRanges());
            Assertions.assertThat((Object)deserialized.partitionMap()).isEqualTo((Object)tokenPartitioner.partitionMap());
            Assertions.assertThat((Map)deserialized.reversePartitionMap()).isEqualTo((Object)tokenPartitioner.reversePartitionMap());
            for (int partition = 0; partition < tokenPartitioner.numPartitions(); ++partition) {
                Assertions.assertThat((Object)deserialized.getTokenRange(partition)).isEqualTo((Object)tokenPartitioner.getTokenRange(partition));
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testPartitionedDataLayer(CassandraBridge bridge) {
        CassandraRing ring = TestUtils.createRing(Partitioner.Murmur3Partitioner, 1024);
        TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
        CqlTable cqlTable = new CqlTable(schema.keyspace, schema.table, schema.createStatement, ring.replicationFactor(), Collections.emptyList());
        TestPartitionedDataLayer partitionedDataLayer = new TestPartitionedDataLayer(bridge, 4, 16, null, ring, cqlTable);
        byte[] bytes = bridge.javaSerialize((Serializable)((Object)partitionedDataLayer));
        TestPartitionedDataLayer deserialized = (TestPartitionedDataLayer)((Object)bridge.javaDeserialize(bytes, TestPartitionedDataLayer.class));
        Assertions.assertThat((Object)((Object)deserialized)).isNotNull();
        Assertions.assertThat((Object)deserialized.ring()).isNotNull();
        Assertions.assertThat((Comparable)deserialized.partitioner()).isNotNull();
        Assertions.assertThat((Object)deserialized.tokenPartitioner()).isNotNull();
        Assertions.assertThat((Comparable)deserialized.partitioner()).isEqualTo((Object)Partitioner.Murmur3Partitioner);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCqlFieldSet(CassandraBridge bridge) {
        CqlField.CqlSet setType = bridge.set((CqlField.CqlType)bridge.text());
        CqlField field = new CqlField(true, false, false, RandomUtils.randomAlphanumeric((int)5, (int)20), (CqlField.CqlType)setType, 10);
        byte[] bytes = bridge.javaSerialize((Serializable)field);
        CqlField deserialized = (CqlField)bridge.javaDeserialize(bytes, CqlField.class);
        Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)field);
        Assertions.assertThat((String)deserialized.name()).isEqualTo(field.name());
        Assertions.assertThat((Object)deserialized.type()).isEqualTo((Object)field.type());
        Assertions.assertThat((int)deserialized.position()).isEqualTo(field.position());
        Assertions.assertThat((boolean)deserialized.isPartitionKey()).isEqualTo(field.isPartitionKey());
        Assertions.assertThat((boolean)deserialized.isClusteringColumn()).isEqualTo(field.isClusteringColumn());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCqlUdt(CassandraBridge bridge) {
        CqlField.CqlUdt udt1 = bridge.udt("udt_keyspace", "udt_table").withField("c", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.timestamp()).withField("a", (CqlField.CqlType)bridge.bigint()).build();
        CqlField.CqlUdt udt2 = bridge.udt("udt_keyspace", "udt_table").withField("a", (CqlField.CqlType)bridge.bigint()).withField("b", (CqlField.CqlType)bridge.timestamp()).withField("c", (CqlField.CqlType)bridge.text()).build();
        Assertions.assertThat((Object)udt2).isNotEqualTo((Object)udt1);
        byte[] bytes = bridge.javaSerialize((Serializable)udt1);
        CqlField.CqlUdt deserialized = (CqlField.CqlUdt)bridge.javaDeserialize(bytes, CqlField.CqlUdt.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)udt1);
        Assertions.assertThat((Object)deserialized).isNotEqualTo((Object)udt2);
        for (int field = 0; field < deserialized.fields().size(); ++field) {
            Assertions.assertThat((Comparable)deserialized.field(field)).isEqualTo((Object)udt1.field(field));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSecretsConfig(CassandraBridge bridge) {
        SslConfig config = new SslConfig.Builder().keyStorePath("keyStorePath").base64EncodedKeyStore("encodedKeyStore").keyStorePassword("keyStorePassword").keyStoreType("keyStoreType").trustStorePath("trustStorePath").base64EncodedTrustStore("encodedTrustStore").trustStorePassword("trustStorePassword").trustStoreType("trustStoreType").build();
        byte[] bytes = bridge.javaSerialize((Serializable)config);
        SslConfig deserialized = (SslConfig)bridge.javaDeserialize(bytes, SslConfig.class);
        Assertions.assertThat((String)deserialized.keyStorePath()).isEqualTo(config.keyStorePath());
        Assertions.assertThat((String)deserialized.base64EncodedKeyStore()).isEqualTo(config.base64EncodedKeyStore());
        Assertions.assertThat((String)deserialized.keyStorePassword()).isEqualTo(config.keyStorePassword());
        Assertions.assertThat((String)deserialized.keyStoreType()).isEqualTo(config.keyStoreType());
        Assertions.assertThat((String)deserialized.trustStorePath()).isEqualTo(config.trustStorePath());
        Assertions.assertThat((String)deserialized.base64EncodedTrustStore()).isEqualTo(config.base64EncodedTrustStore());
        Assertions.assertThat((String)deserialized.trustStorePassword()).isEqualTo(config.trustStorePassword());
        Assertions.assertThat((String)deserialized.trustStoreType()).isEqualTo(config.trustStoreType());
    }

    public static class TestPartitionedDataLayer
    extends PartitionedDataLayer {
        private CassandraBridge bridge;
        private CassandraRing ring;
        private CqlTable cqlTable;
        private TokenPartitioner tokenPartitioner;
        private final String jobId;

        public TestPartitionedDataLayer(CassandraBridge bridge, int defaultParallelism, int numCores, String dc, CassandraRing ring, CqlTable cqlTable) {
            super(ConsistencyLevel.LOCAL_QUORUM, dc);
            this.bridge = bridge;
            this.ring = ring;
            this.cqlTable = cqlTable;
            this.tokenPartitioner = new TokenPartitioner(ring, defaultParallelism, numCores);
            this.jobId = UUID.randomUUID().toString();
        }

        public CompletableFuture<Stream<SSTable>> listInstance(int partitionId, @NotNull Range<BigInteger> range, @NotNull CassandraInstance instance) {
            return CompletableFuture.completedFuture(Stream.of(new SSTable[0]));
        }

        public CassandraBridge bridge() {
            return this.bridge;
        }

        public CassandraRing ring() {
            return this.ring;
        }

        public TokenPartitioner tokenPartitioner() {
            return this.tokenPartitioner;
        }

        protected ExecutorService executorService() {
            return SingleReplicaTests.EXECUTOR;
        }

        public String jobId() {
            return this.jobId;
        }

        public CassandraVersion version() {
            return this.bridge.getVersion();
        }

        public CqlTable cqlTable() {
            return this.cqlTable;
        }

        public TimeProvider timeProvider() {
            return TimeProvider.DEFAULT;
        }

        public ReplicationFactor replicationFactor(String keyspace) {
            return this.ring.replicationFactor();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.version());
            out.writeObject(this.consistencyLevel);
            out.writeObject(this.datacenter);
            out.writeObject(this.ring);
            this.bridge.javaSerialize(out, (Serializable)this.cqlTable);
            out.writeObject(this.tokenPartitioner);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.bridge = CassandraBridgeFactory.get((CassandraVersion)((CassandraVersion)in.readObject()));
            this.consistencyLevel = (ConsistencyLevel)in.readObject();
            this.datacenter = (String)in.readObject();
            this.ring = (CassandraRing)in.readObject();
            this.cqlTable = (CqlTable)this.bridge.javaDeserialize(in, CqlTable.class);
            this.tokenPartitioner = (TokenPartitioner)in.readObject();
        }
    }
}

