/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.TableInfoProvider;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TimestampOption;
import org.apache.cassandra.spark.bulkwriter.WriteMode;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.mockito.Mockito;

public final class TableSchemaTestCommon {
    private TableSchemaTestCommon() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Pair<StructType, ImmutableMap<String, CqlField.CqlType>> buildMatchedDataframeAndCqlColumns(String[] fieldNames, DataType[] sparkTypes, CqlField.CqlType[] cqlTypes) {
        StructType dataFrameSchema = new StructType();
        ImmutableMap.Builder cqlColumnsBuilder = ImmutableMap.builder();
        for (int field = 0; field < fieldNames.length; ++field) {
            dataFrameSchema = dataFrameSchema.add(fieldNames[field], sparkTypes[field]);
            cqlColumnsBuilder.put((Object)fieldNames[field], (Object)cqlTypes[field]);
        }
        ImmutableMap cqlColumns = cqlColumnsBuilder.build();
        return Pair.of((Object)dataFrameSchema, (Object)cqlColumns);
    }

    @NotNull
    public static CqlField.CqlType mockCqlType(String cqlName) {
        CqlField.CqlType mock = (CqlField.CqlType)Mockito.mock(CqlField.CqlType.class);
        Mockito.when((Object)mock.name()).thenReturn((Object)cqlName);
        return mock;
    }

    @NotNull
    public static CqlField.CqlCustom mockCqlCustom(String customTypeClassName) {
        CqlField.CqlCustom mock = (CqlField.CqlCustom)Mockito.mock(CqlField.CqlCustom.class);
        Mockito.when((Object)mock.name()).thenReturn((Object)"custom");
        Mockito.when((Object)mock.customTypeClassName()).thenReturn((Object)customTypeClassName);
        return mock;
    }

    @NotNull
    public static CqlField.CqlCollection mockSetCqlType(String collectionCqlType) {
        return TableSchemaTestCommon.mockCollectionCqlType("set", TableSchemaTestCommon.mockCqlType(collectionCqlType));
    }

    @NotNull
    public static CqlField.CqlCollection mockListCqlType(String collectionCqlType) {
        return TableSchemaTestCommon.mockCollectionCqlType("list", TableSchemaTestCommon.mockCqlType(collectionCqlType));
    }

    @NotNull
    public static CqlField.CqlCollection mockCollectionCqlType(String cqlName, CqlField.CqlType collectionType) {
        CqlField.CqlCollection mock = (CqlField.CqlCollection)Mockito.mock(CqlField.CqlCollection.class);
        Mockito.when((Object)mock.name()).thenReturn((Object)cqlName);
        Mockito.when((Object)mock.type()).thenReturn((Object)collectionType);
        return mock;
    }

    @NotNull
    public static CqlField.CqlType mockMapCqlType(String keyCqlName, String valueCqlName) {
        return TableSchemaTestCommon.mockMapCqlType(TableSchemaTestCommon.mockCqlType(keyCqlName), TableSchemaTestCommon.mockCqlType(valueCqlName));
    }

    @NotNull
    public static CqlField.CqlMap mockMapCqlType(CqlField.CqlType keyType, CqlField.CqlType valueType) {
        CqlField.CqlMap mock = (CqlField.CqlMap)Mockito.mock(CqlField.CqlMap.class);
        Mockito.when((Object)mock.name()).thenReturn((Object)"map");
        Mockito.when((Object)mock.keyType()).thenReturn((Object)keyType);
        Mockito.when((Object)mock.valueType()).thenReturn((Object)valueType);
        return mock;
    }

    @NotNull
    public static CqlField.CqlUdt mockUdtCqlType(String name, String ... namesAndTypes) {
        assert (namesAndTypes.length > 0 && namesAndTypes.length % 2 == 0);
        HashMap<String, CqlField> udtDef = new HashMap<String, CqlField>();
        CqlField.CqlUdt udtMock = (CqlField.CqlUdt)Mockito.mock(CqlField.CqlUdt.class);
        Mockito.when((Object)udtMock.cqlName()).thenReturn((Object)name);
        Mockito.when((Object)udtMock.internalType()).thenReturn((Object)CqlField.CqlType.InternalType.Udt);
        Mockito.when((Object)udtMock.name()).thenReturn((Object)"udt");
        ArrayList<CqlField> fields = new ArrayList<CqlField>();
        for (int i = 0; i < namesAndTypes.length; i += 2) {
            String field = namesAndTypes[i];
            String type = namesAndTypes[i + 1];
            CqlField mock = (CqlField)Mockito.mock(CqlField.class);
            Mockito.when((Object)mock.name()).thenReturn((Object)field);
            Mockito.when((Object)mock.cqlTypeName()).thenReturn((Object)type);
            CqlField.CqlType fieldType = TableSchemaTestCommon.mockCqlType(type);
            Mockito.when((Object)mock.type()).thenReturn((Object)fieldType);
            udtDef.put(field, mock);
            Mockito.when((Object)udtMock.field(i / 2)).thenReturn((Object)mock);
            Mockito.when((Object)udtMock.field(field)).thenReturn((Object)mock);
            fields.add(mock);
        }
        Mockito.when((Object)udtMock.fields()).thenReturn(fields);
        return udtMock;
    }

    public static TableSchema buildSchema(String cassandraVersion, String[] fieldNames, DataType[] sparkTypes, CqlField.CqlType[] driverTypes, String[] partitionKeyColumns, ColumnType<?>[] partitionKeyColumnTypes, String[] primaryKeyColumnNames) {
        Pair<StructType, ImmutableMap<String, CqlField.CqlType>> pair = TableSchemaTestCommon.buildMatchedDataframeAndCqlColumns(fieldNames, sparkTypes, driverTypes);
        ImmutableMap cqlColumns = (ImmutableMap)pair.getValue();
        StructType dataFrameSchema = (StructType)pair.getKey();
        return new MockTableSchemaBuilder(CassandraBridgeFactory.get((String)cassandraVersion)).withCqlColumns((Map<String, CqlField.CqlType>)cqlColumns).withPartitionKeyColumns(partitionKeyColumns).withPrimaryKeyColumnNames(primaryKeyColumnNames).withCassandraVersion(cassandraVersion).withPartitionKeyColumnTypes(partitionKeyColumnTypes).withWriteMode(WriteMode.INSERT).withDataFrameSchema(dataFrameSchema).build();
    }

    public static class MockTableInfoProvider
    implements TableInfoProvider {
        public static final String TEST_TABLE_PREFIX = "test_table_";
        public static final AtomicInteger TEST_TABLE_ID = new AtomicInteger(0);
        private final CassandraBridge bridge;
        private final ImmutableMap<String, CqlField.CqlType> cqlColumns;
        private final String[] partitionKeyColumns;
        private final ColumnType[] partitionKeyColumnTypes;
        private final String[] primaryKeyColumnNames;
        private final String uniqueTableName;
        Map<String, CqlField.CqlType> columns;
        private final String cassandraVersion;
        private final boolean quoteIdentifiers;

        public MockTableInfoProvider(CassandraBridge bridge, ImmutableMap<String, CqlField.CqlType> cqlColumns, String[] partitionKeyColumns, ColumnType[] partitionKeyColumnTypes, String[] primaryKeyColumnNames, String cassandraVersion, boolean quoteIdentifiers) {
            this.bridge = bridge;
            this.cqlColumns = cqlColumns;
            this.partitionKeyColumns = partitionKeyColumns;
            this.partitionKeyColumnTypes = partitionKeyColumnTypes;
            this.primaryKeyColumnNames = primaryKeyColumnNames;
            this.columns = cqlColumns;
            this.cassandraVersion = cassandraVersion.replaceAll("(\\w+-)*cassandra-", "");
            this.quoteIdentifiers = quoteIdentifiers;
            this.uniqueTableName = TEST_TABLE_PREFIX + TEST_TABLE_ID.getAndIncrement();
        }

        public CqlField.CqlType getColumnType(String columnName) {
            return this.columns.get(columnName);
        }

        public List<ColumnType<?>> getPartitionKeyTypes() {
            return Lists.newArrayList((Object[])this.partitionKeyColumnTypes);
        }

        public boolean columnExists(String columnName) {
            return this.columns.containsKey(columnName);
        }

        public List<String> getPartitionKeyColumnNames() {
            return Arrays.asList(this.partitionKeyColumns);
        }

        public String getCreateStatement() {
            String keyDef = this.getKeyDef();
            String createStatement = "CREATE TABLE test." + this.uniqueTableName + " (" + this.cqlColumns.entrySet().stream().map(column -> this.maybeQuoteIdentifierIfRequested((String)column.getKey()) + " " + ((CqlField.CqlType)column.getValue()).name()).collect(Collectors.joining(",\n")) + ", " + keyDef + ") WITH COMPRESSION = {'class': '" + this.getCompression() + "'};";
            System.out.println("Create Table:" + createStatement);
            return createStatement;
        }

        private String getCompression() {
            switch (this.cassandraVersion.charAt(0)) {
                case '4': 
                case '5': {
                    return "ZstdCompressor";
                }
                case '3': {
                    return "LZ4Compressor";
                }
            }
            return "LZ4Compressor";
        }

        private String getKeyDef() {
            ArrayList partitionColumns = Lists.newArrayList((Object[])this.partitionKeyColumns);
            ArrayList primaryColumns = Lists.newArrayList((Object[])this.primaryKeyColumnNames);
            primaryColumns.removeAll(partitionColumns);
            String partitionKey = Arrays.stream(this.partitionKeyColumns).map(this::maybeQuoteIdentifierIfRequested).collect(Collectors.joining(",", "(", ")"));
            String clusteringKey = primaryColumns.stream().map(this::maybeQuoteIdentifierIfRequested).collect(Collectors.joining(","));
            return "PRIMARY KEY (" + partitionKey + clusteringKey + ")";
        }

        public List<String> getPrimaryKeyColumnNames() {
            return Arrays.asList(this.primaryKeyColumnNames);
        }

        public String getName() {
            return this.uniqueTableName;
        }

        public String getKeyspaceName() {
            return "test";
        }

        public boolean hasSecondaryIndex() {
            return false;
        }

        public List<String> getColumnNames() {
            return this.cqlColumns.keySet().asList();
        }

        private String maybeQuoteIdentifierIfRequested(String identifier) {
            return this.quoteIdentifiers ? this.bridge.maybeQuoteIdentifier(identifier) : identifier;
        }
    }

    public static class MockTableSchemaBuilder {
        private final CassandraBridge bridge;
        private ImmutableMap<String, CqlField.CqlType> cqlColumns;
        private String[] partitionKeyColumns;
        private String[] primaryKeyColumnNames;
        private String cassandraVersion;
        private ColumnType[] partitionKeyColumnTypes;
        private StructType dataFrameSchema;
        private WriteMode writeMode = null;
        private TTLOption ttlOption = TTLOption.forever();
        private TimestampOption timestampOption = TimestampOption.now();
        private boolean quoteIdentifiers = false;

        public MockTableSchemaBuilder(CassandraBridge bridge) {
            this.bridge = bridge;
        }

        public MockTableSchemaBuilder withCqlColumns(@NotNull Map<String, CqlField.CqlType> cqlColumns) {
            Preconditions.checkNotNull(cqlColumns, (Object)"cqlColumns cannot be null");
            Preconditions.checkArgument((!cqlColumns.isEmpty() ? 1 : 0) != 0, (Object)"cqlColumns cannot be empty");
            this.cqlColumns = ImmutableMap.copyOf(cqlColumns);
            return this;
        }

        public MockTableSchemaBuilder withPartitionKeyColumns(String ... partitionKeyColumns) {
            Preconditions.checkNotNull((Object)partitionKeyColumns, (Object)"partitionKeyColumns cannot be null");
            Preconditions.checkArgument((partitionKeyColumns.length > 0 ? 1 : 0) != 0, (Object)"partitionKeyColumns cannot be empty");
            this.partitionKeyColumns = partitionKeyColumns;
            return this;
        }

        public MockTableSchemaBuilder withPrimaryKeyColumnNames(String ... primaryKeyColumnNames) {
            Preconditions.checkNotNull((Object)primaryKeyColumnNames, (Object)"primaryKeyColumnNames cannot be null");
            Preconditions.checkArgument((primaryKeyColumnNames.length > 0 ? 1 : 0) != 0, (Object)"primaryKeyColumnNames cannot be empty");
            this.primaryKeyColumnNames = primaryKeyColumnNames;
            return this;
        }

        public MockTableSchemaBuilder withCassandraVersion(@NotNull String cassandraVersion) {
            Preconditions.checkNotNull((Object)cassandraVersion, (Object)"cassandraVersion cannot be null");
            Preconditions.checkArgument((!cassandraVersion.isEmpty() ? 1 : 0) != 0, (Object)"cassandraVersion cannot be an empty string");
            this.cassandraVersion = cassandraVersion;
            return this;
        }

        public MockTableSchemaBuilder withPartitionKeyColumnTypes(ColumnType<?> ... partitionKeyColumnTypes) {
            Preconditions.checkNotNull(partitionKeyColumnTypes, (Object)"partitionKeyColumnTypes cannot be null");
            Preconditions.checkArgument((partitionKeyColumnTypes.length > 0 ? 1 : 0) != 0, (Object)"partitionKeyColumnTypes cannot be empty");
            this.partitionKeyColumnTypes = Arrays.copyOf(partitionKeyColumnTypes, partitionKeyColumnTypes.length);
            return this;
        }

        public MockTableSchemaBuilder withWriteMode(@NotNull WriteMode writeMode) {
            Preconditions.checkNotNull((Object)writeMode, (Object)"writeMode cannot be null");
            this.writeMode = writeMode;
            return this;
        }

        public MockTableSchemaBuilder withDataFrameSchema(StructType dataFrameSchema) {
            Preconditions.checkNotNull((Object)dataFrameSchema, (Object)"dataFrameSchema cannot be null");
            Preconditions.checkArgument((boolean)dataFrameSchema.nonEmpty(), (Object)"dataFrameSchema cannot be empty");
            this.dataFrameSchema = dataFrameSchema;
            return this;
        }

        public MockTableSchemaBuilder withTTLSetting(TTLOption ttlOption) {
            this.ttlOption = ttlOption;
            return this;
        }

        public MockTableSchemaBuilder withTimeStampSetting(TimestampOption timestampOption) {
            this.timestampOption = timestampOption;
            return this;
        }

        public MockTableSchemaBuilder withQuotedIdentifiers() {
            this.quoteIdentifiers = true;
            return this;
        }

        public TableSchema build() {
            Objects.requireNonNull(this.cqlColumns, "cqlColumns cannot be null. Please provide a list of columns by calling #withCqlColumns");
            Objects.requireNonNull(this.partitionKeyColumns, "partitionKeyColumns cannot be null. Please provide a list of columns by calling #withPartitionKeyColumns");
            Objects.requireNonNull(this.primaryKeyColumnNames, "primaryKeyColumnNames cannot be null. Please provide a list of columns by calling #withPrimaryKeyColumnNames");
            Objects.requireNonNull(this.cassandraVersion, "cassandraVersion cannot be null. Please provide a list of columns by calling #withCassandraVersion");
            Objects.requireNonNull(this.partitionKeyColumnTypes, "partitionKeyColumnTypes cannot be null. Please provide a list of columns by calling #withPartitionKeyColumnTypes");
            Objects.requireNonNull(this.writeMode, "writeMode cannot be null. Please provide the write mode by calling #withWriteMode");
            Objects.requireNonNull(this.dataFrameSchema, "dataFrameSchema cannot be null. Please provide the write mode by calling #withDataFrameSchema");
            MockTableInfoProvider tableInfoProvider = new MockTableInfoProvider(this.bridge, this.cqlColumns, this.partitionKeyColumns, this.partitionKeyColumnTypes, this.primaryKeyColumnNames, this.cassandraVersion, this.quoteIdentifiers);
            if (this.ttlOption.withTTl() && this.ttlOption.columnName() != null) {
                this.dataFrameSchema = this.dataFrameSchema.add("ttl", DataTypes.IntegerType);
            }
            if (this.timestampOption.withTimestamp() && this.timestampOption.columnName() != null) {
                this.dataFrameSchema = this.dataFrameSchema.add("timestamp", DataTypes.IntegerType);
            }
            return new TableSchema(this.dataFrameSchema, (TableInfoProvider)tableInfoProvider, this.writeMode, this.ttlOption, this.timestampOption, this.cassandraVersion, this.quoteIdentifiers);
        }
    }
}

