/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.SSTableWriter;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.apache.cassandra.spark.bulkwriter.MockBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.MockTableWriter;
import org.apache.cassandra.spark.bulkwriter.RecordWriter;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TableSchemaTestCommon;
import org.apache.cassandra.spark.bulkwriter.TestTaskContext;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.Tokenizer;
import org.apache.cassandra.spark.bulkwriter.UploadRequest;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.cassandra.spark.utils.XXHash32DigestAlgorithm;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Tuple2;

class RecordWriterTest {
    private static final int REPLICA_COUNT = 3;
    private static final int FILES_PER_SSTABLE = 8;
    private static final int EXPECTED_NUMBER_OF_SSTABLES = 2;
    private static final int ROWS_COUNT = 270;
    private static final String[] COLUMN_NAMES = new String[]{"id", "date", "course", "marks"};
    @TempDir
    private Path folder;
    private TokenRangeMapping<RingInstance> tokenRangeMapping;
    private RecordWriter rw;
    private MockTableWriter tw;
    private Tokenizer tokenizer;
    private Range<BigInteger> range;
    private MockBulkWriterContext writerContext;
    private TestTaskContext tc;
    private DigestAlgorithm digestAlgorithm;

    RecordWriterTest() {
    }

    @BeforeEach
    public void setUp() {
        this.setUp("cassandra-5.0.5");
    }

    private void setUp(String version) {
        this.digestAlgorithm = new XXHash32DigestAlgorithm();
        this.tw = new MockTableWriter(this.folder.getRoot());
        ImmutableMap rfOption = ImmutableMap.of((Object)"DC1", (Object)3);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)rfOption);
        this.tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(100000, (ImmutableMap<String, Integer>)rfOption, 12);
        this.writerContext = new MockBulkWriterContext(this.tokenRangeMapping, version, ConsistencyLevel.CL.LOCAL_QUORUM);
        this.writerContext.setSstableDataSizeInMB(1);
        this.writerContext.setReplicationFactor(rf);
        this.tc = new TestTaskContext();
        this.range = this.writerContext.job().getTokenPartitioner().getTokenRange(this.tc.partitionId());
        BroadcastableTableSchema broadcastableTableSchema = BroadcastableTableSchema.from((TableSchema)this.writerContext.schema().getTableSchema());
        boolean isMurmur3Partitioner = this.writerContext.cluster().getPartitioner() == Partitioner.Murmur3Partitioner;
        this.tokenizer = new Tokenizer(broadcastableTableSchema, isMurmur3Partitioner);
    }

    @Test
    void symmetricDifferenceTest() {
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(2, 3, 4));
        HashSet<Integer> s3 = new HashSet<Integer>(Arrays.asList(5, 6, 7));
        HashSet<Integer> s4 = new HashSet<Integer>(Arrays.asList(5, 6, 7));
        HashSet s5 = new HashSet();
        Assertions.assertThat((Collection)RecordWriter.symmetricDifference(s1, s2)).containsExactly((Object[])new Integer[]{1, 4});
        Assertions.assertThat((Collection)RecordWriter.symmetricDifference(s2, s3)).containsExactly((Object[])new Integer[]{2, 3, 4, 5, 6, 7});
        Assertions.assertThat((Collection)RecordWriter.symmetricDifference(s3, s4)).isEmpty();
        Assertions.assertThat((Collection)RecordWriter.symmetricDifference(s4, s5)).isEqualTo(s4);
    }

    @Test
    void testWriteFailWhenTopologyChangeWithinTask() {
        int moveTargetToken = 50000;
        TokenRangeMapping<RingInstance> testMapping = TokenRangeMappingUtils.buildTokenRangeMapping(100000, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 12, true, moveTargetToken);
        MockBulkWriterContext m = (MockBulkWriterContext)Mockito.spy((Object)this.writerContext);
        this.rw = new RecordWriter((BulkWriterContext)m, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        Mockito.when(m.getTokenRangeMapping(false)).thenCallRealMethod().thenReturn(testMapping);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rw.write(data)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Token range mappings have changed since the task started");
    }

    @Test
    void testWriteWithExclusions() {
        TokenRangeMapping<RingInstance> testMapping = TokenRangeMappingUtils.buildTokenRangeMappingWithFailures(100000, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 12);
        MockBulkWriterContext m = (MockBulkWriterContext)Mockito.spy((Object)this.writerContext);
        this.rw = new RecordWriter((BulkWriterContext)m, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        Mockito.when(m.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn(testMapping);
        Mockito.when(m.clusterWriteAvailability()).thenCallRealMethod();
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        this.rw.write(data);
        Map<CassandraInstance, List<UploadRequest>> uploads = this.writerContext.getUploads();
        Assertions.assertThat((int)uploads.keySet().size()).isEqualTo(3);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testSuccessfulWrite(String version) throws InterruptedException {
        this.setUp(version);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        this.validateSuccessfulWrite(this.writerContext, data, COLUMN_NAMES);
    }

    @Test
    void testWriteWithMixedCaseColumnNames() throws InterruptedException {
        boolean quoteIdentifiers = true;
        String[] pk = new String[]{"ID", "date"};
        String[] columnNames = new String[]{"ID", "date", "course", "limit"};
        Pair<StructType, ImmutableMap<String, CqlField.CqlType>> validPair = TableSchemaTestCommon.buildMatchedDataframeAndCqlColumns(columnNames, new DataType[]{DataTypes.IntegerType, DataTypes.DateType, DataTypes.StringType, DataTypes.IntegerType}, new CqlField.CqlType[]{TableSchemaTestCommon.mockCqlType("int"), TableSchemaTestCommon.mockCqlType("date"), TableSchemaTestCommon.mockCqlType("varchar"), TableSchemaTestCommon.mockCqlType("int")});
        MockBulkWriterContext writerContext = new MockBulkWriterContext(this.tokenRangeMapping, "cassandra-5.0.5", ConsistencyLevel.CL.LOCAL_QUORUM, validPair, pk, pk, quoteIdentifiers);
        writerContext.setSstableDataSizeInMB(1);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        this.validateSuccessfulWrite(writerContext, data, columnNames);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testSuccessfulWriteCheckUploads(String version) {
        this.setUp(version);
        this.rw = new RecordWriter((BulkWriterContext)this.writerContext, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        this.rw.write(data);
        Map<CassandraInstance, List<UploadRequest>> uploads = this.writerContext.getUploads();
        Assertions.assertThat((int)uploads.keySet().size()).isEqualTo(3);
        Assertions.assertThat((int)uploads.values().stream().mapToInt(List::size).sum()).isEqualTo(48);
        List requests = uploads.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (UploadRequest ur : requests) {
            Assertions.assertThat((Object)ur.digest).isNotNull();
        }
    }

    @Test
    void testWriteWithConstantTTL() throws InterruptedException {
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(false, false);
        this.validateSuccessfulWrite(this.writerContext, data, COLUMN_NAMES);
    }

    @Test
    void testWriteWithTTLColumn() throws InterruptedException {
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(true, false);
        String[] columnNamesWithTtl = new String[]{"id", "date", "course", "marks", "ttl"};
        this.validateSuccessfulWrite(this.writerContext, data, columnNamesWithTtl);
    }

    @Test
    void testWriteWithConstantTimestamp() throws InterruptedException {
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(false, false);
        this.validateSuccessfulWrite(this.writerContext, data, COLUMN_NAMES);
    }

    @Test
    void testWriteWithTimestampColumn() throws InterruptedException {
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(false, true);
        String[] columnNamesWithTimestamp = new String[]{"id", "date", "course", "marks", "timestamp"};
        this.validateSuccessfulWrite(this.writerContext, data, columnNamesWithTimestamp);
    }

    @Test
    void testWriteWithTimestampAndTTLColumn() throws InterruptedException {
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(true, true);
        String[] columnNames = new String[]{"id", "date", "course", "marks", "ttl", "timestamp"};
        this.validateSuccessfulWrite(this.writerContext, data, columnNames);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testWriteWithSubRanges(String version) {
        this.setUp(version);
        MockBulkWriterContext m = (MockBulkWriterContext)Mockito.spy((Object)this.writerContext);
        TokenPartitioner mtp = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        Mockito.when((Object)m.job().getTokenPartitioner()).thenReturn((Object)mtp);
        Range overlapRange = Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(200000L));
        Mockito.when((Object)mtp.getTokenRange(ArgumentMatchers.anyInt())).thenReturn((Object)overlapRange);
        this.rw = new RecordWriter((BulkWriterContext)m, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateDataWithFakeToken(270, this.range);
        List res = this.rw.write(data).streamResults();
        Assertions.assertThat((List)res).hasSize(1);
        Assertions.assertThat((Object)((StreamResult)res.get((int)0)).tokenRange).isNotEqualTo((Object)overlapRange);
        Assertions.assertThat((Object)((StreamResult)res.get((int)0)).tokenRange).isEqualTo(this.range);
        Map<CassandraInstance, List<UploadRequest>> uploads = m.getUploads();
        Assertions.assertThat(uploads.keySet()).hasSize(3);
        Assertions.assertThat((int)uploads.values().stream().mapToInt(List::size).sum()).isEqualTo(48);
        List requests = uploads.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (UploadRequest ur : requests) {
            Assertions.assertThat((Object)ur.digest).isNotNull();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testWriteWithDataInMultipleSubRanges(String version) {
        version = "cassandra-5.0.5";
        this.setUp(version);
        MockBulkWriterContext m = (MockBulkWriterContext)Mockito.spy((Object)this.writerContext);
        TokenPartitioner mtp = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        Mockito.when((Object)m.job().getTokenPartitioner()).thenReturn((Object)mtp);
        Range overlapRange = Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(200000L));
        Range firstSubrange = Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(100000L));
        Mockito.when((Object)mtp.getTokenRange(ArgumentMatchers.anyInt())).thenReturn((Object)overlapRange);
        this.rw = new RecordWriter((BulkWriterContext)m, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateDataWithFakeToken(270, (Range<BigInteger>)firstSubrange);
        List res = this.rw.write(data).streamResults();
        Assertions.assertThat((List)res).hasSize(1);
        Assertions.assertThat((Object)((StreamResult)res.get((int)0)).tokenRange).isNotEqualTo((Object)overlapRange);
        Assertions.assertThat((Object)((StreamResult)res.get((int)0)).tokenRange).isEqualTo((Object)firstSubrange);
        Map<CassandraInstance, List<UploadRequest>> uploads = m.getUploads();
        Assertions.assertThat(uploads.keySet()).hasSize(3);
        Assertions.assertThat((int)uploads.values().stream().mapToInt(List::size).sum()).isEqualTo(48);
        List requests = uploads.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (UploadRequest ur : requests) {
            Assertions.assertThat((Object)ur.digest).isNotNull();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testWriteWithTokensAcrossSubRanges(String version) {
        this.setUp(version);
        MockBulkWriterContext m = (MockBulkWriterContext)Mockito.spy((Object)this.writerContext);
        m.setSstableDataSizeInMB(1);
        TokenPartitioner mtp = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        Mockito.when((Object)m.job().getTokenPartitioner()).thenReturn((Object)mtp);
        Range overlapRange = Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(200000L));
        Range firstSubrange = Range.openClosed((Comparable)BigInteger.valueOf(Long.MIN_VALUE), (Comparable)BigInteger.valueOf(100000L));
        Range secondSubrange = Range.openClosed((Comparable)BigInteger.valueOf(100000L), (Comparable)BigInteger.valueOf(200000L));
        Mockito.when((Object)mtp.getTokenRange(ArgumentMatchers.anyInt())).thenReturn((Object)overlapRange);
        this.rw = new RecordWriter((BulkWriterContext)m, COLUMN_NAMES, () -> this.tc, SortedSSTableWriter::new);
        int numRows = 1;
        Iterator<Tuple2<DecoratedKey, Object[]>> firstRangeData = this.generateDataWithFakeToken(numRows, (Range<BigInteger>)firstSubrange);
        Iterator<Tuple2<DecoratedKey, Object[]>> secondRangeData = this.generateDataWithFakeToken(numRows, (Range<BigInteger>)secondSubrange);
        Iterator data = Iterators.concat(firstRangeData, secondRangeData);
        List res = this.rw.write(data).streamResults();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Object)((StreamResult)res.get((int)0)).tokenRange).isNotEqualTo((Object)overlapRange);
        Map<CassandraInstance, List<UploadRequest>> uploads = m.getUploads();
        Assertions.assertThat(uploads.keySet()).hasSize(4);
        Assertions.assertThat((int)uploads.values().stream().mapToInt(List::size).sum()).isEqualTo(48);
        List requests = uploads.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (UploadRequest ur : requests) {
            Assertions.assertThat((Object)ur.digest).isNotNull();
        }
    }

    @Test
    void testCorruptSSTable() {
        this.rw = new RecordWriter((BulkWriterContext)this.writerContext, COLUMN_NAMES, () -> this.tc, (wc, path, dp, pid) -> new SortedSSTableWriter((SSTableWriter)this.tw.setOutDir(path), path, this.digestAlgorithm, pid));
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        Assertions.assertThatThrownBy(() -> this.rw.write(data)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void testWriteWithOutOfRangeTokenFails() {
        this.rw = new RecordWriter((BulkWriterContext)this.writerContext, COLUMN_NAMES, () -> this.tc, (wc, path, dp, pid) -> new SortedSSTableWriter((SSTableWriter)this.tw, this.folder, this.digestAlgorithm, pid));
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData(5, (Range<BigInteger>)Range.all(), false, false, false);
        String expectedErr = "java.lang.IllegalStateException: Received Token 5765203080415074583 outside the expected ranges [(-9223372036854775808\u2025100000]]";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rw.write(data)).isInstanceOf(RuntimeException.class)).hasMessage(expectedErr);
    }

    @Test
    void testAddRowThrowingFails() {
        this.rw = new RecordWriter((BulkWriterContext)this.writerContext, COLUMN_NAMES, () -> this.tc, (wc, path, dp, pid) -> new SortedSSTableWriter((SSTableWriter)this.tw, this.folder, this.digestAlgorithm, pid));
        this.tw.setAddRowThrows(true);
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rw.write(data)).isInstanceOf(RuntimeException.class)).hasMessage("java.lang.RuntimeException: Failed to write because addRow throws");
    }

    @Test
    void testBadTimeSkewFails() {
        Instant localNow = Instant.ofEpochMilli(1726604289530L);
        Instant remoteNow = localNow.minus(2L, ChronoUnit.HOURS);
        this.rw = new RecordWriter((BulkWriterContext)this.writerContext, COLUMN_NAMES, () -> this.tc, (wc, path, dp, pid) -> new SortedSSTableWriter((SSTableWriter)this.tw, this.folder, this.digestAlgorithm, pid));
        this.writerContext.setTimeSkewTooLargeException(new TimeSkewTooLargeException(60, localNow, remoteNow, "test-cluster"));
        Iterator<Tuple2<DecoratedKey, Object[]>> data = this.generateData();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rw.write(data)).isInstanceOf(TimeSkewTooLargeException.class)).hasMessage("Time skew between Spark and Cassandra is too large. allowableSkewInMinutes=60, localTime=2024-09-17T20:18:09.530Z, remoteCassandraTime=2024-09-17T18:18:09.530Z, clusterId=test-cluster");
    }

    private void validateSuccessfulWrite(MockBulkWriterContext writerContext, Iterator<Tuple2<DecoratedKey, Object[]>> data, String[] columnNames) throws InterruptedException {
        this.validateSuccessfulWrite(writerContext, data, columnNames, 48, new CountDownLatch(0));
    }

    private void validateSuccessfulWrite(MockBulkWriterContext writerContext, Iterator<Tuple2<DecoratedKey, Object[]>> data, String[] columnNames, int expectedUploads, CountDownLatch uploadsLatch) throws InterruptedException {
        RecordWriter rw = new RecordWriter((BulkWriterContext)writerContext, columnNames, () -> this.tc, SortedSSTableWriter::new);
        rw.write(data);
        uploadsLatch.await(1L, TimeUnit.SECONDS);
        Map<CassandraInstance, List<UploadRequest>> uploads = writerContext.getUploads();
        Assertions.assertThat((int)uploads.keySet().size()).isEqualTo(3);
        Assertions.assertThat((int)uploads.values().stream().mapToInt(List::size).sum()).isEqualTo(expectedUploads);
        List requests = uploads.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (UploadRequest ur : requests) {
            Assertions.assertThat((Object)ur.digest).isNotNull();
        }
    }

    private Iterator<Tuple2<DecoratedKey, Object[]>> generateData() {
        return this.generateData(false, false);
    }

    private Iterator<Tuple2<DecoratedKey, Object[]>> generateData(boolean withTTL, boolean withTimestamp) {
        return this.generateData(270, this.range, false, withTTL, withTimestamp);
    }

    private Iterator<Tuple2<DecoratedKey, Object[]>> generateDataWithFakeToken(int numValues, Range<BigInteger> range) {
        return this.generateData(numValues, range, true, false, false);
    }

    private Iterator<Tuple2<DecoratedKey, Object[]>> generateData(int rowsCount, Range<BigInteger> tokenRange, boolean fakeTokens, boolean withTTL, boolean withTimestamp) {
        String courseString = IntStream.range(0, 100000).boxed().map(i -> "Long long string").collect(Collectors.joining());
        Stream<Tuple2> source = IntStream.iterate(0, integer -> integer + 1).mapToObj(index -> {
            Object[] columns = withTTL && withTimestamp ? new Object[]{index, index, courseString, index, index * 100, System.currentTimeMillis() * 1000L} : (withTimestamp ? new Object[]{index, index, courseString, index, System.currentTimeMillis() * 1000L} : (withTTL ? new Object[]{index, index, courseString, index, index * 100} : new Object[]{index, index, courseString, index}));
            return Tuple2.apply((Object)this.tokenizer.getDecoratedKey(columns), (Object)columns);
        });
        if (!fakeTokens) {
            source = source.filter(val -> tokenRange.contains((Comparable)((DecoratedKey)val._1).getToken()));
        }
        Stream<Tuple2> limitedStream = source.limit(rowsCount);
        List sortedData = limitedStream.sorted(Comparator.comparing(tuple -> ((DecoratedKey)tuple._1()).getToken())).collect(Collectors.toList());
        if (fakeTokens) {
            BigInteger currentToken = ((BigInteger)tokenRange.lowerEndpoint()).add(BigInteger.ONE);
            int i2 = 0;
            while (i2 < sortedData.size()) {
                Tuple2 item = (Tuple2)sortedData.get(i2);
                DecoratedKey key = (DecoratedKey)item._1();
                item = Tuple2.apply((Object)new DecoratedKey(currentToken, key.getKey()), (Object)((Object[])item._2()));
                sortedData.set(i2, item);
                ++i2;
                currentToken = currentToken.add(BigInteger.ONE);
            }
        }
        return sortedData.iterator();
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Object[]> data() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

