/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.movement;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.movement.NodeMovementMultiDCTest;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;

class NodeMovementMultiDCFailureTest
extends NodeMovementMultiDCTest {
    NodeMovementMultiDCFailureTest() {
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperMultiDCMovingNodeFailure.transitioningStateStart;
    }

    @Override
    protected void beforeClusterShutdown() {
        this.completeTransitionAndValidateWrites(BBHelperMultiDCMovingNodeFailure.transitioningStateEnd, NodeMovementMultiDCFailureTest.multiDCTestInputs(), true);
    }

    @Override
    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().instanceInitializer(BBHelperMultiDCMovingNodeFailure::install);
    }

    public static class BBHelperMultiDCMovingNodeFailure {
        static final CountDownLatch transitioningStateStart = new CountDownLatch(1);
        static final CountDownLatch transitioningStateEnd = new CountDownLatch(1);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber == 3) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.RangeRelocator").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"stream")).intercept((Implementation)MethodDelegation.to(BBHelperMultiDCMovingNodeFailure.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static Future<?> stream(@SuperCall Callable<Future<?>> orig) throws Exception {
            Future<?> res = orig.call();
            transitioningStateStart.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)transitioningStateEnd, (long)2L, (TimeUnit)TimeUnit.MINUTES);
            throw new IOException("Simulated node movement failure");
        }
    }
}

