/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.management.MBeanServerConnection;
import org.gridkit.jvmtool.GlobHelper;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cli.TimeIntervalConverter;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadDumpSampler;
import org.gridkit.jvmtool.stacktrace.ThreadMXBeanEx;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class StackCaptureCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "stcap";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new StCap(host);
    }

    @Parameters(commandDescription="[Stack Capture] Dumps stack traces to file for further processing")
    public static class StCap
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @Parameter(names={"-i", "--sampler-interval"}, converter=TimeIntervalConverter.class, description="Interval between polling MBeans")
        private long samplerIntervalMS = 0L;
        @Parameter(names={"-f", "--filter"}, description="Filter threads by name (Java RegEx syntax)")
        private String threadFilter = ".*";
        @Parameter(names={"-e", "--empty"}, description="Retain threads without stack trace in dump (ignored by default)")
        private boolean retainEmptyTraces = false;
        @Parameter(names={"-m", "--match-frame"}, variableArity=true, description="Frame filter, only traces conatining this string will be included to dump")
        private List<String> frameFilter;
        @Parameter(names={"-o", "--output"}, required=true, description="Name of file to write thread dump to")
        private String outputFile;
        @Parameter(names={"-l", "--limit"}, description="Target number of traces to collect, once reached command will terminate (0 - unlimited)")
        private long limit = 0L;
        @Parameter(names={"-t", "--timeout"}, converter=TimeIntervalConverter.class, description="Time until command terminate even without enough traces collected")
        private long timeoutMS = TimeUnit.SECONDS.toMillis(30L);
        @Parameter(names={"-r", "--rotate"}, description="If specified output file would be rotated every N traces (0 - do not rotate)")
        private long fileLimit = 0L;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;
        private ThreadDumpSampler sampler;
        private long traceCounter = 0L;
        private long lastRotate = 0L;
        private int rotSeg = 0;
        private StackTraceWriter writer;

        public StCap(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                MBeanServerConnection mserver = this.connInfo.getMServer();
                ThreadMXBean bean = ThreadMXBeanEx.BeanHelper.connectThreadMXBean(mserver);
                this.sampler = new ThreadDumpSampler();
                this.sampler.setThreadFilter(this.threadFilter);
                this.sampler.connect(bean);
                if (this.limit == 0L) {
                    this.limit = Long.MAX_VALUE;
                }
                StackWriterProxy proxy = new StackWriterProxy();
                this.openWriter();
                long deadline = System.currentTimeMillis() + this.timeoutMS;
                long nextReport = 500L;
                while (System.currentTimeMillis() < deadline && this.traceCounter < this.limit) {
                    long nextsample = System.currentTimeMillis() + this.samplerIntervalMS;
                    this.sampler.collect(proxy);
                    if (this.traceCounter >= nextReport) {
                        System.out.println("Collected " + this.traceCounter);
                        while (this.traceCounter >= nextReport) {
                            nextReport += 500L;
                        }
                        this.checkRotate();
                    }
                    while (nextsample > System.currentTimeMillis()) {
                        long st = nextsample - System.currentTimeMillis();
                        if (st <= 0L) continue;
                        Thread.sleep(st);
                    }
                }
                this.writer.close();
                System.out.println("Trace dumped: " + this.traceCounter);
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
            }
        }

        private void checkRotate() throws FileNotFoundException, IOException {
            if (this.fileLimit > 0L && this.traceCounter - this.lastRotate > this.fileLimit) {
                this.writer.close();
                ++this.rotSeg;
                this.lastRotate = this.traceCounter;
                this.openWriter();
            }
        }

        private void openWriter() throws FileNotFoundException, IOException {
            if (this.fileLimit < 1L) {
                File file = new File(this.outputFile);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                this.writer = StackTraceCodec.newWriter(new FileOutputStream(file));
                System.out.println("Writing to " + file.getAbsolutePath());
            } else {
                int c = this.outputFile.lastIndexOf(46);
                String pref = c < 0 ? this.outputFile : this.outputFile.substring(0, c);
                String suf = c < 0 ? "" : this.outputFile.substring(c);
                String name = pref + String.format("-%02d", this.rotSeg) + suf;
                File file = new File(name);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                this.writer = StackTraceCodec.newWriter(new FileOutputStream(file));
                System.out.println("Writing to " + file.getAbsolutePath());
            }
        }

        private class StackWriterProxy
        implements StackTraceWriter {
            private Map<StackFrame, Boolean> elementCache = new HashMap<StackFrame, Boolean>();
            private Matcher[] matchers;

            public StackWriterProxy() {
                if (StCap.this.frameFilter != null) {
                    this.matchers = new Matcher[StCap.this.frameFilter.size()];
                    for (int i = 0; i != StCap.this.frameFilter.size(); ++i) {
                        this.matchers[i] = GlobHelper.translate((String)StCap.this.frameFilter.get(i), ".").matcher("");
                    }
                }
            }

            @Override
            public void write(ThreadSnapshot snap) throws IOException {
                if (snap.stackTrace().isEmpty() && !StCap.this.retainEmptyTraces) {
                    return;
                }
                if (StCap.this.frameFilter != null) {
                    boolean match = false;
                    for (StackFrame e : snap.stackTrace()) {
                        if (!this.match(e)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        return;
                    }
                }
                ++StCap.this.traceCounter;
                StCap.this.writer.write(snap);
            }

            private boolean match(StackFrame e) {
                Boolean cached = this.elementCache.get(e);
                if (cached == null) {
                    if (this.elementCache.size() > 4096) {
                        this.elementCache.clear();
                    }
                    boolean matched = false;
                    for (Matcher m3 : this.matchers) {
                        m3.reset(e.toString());
                        if (!m3.lookingAt()) continue;
                        matched = true;
                        break;
                    }
                    this.elementCache.put(e, matched);
                    return matched;
                }
                return cached;
            }

            @Override
            public void close() {
                StCap.this.writer.close();
            }
        }
    }
}

