/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTextSerializer
extends TypeSerializer<String> {
    private final Charset charset;

    protected AbstractTextSerializer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public <V> String deserialize(V value, ValueAccessor<V> accessor) {
        try {
            return accessor.toString(value, this.charset);
        }
        catch (CharacterCodingException e) {
            throw new MarshalException("Invalid " + this.charset + " bytes " + accessor.toHex(value));
        }
    }

    @Override
    public ByteBuffer serialize(String value) {
        return ByteBufferUtil.bytes(value, this.charset);
    }

    @Override
    public String toString(String value) {
        return value;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String toCQLLiteral(ByteBuffer buffer) {
        return buffer == null ? "null" : '\'' + StringUtils.replace((String)((String)this.deserialize(buffer)), (String)"'", (String)"''") + '\'';
    }
}

