/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.SyncResponse;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingRepairTask
implements Runnable,
StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StreamingRepairTask.class);
    private final RepairJobDesc desc;
    private final boolean asymmetric;
    private final InetAddressAndPort initiator;
    private final InetAddressAndPort src;
    private final InetAddressAndPort dst;
    private final Collection<Range<Token>> ranges;
    private final UUID pendingRepair;
    private final PreviewKind previewKind;

    public StreamingRepairTask(RepairJobDesc desc, InetAddressAndPort initiator, InetAddressAndPort src, InetAddressAndPort dst, Collection<Range<Token>> ranges, UUID pendingRepair, PreviewKind previewKind, boolean asymmetric) {
        this.desc = desc;
        this.initiator = initiator;
        this.src = src;
        this.dst = dst;
        this.ranges = ranges;
        this.asymmetric = asymmetric;
        this.pendingRepair = pendingRepair;
        this.previewKind = previewKind;
    }

    @Override
    public void run() {
        logger.info("[streaming task #{}] Performing {}streaming repair of {} ranges with {}", new Object[]{this.desc.sessionId, this.asymmetric ? "asymmetric " : "", this.ranges.size(), this.dst});
        long start = MonotonicClock.approxTime.now();
        StreamPlan streamPlan = this.createStreamPlan(this.dst);
        logger.info("[streaming task #{}] Stream plan created in {}ms", (Object)this.desc.sessionId, (Object)TimeUnit.MILLISECONDS.convert(MonotonicClock.approxTime.now() - start, TimeUnit.NANOSECONDS));
        streamPlan.execute();
    }

    @VisibleForTesting
    StreamPlan createStreamPlan(InetAddressAndPort dest) {
        StreamPlan sp = new StreamPlan(StreamOperation.REPAIR, 1, false, this.pendingRepair, this.previewKind).listeners(this, new StreamEventHandler[0]).flushBeforeTransfer(this.pendingRepair == null).requestRanges(dest, this.desc.keyspace, RangesAtEndpoint.toDummyList(this.ranges), RangesAtEndpoint.toDummyList(Collections.emptyList()), this.desc.columnFamily);
        if (!this.asymmetric) {
            sp.transferRanges(dest, this.desc.keyspace, RangesAtEndpoint.toDummyList(this.ranges), this.desc.columnFamily);
        }
        return sp;
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
    }

    @Override
    public void onSuccess(StreamState state) {
        logger.info("[repair #{}] streaming task succeed, returning response to {}", (Object)this.desc.sessionId, (Object)this.initiator);
        MessagingService.instance().send(Message.out(Verb.SYNC_RSP, new SyncResponse(this.desc, this.src, this.dst, true, state.createSummaries())), this.initiator);
    }

    @Override
    public void onFailure(Throwable t) {
        MessagingService.instance().send(Message.out(Verb.SYNC_RSP, new SyncResponse(this.desc, this.src, this.dst, false, Collections.emptyList())), this.initiator);
    }
}

