/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InOurDcTester;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

public class Replicas {
    public static int countFull(ReplicaCollection<?> replicas) {
        int count = 0;
        for (Replica replica : replicas) {
            if (!replica.isFull()) continue;
            ++count;
        }
        return count;
    }

    public static ReplicaCount countInOurDc(ReplicaCollection<?> replicas) {
        ReplicaCount count = new ReplicaCount();
        Predicate<Replica> inOurDc = InOurDcTester.replicas();
        for (Replica replica : replicas) {
            if (!inOurDc.test(replica)) continue;
            count.increment(replica);
        }
        return count;
    }

    public static ObjectObjectHashMap<String, ReplicaCount> countPerDc(Collection<String> dataCenters, Iterable<Replica> replicas) {
        ObjectObjectHashMap<String, ReplicaCount> perDc = new ObjectObjectHashMap<String, ReplicaCount>(dataCenters.size());
        for (String dc : dataCenters) {
            perDc.put(dc, new ReplicaCount());
        }
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        for (Replica replica : replicas) {
            String dc = snitch.getDatacenter(replica);
            perDc.get(dc).increment(replica);
        }
        return perDc;
    }

    public static void addToCountPerDc(ObjectIntHashMap<String> perDc, Iterable<Replica> replicas, int add) {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        for (Replica replica : replicas) {
            String dc = snitch.getDatacenter(replica);
            perDc.addTo(dc, add);
        }
    }

    public static void temporaryAssertFull(Replica replica) {
        if (!replica.isFull()) {
            throw new UnsupportedOperationException("transient replicas are currently unsupported: " + replica);
        }
    }

    public static void temporaryAssertFull(Iterable<Replica> replicas) {
        if (!Iterables.all(replicas, Replica::isFull)) {
            throw new UnsupportedOperationException("transient replicas are currently unsupported: " + Iterables.toString(replicas));
        }
    }

    public static void assertFull(Iterable<Replica> replicas) {
        if (!Iterables.all(replicas, Replica::isFull)) {
            throw new UnsupportedOperationException("transient replicas are currently unsupported: " + Iterables.toString(replicas));
        }
    }

    public static List<String> stringify(ReplicaCollection<?> replicas, boolean withPort) {
        ArrayList<String> stringEndpoints = new ArrayList<String>(replicas.size());
        for (Replica replica : replicas) {
            stringEndpoints.add(replica.endpoint().getHostAddress(withPort));
        }
        return stringEndpoints;
    }

    public static class ReplicaCount {
        int fullReplicas;
        int transientReplicas;

        public int allReplicas() {
            return this.fullReplicas + this.transientReplicas;
        }

        public int fullReplicas() {
            return this.fullReplicas;
        }

        public int transientReplicas() {
            return this.transientReplicas;
        }

        public void increment(Replica replica) {
            if (replica.isFull()) {
                ++this.fullReplicas;
            } else {
                ++this.transientReplicas;
            }
        }

        public boolean hasAtleast(int allReplicas, int fullReplicas) {
            return this.fullReplicas >= fullReplicas && this.allReplicas() >= allReplicas;
        }
    }
}

