/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.clustered;

import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.MultiMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.AddressHelper;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.EventBusOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageCodec;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.CodecManager;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.EventBusImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.HandlerHolder;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.HandlerRegistration;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.MessageImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.clustered.ClusteredHandlerHolder;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.clustered.ConnectionHolder;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.clustered.Serializer;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.CloseFuture;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.future.PromiseInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.Logger;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.LoggerFactory;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetClient;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetClientOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetServer;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetServerOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.NetClientBuilder;
import o.a.c.sidecar.client.shaded.io.vertx.core.parsetools.RecordParser;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.cluster.ClusterManager;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.cluster.NodeInfo;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.cluster.NodeSelector;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.cluster.RegistrationInfo;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.VertxMetrics;

public class ClusteredEventBus
extends EventBusImpl {
    private static final Logger log = LoggerFactory.getLogger(ClusteredEventBus.class);
    private static final Buffer PONG = Buffer.buffer(new byte[]{1});
    private final EventBusOptions options;
    private final ClusterManager clusterManager;
    private final NodeSelector nodeSelector;
    private final AtomicLong handlerSequence = new AtomicLong(0L);
    private final NetClient client;
    private final ConcurrentMap<String, ConnectionHolder> connections = new ConcurrentHashMap<String, ConnectionHolder>();
    private final CloseFuture closeFuture;
    private final ContextInternal ebContext;
    private NodeInfo nodeInfo;
    private String nodeId;
    private NetServer server;

    public ClusteredEventBus(VertxInternal vertx, VertxOptions options, ClusterManager clusterManager, NodeSelector nodeSelector) {
        super(vertx);
        this.options = options.getEventBusOptions();
        this.clusterManager = clusterManager;
        this.nodeSelector = nodeSelector;
        this.closeFuture = new CloseFuture(log);
        this.ebContext = vertx.createEventLoopContext(null, this.closeFuture, null, Thread.currentThread().getContextClassLoader());
        this.client = this.createNetClient(vertx, new NetClientOptions(this.options.toJson()), this.closeFuture);
    }

    private NetClient createNetClient(VertxInternal vertx, NetClientOptions clientOptions, CloseFuture closeFuture) {
        NetClientBuilder builder = new NetClientBuilder(vertx, clientOptions);
        VertxMetrics metricsSPI = vertx.metricsSPI();
        if (metricsSPI != null) {
            builder.metrics(metricsSPI.createNetClientMetrics(clientOptions));
        }
        builder.closeFuture(closeFuture);
        return builder.build();
    }

    NetClient client() {
        return this.client;
    }

    private NetServerOptions getServerOptions() {
        return new NetServerOptions(this.options.toJson());
    }

    @Override
    public void start(Promise<Void> promise) {
        NetServerOptions serverOptions = this.getServerOptions();
        this.server = this.vertx.createNetServer(serverOptions);
        this.server.connectHandler(this.getServerHandler());
        int port = this.getClusterPort();
        String host = this.getClusterHost();
        this.ebContext.runOnContext(v -> this.server.listen(port, host).flatMap(v2 -> {
            int publicPort = this.getClusterPublicPort(this.server.actualPort());
            String publicHost = this.getClusterPublicHost(host);
            this.nodeInfo = new NodeInfo(publicHost, publicPort, this.options.getClusterNodeMetadata());
            this.nodeId = this.clusterManager.getNodeId();
            Promise<Void> setPromise = Promise.promise();
            this.clusterManager.setNodeInfo(this.nodeInfo, setPromise);
            return setPromise.future();
        }).andThen(ar -> {
            if (ar.succeeded()) {
                this.started = true;
                this.nodeSelector.eventBusStarted();
            }
        }).onComplete(promise));
    }

    @Override
    public void close(Promise<Void> promise) {
        Promise<Void> parentClose = Promise.promise();
        super.close(parentClose);
        parentClose.future().transform(ar -> this.closeFuture.close()).andThen(ar -> {
            if (this.server != null) {
                for (ConnectionHolder holder : this.connections.values()) {
                    holder.close();
                }
            }
        }).onComplete(promise);
    }

    @Override
    public MessageImpl createMessage(boolean send, boolean isLocal, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName, isLocal);
        ClusteredMessage msg = new ClusteredMessage(this.nodeId, address, headers, body, codec, send, this);
        return msg;
    }

    @Override
    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        if (!handlerHolder.isReplyHandler()) {
            RegistrationInfo registrationInfo = new RegistrationInfo(this.nodeId, handlerHolder.getSeq(), handlerHolder.isLocalOnly());
            this.clusterManager.addRegistration(handlerHolder.getHandler().address, registrationInfo, Objects.requireNonNull(promise));
        } else if (promise != null) {
            promise.complete();
        }
    }

    @Override
    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, ContextInternal context) {
        return new ClusteredHandlerHolder<T>(registration, replyHandler, localOnly, context, this.handlerSequence.getAndIncrement());
    }

    @Override
    protected <T> void onLocalUnregistration(HandlerHolder<T> handlerHolder, Promise<Void> completionHandler) {
        if (!handlerHolder.isReplyHandler()) {
            RegistrationInfo registrationInfo = new RegistrationInfo(this.nodeId, handlerHolder.getSeq(), handlerHolder.isLocalOnly());
            Promise<Void> promise = Promise.promise();
            this.clusterManager.removeRegistration(handlerHolder.getHandler().address, registrationInfo, promise);
            promise.future().onComplete(completionHandler);
        } else {
            completionHandler.complete();
        }
    }

    @Override
    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        if (((ClusteredMessage)sendContext.message).getRepliedTo() != null) {
            this.clusteredSendReply(((ClusteredMessage)sendContext.message).getRepliedTo(), sendContext);
        } else if (sendContext.options.isLocalOnly()) {
            super.sendOrPub(sendContext);
        } else {
            Serializer serializer = Serializer.get(sendContext.ctx);
            if (sendContext.message.isSend()) {
                PromiseInternal promise = sendContext.ctx.promise();
                serializer.queue(sendContext.message, this.nodeSelector::selectForSend, promise);
                promise.future().onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.sendToNode(sendContext, (String)ar.result());
                    } else {
                        this.sendOrPublishFailed(sendContext, ar.cause());
                    }
                });
            } else {
                PromiseInternal promise = sendContext.ctx.promise();
                serializer.queue(sendContext.message, this.nodeSelector::selectForPublish, promise);
                promise.future().onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.sendToNodes(sendContext, (Iterable)ar.result());
                    } else {
                        this.sendOrPublishFailed(sendContext, ar.cause());
                    }
                });
            }
        }
    }

    private void sendOrPublishFailed(OutboundDeliveryContext<?> sendContext, Throwable cause) {
        if (log.isDebugEnabled()) {
            log.error("Failed to send message", cause);
        }
        sendContext.written(cause);
    }

    @Override
    protected String generateReplyAddress() {
        return "__vertx.reply." + UUID.randomUUID().toString();
    }

    @Override
    protected boolean isMessageLocal(MessageImpl msg) {
        ClusteredMessage clusteredMessage = (ClusteredMessage)msg;
        return !clusteredMessage.isFromWire();
    }

    @Override
    protected HandlerHolder nextHandler(ConcurrentCyclicSequence<HandlerHolder> handlers, boolean messageLocal) {
        HandlerHolder handlerHolder = null;
        if (messageLocal) {
            handlerHolder = handlers.next();
        } else {
            Iterator<HandlerHolder> iterator = handlers.iterator(false);
            while (iterator.hasNext()) {
                HandlerHolder next = iterator.next();
                if (!next.isReplyHandler() && next.isLocalOnly()) continue;
                handlerHolder = next;
                break;
            }
        }
        return handlerHolder;
    }

    private int getClusterPort() {
        return this.options.getPort();
    }

    private String getClusterHost() {
        String host = this.options.getHost();
        if (host != null) {
            return host;
        }
        host = this.clusterManager.clusterHost();
        if (host != null) {
            return host;
        }
        return AddressHelper.defaultAddress();
    }

    private int getClusterPublicPort(int actualPort) {
        int publicPort = this.options.getClusterPublicPort();
        return publicPort > 0 ? publicPort : actualPort;
    }

    private String getClusterPublicHost(String host) {
        String publicHost = this.options.getClusterPublicHost();
        if (publicHost != null) {
            return publicHost;
        }
        publicHost = this.options.getHost();
        if (publicHost != null) {
            return publicHost;
        }
        publicHost = this.clusterManager.clusterPublicHost();
        if (publicHost != null) {
            return publicHost;
        }
        return host;
    }

    private Handler<NetSocket> getServerHandler() {
        return socket -> {
            final RecordParser parser = RecordParser.newFixed(4);
            Handler<Buffer> handler = new Handler<Buffer>(){
                int size = -1;

                @Override
                public void handle(Buffer buff) {
                    if (this.size == -1) {
                        this.size = buff.getInt(0);
                        parser.fixedSizeMode(this.size);
                    } else {
                        ClusteredMessage received = new ClusteredMessage(ClusteredEventBus.this);
                        received.readFromWire(buff, ClusteredEventBus.this.codecManager);
                        if (ClusteredEventBus.this.metrics != null) {
                            ClusteredEventBus.this.metrics.messageRead(received.address(), buff.length());
                        }
                        parser.fixedSizeMode(4);
                        this.size = -1;
                        if (received.hasFailure()) {
                            received.internalError();
                        } else if (received.codec() == CodecManager.PING_MESSAGE_CODEC) {
                            socket.write(PONG);
                        } else {
                            ClusteredEventBus.this.deliverMessageLocally(received);
                        }
                    }
                }
            };
            parser.setOutput(handler);
            socket.handler((Handler)parser);
        };
    }

    private <T> void sendToNode(OutboundDeliveryContext<T> sendContext, String nodeId) {
        if (nodeId != null && !nodeId.equals(this.nodeId)) {
            this.sendRemote(sendContext, nodeId, sendContext.message);
        } else {
            super.sendOrPub(sendContext);
        }
    }

    private <T> void sendToNodes(OutboundDeliveryContext<T> sendContext, Iterable<String> nodeIds) {
        boolean sentRemote = false;
        if (nodeIds != null) {
            for (String nid : nodeIds) {
                if (!sentRemote) {
                    sentRemote = true;
                }
                this.sendToNode(sendContext, nid);
            }
        }
        if (!sentRemote) {
            super.sendOrPub(sendContext);
        }
    }

    private <T> void clusteredSendReply(String replyDest, OutboundDeliveryContext<T> sendContext) {
        MessageImpl message = sendContext.message;
        if (!replyDest.equals(this.nodeId)) {
            this.sendRemote(sendContext, replyDest, message);
        } else {
            super.sendOrPub(sendContext);
        }
    }

    private void sendRemote(OutboundDeliveryContext<?> sendContext, String remoteNodeId, MessageImpl message) {
        ConnectionHolder holder = (ConnectionHolder)this.connections.get(remoteNodeId);
        if (holder == null) {
            holder = new ConnectionHolder(this, remoteNodeId);
            ConnectionHolder prevHolder = this.connections.putIfAbsent(remoteNodeId, holder);
            if (prevHolder != null) {
                holder = prevHolder;
            } else {
                holder.connect();
            }
        }
        holder.writeMessage(sendContext);
    }

    ConcurrentMap<String, ConnectionHolder> connections() {
        return this.connections;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    EventBusOptions options() {
        return this.options;
    }
}

