/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// BuildLister helps list Builds.
// All objects returned here must be treated as read-only.
type BuildLister interface {
	// List lists all Builds in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.Build, err error)
	// Builds returns an object that can list and get Builds.
	Builds(namespace string) BuildNamespaceLister
	BuildListerExpansion
}

// buildLister implements the BuildLister interface.
type buildLister struct {
	listers.ResourceIndexer[*camelv1.Build]
}

// NewBuildLister returns a new BuildLister.
func NewBuildLister(indexer cache.Indexer) BuildLister {
	return &buildLister{listers.New[*camelv1.Build](indexer, camelv1.Resource("build"))}
}

// Builds returns an object that can list and get Builds.
func (s *buildLister) Builds(namespace string) BuildNamespaceLister {
	return buildNamespaceLister{listers.NewNamespaced[*camelv1.Build](s.ResourceIndexer, namespace)}
}

// BuildNamespaceLister helps list and get Builds.
// All objects returned here must be treated as read-only.
type BuildNamespaceLister interface {
	// List lists all Builds in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.Build, err error)
	// Get retrieves the Build from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*camelv1.Build, error)
	BuildNamespaceListerExpansion
}

// buildNamespaceLister implements the BuildNamespaceLister
// interface.
type buildNamespaceLister struct {
	listers.ResourceIndexer[*camelv1.Build]
}
