/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class AsymmetricEdDSAPublicKey
extends AsymmetricEdDSAKey
implements AsymmetricPublicKey {
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private final byte[] keyData;
    private final int hashCode;

    public AsymmetricEdDSAPublicKey(Algorithm algorithm, byte[] byArray) {
        super(algorithm);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsymmetricEdDSAPublicKey(byte[] byArray) {
        super(byArray[8] == 113 ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519);
        if (byArray[8] == 113) {
            if (!KeyUtils.isValidPrefix(Ed448Prefix, byArray) || byArray.length - Ed448Prefix.length != 57) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(byArray, Ed448Prefix.length, byArray.length);
        } else {
            if (!KeyUtils.isValidPrefix(Ed25519Prefix, byArray) || byArray.length - Ed25519Prefix.length != 32) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(byArray, Ed25519Prefix.length, byArray.length);
        }
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.keyData);
    }

    public byte[] getEncoded() {
        if (this.getAlgorithm().equals(EdEC.Algorithm.Ed448)) {
            byte[] byArray = new byte[Ed448Prefix.length + this.keyData.length];
            System.arraycopy(Ed448Prefix, 0, byArray, 0, Ed448Prefix.length);
            System.arraycopy(this.keyData, 0, byArray, Ed448Prefix.length, this.keyData.length);
            return byArray;
        }
        byte[] byArray = new byte[Ed25519Prefix.length + this.keyData.length];
        System.arraycopy(Ed25519Prefix, 0, byArray, 0, Ed25519Prefix.length);
        System.arraycopy(this.keyData, 0, byArray, Ed25519Prefix.length, this.keyData.length);
        return byArray;
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricEdDSAPublicKey)) {
            return false;
        }
        AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey = (AsymmetricEdDSAPublicKey)object;
        if (!Arrays.areEqual(this.keyData, asymmetricEdDSAPublicKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricEdDSAPublicKey.getAlgorithm());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }
}

