/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.remoting.impl.netty.ConnectionCreator;
import org.apache.activemq.artemis.core.remoting.impl.netty.HAProxyMessageEnforcer;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpAcceptorHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettySNIHostnameHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketFrameEncoderType;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketServerHandler;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ProxyProtocolUtil;
import org.apache.activemq.artemis.utils.SocketAddressUtil;

public class ProtocolHandler {
    private Map<String, ProtocolManager> protocolMap;
    private NettyAcceptor nettyAcceptor;
    private ScheduledExecutorService scheduledThreadPool;
    private HttpKeepAliveRunnable httpKeepAliveRunnable;
    private final List<String> websocketSubprotocolIds;

    public ProtocolHandler(Map<String, ProtocolManager> protocolMap, NettyAcceptor nettyAcceptor, ScheduledExecutorService scheduledThreadPool) {
        this.protocolMap = protocolMap;
        this.nettyAcceptor = nettyAcceptor;
        this.scheduledThreadPool = scheduledThreadPool;
        this.websocketSubprotocolIds = new ArrayList<String>();
        for (ProtocolManager pm : protocolMap.values()) {
            if (pm.websocketSubprotocolIdentifiers() == null) continue;
            this.websocketSubprotocolIds.addAll(pm.websocketSubprotocolIdentifiers());
        }
    }

    public Map<String, ProtocolManager> getProtocolMap() {
        return this.protocolMap;
    }

    public ChannelHandler getProtocolDecoder() {
        return new ProtocolDecoder(true, false);
    }

    public HttpKeepAliveRunnable getHttpKeepAliveRunnable() {
        return this.httpKeepAliveRunnable;
    }

    public void close() {
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
    }

    public ProtocolManager getProtocol(String name) {
        return this.protocolMap.get(name);
    }

    class ProtocolDecoder
    extends ByteToMessageDecoder {
        private static final String HTTP_HANDLER = "http-handler";
        private final boolean http;
        private final boolean httpEnabled;
        private ScheduledFuture<?> timeoutFuture;
        private int handshakeTimeout;
        private NettySNIHostnameHandler nettySNIHostnameHandler;

        ProtocolDecoder(boolean http, boolean httpEnabled) {
            this.http = http;
            this.httpEnabled = httpEnabled;
            this.handshakeTimeout = ConfigurationHelper.getIntProperty((String)"handshake-timeout", (int)10, ProtocolHandler.this.nettyAcceptor.getConfiguration());
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.nettySNIHostnameHandler = (NettySNIHostnameHandler)ctx.pipeline().get(NettySNIHostnameHandler.class);
            if (this.handshakeTimeout > 0) {
                this.timeoutFuture = ProtocolHandler.this.scheduledThreadPool.schedule(() -> {
                    ActiveMQServerLogger.LOGGER.handshakeTimeout(this.handshakeTimeout, ProtocolHandler.this.nettyAcceptor.getName(), ProxyProtocolUtil.getRemoteAddress((Channel)ctx.channel()));
                    ctx.channel().close();
                }, (long)this.handshakeTimeout, TimeUnit.SECONDS);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (this.handshakeTimeout > 0 && this.timeoutFuture != null) {
                this.timeoutFuture.cancel(true);
                this.timeoutFuture = null;
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest httpRequest = (FullHttpRequest)msg;
                HttpHeaders headers = httpRequest.headers();
                String upgrade = headers.get("upgrade");
                if (upgrade != null && upgrade.equalsIgnoreCase("websocket")) {
                    int stompMaxFramePayloadLength = ConfigurationHelper.getIntProperty((String)"stompMaxFramePayloadLength", (int)-1, ProtocolHandler.this.nettyAcceptor.getConfiguration());
                    if (stompMaxFramePayloadLength != -1) {
                        ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("stompMaxFramePayloadLength", "webSocketMaxFramePayloadLength");
                    }
                    stompMaxFramePayloadLength = stompMaxFramePayloadLength != -1 ? stompMaxFramePayloadLength : 65536;
                    int webSocketMaxFramePayloadLength = ConfigurationHelper.getIntProperty((String)"webSocketMaxFramePayloadLength", (int)-1, ProtocolHandler.this.nettyAcceptor.getConfiguration());
                    webSocketMaxFramePayloadLength = webSocketMaxFramePayloadLength != -1 ? webSocketMaxFramePayloadLength : stompMaxFramePayloadLength;
                    boolean enableCompression = ConfigurationHelper.getBooleanProperty((String)"webSocketCompressionSupported", (boolean)false, ProtocolHandler.this.nettyAcceptor.getConfiguration());
                    String encoderConfigType = ConfigurationHelper.getStringProperty((String)"webSocketEncoderType", (String)"binary", ProtocolHandler.this.nettyAcceptor.getConfiguration());
                    if (enableCompression) {
                        ctx.pipeline().addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                    }
                    ctx.pipeline().addLast("websocket-handler", (ChannelHandler)new WebSocketServerHandler(ProtocolHandler.this.websocketSubprotocolIds, webSocketMaxFramePayloadLength, WebSocketFrameEncoderType.valueOfType(encoderConfigType), enableCompression));
                    ctx.pipeline().addLast(new ChannelHandler[]{new ProtocolDecoder(false, false)});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.pipeline().remove(HTTP_HANDLER);
                    ctx.fireChannelRead(msg);
                } else if (upgrade != null && upgrade.equalsIgnoreCase("activemq-remoting")) {
                    ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            ProtocolManager protocolManagerToUse;
            Object bytes;
            if (ctx.isRemoved()) {
                return;
            }
            if (in.readableBytes() < 8) {
                return;
            }
            if (this.handshakeTimeout > 0 && this.timeoutFuture != null) {
                this.timeoutFuture.cancel(true);
                this.timeoutFuture = null;
            }
            if (HAProxyMessageEnforcer.isProxyProtocol(in)) {
                ActiveMQServerLogger.LOGGER.proxyProtocolViolation(SocketAddressUtil.toString((SocketAddress)ctx.channel().remoteAddress()), ProtocolHandler.this.nettyAcceptor.getName(), false, "used");
                ctx.channel().close();
            }
            if (this.http && this.isHttp(in)) {
                this.switchToHttp(ctx);
                return;
            }
            String protocolToUse = null;
            Set<String> protocolSet = ProtocolHandler.this.protocolMap.keySet();
            if (!protocolSet.isEmpty()) {
                bytes = new byte[8];
                in.getBytes(0, (byte[])bytes);
                for (String protocol : protocolSet) {
                    ProtocolManager protocolManager = ProtocolHandler.this.protocolMap.get(protocol);
                    if (!protocolManager.isProtocol((byte[])bytes)) continue;
                    protocolToUse = protocol;
                    break;
                }
            }
            if (protocolToUse == null) {
                bytes = ProtocolHandler.this.protocolMap.entrySet().iterator();
                while (bytes.hasNext()) {
                    Map.Entry entry = (Map.Entry)bytes.next();
                    if (!((ProtocolManager)entry.getValue()).acceptsNoHandshake()) continue;
                    protocolToUse = (String)entry.getKey();
                    break;
                }
                if (protocolToUse == null) {
                    protocolToUse = "CORE";
                }
            }
            if ((protocolManagerToUse = ProtocolHandler.this.protocolMap.get(protocolToUse)) == null) {
                ActiveMQServerLogger.LOGGER.failedToFindProtocolManager(ctx.channel() == null ? null : ProxyProtocolUtil.getRemoteAddress((Channel)ctx.channel()), ctx.channel() == null ? null : Objects.toString(ctx.channel().localAddress(), null), protocolToUse, ProtocolHandler.this.protocolMap.keySet().toString());
                return;
            }
            ConnectionCreator channelHandler = ProtocolHandler.this.nettyAcceptor.createConnectionCreator();
            ChannelPipeline pipeline = ctx.pipeline();
            protocolManagerToUse.addChannelHandlers(pipeline);
            pipeline.addLast("handler", (ChannelHandler)channelHandler);
            NettyServerConnection connection = channelHandler.createConnection(ctx, protocolToUse, this.httpEnabled);
            connection.setSNIHostname(this.nettySNIHostnameHandler != null ? this.nettySNIHostnameHandler.getHostname() : null);
            protocolManagerToUse.handshake(connection, (ActiveMQBuffer)new ChannelBufferWrapper(in));
            pipeline.remove((ChannelHandler)this);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            try {
                ActiveMQServerLogger.LOGGER.failureDuringProtocolHandshake(ctx.channel().localAddress(), ProxyProtocolUtil.getRemoteAddress((Channel)ctx.channel()), cause);
            }
            finally {
                ctx.close();
            }
        }

        private boolean isHttp(ByteBuf in) {
            short magic1 = in.getUnsignedByte(in.readerIndex());
            short magic2 = in.getUnsignedByte(in.readerIndex() + 1);
            return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82;
        }

        private void switchToHttp(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            p.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
            p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
            p.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
            if (ProtocolHandler.this.httpKeepAliveRunnable == null) {
                long httpServerScanPeriod = ConfigurationHelper.getLongProperty((String)"httpServerScanPeriod", (long)5000L, ProtocolHandler.this.nettyAcceptor.getConfiguration());
                ProtocolHandler.this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
                ScheduledFuture<?> future = ProtocolHandler.this.scheduledThreadPool.scheduleAtFixedRate(ProtocolHandler.this.httpKeepAliveRunnable, httpServerScanPeriod, httpServerScanPeriod, TimeUnit.MILLISECONDS);
                ProtocolHandler.this.httpKeepAliveRunnable.setFuture(future);
            }
            long httpResponseTime = ConfigurationHelper.getLongProperty((String)"httpResponseTime", (long)10000L, ProtocolHandler.this.nettyAcceptor.getConfiguration());
            HttpAcceptorHandler httpHandler = new HttpAcceptorHandler(ProtocolHandler.this.httpKeepAliveRunnable, httpResponseTime, ctx.channel());
            ctx.pipeline().addLast(HTTP_HANDLER, (ChannelHandler)httpHandler);
            p.addLast(new ChannelHandler[]{new ProtocolDecoder(false, true)});
            p.remove((ChannelHandler)this);
        }
    }
}

