/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.BeanProducer;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="1.0.0", scheme="bean", title="Bean", syntax="bean:beanName", producerOnly=true, label="core,java")
public class BeanEndpoint
extends DefaultEndpoint {
    private transient BeanHolder beanHolder;
    private transient BeanProcessor processor;
    @UriPath(description="Sets the name of the bean to invoke")
    @Metadata(required="true")
    private String beanName;
    @UriParam(description="Sets the name of the method to invoke on the bean")
    private String method;
    @UriParam(label="advanced", description="If enabled, Camel will cache the result of the first Registry look-up. Cache can be enabled if the bean in the Registry is defined as a singleton scope.")
    private Boolean cache;
    @UriParam(label="advanced", description="How to treat the parameters which are passed from the message body.true means the message body should be an array of parameters.")
    @Deprecated
    @Metadata(deprecationNode="This option is used internally by Camel, and is not intended for end users to use.")
    private boolean multiParameterArray;
    @UriParam(prefix="bean.", label="advanced", description="Used for configuring additional properties on the bean", multiValue=true)
    private Map<String, Object> parameters;

    public BeanEndpoint() {
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public BeanEndpoint(String endpointUri, Component component, BeanProcessor processor) {
        super(endpointUri, component);
        this.processor = processor;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public BeanEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new BeanProducer(this, this.processor);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from a bean endpoint");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public BeanProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.processor == null) {
            BeanHolder holder = this.getBeanHolder();
            if (holder == null) {
                RegistryBean registryBean = new RegistryBean(this.getCamelContext(), this.beanName);
                holder = this.isCache() ? registryBean.createCacheHolder() : registryBean;
            }
            this.processor = new BeanProcessor(holder);
            if (this.method != null) {
                this.processor.setMethod(this.method);
            }
            this.processor.setMultiParameterArray(this.isMultiParameterArray());
            this.processor.setCache(this.cache);
            if (this.parameters != null) {
                this.setProperties(this.processor, this.parameters);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    @Deprecated
    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public boolean isCache() {
        return this.cache != null ? this.cache : false;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public void setBeanHolder(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    protected String createEndpointUri() {
        return "bean:" + this.getBeanName() + (this.method != null ? "?method=" + this.method : "");
    }
}

