# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DESCRIPTION="Default unwindlib configuration for clang"
HOMEPAGE="https://clang.llvm.org/"
S=${WORKDIR}

LICENSE="public-domain"
SLOT="${PV}"
IUSE="default-compiler-rt llvm-libunwind"

RDEPEND="
	default-compiler-rt? (
		llvm-libunwind? ( >=llvm-runtimes/libunwind-${PV}[static-libs] )
		!llvm-libunwind? ( sys-libs/libunwind[static-libs] )
	)
	!default-compiler-rt? ( sys-devel/gcc )
"

src_install() {
	insinto "/etc/clang/${SLOT}"
	newins - gentoo-unwindlib.cfg <<-EOF
		# This file is initially generated by ${CATEGORY}/${PN}.
		# It is used to control the default unwindlib used by clang.

		--unwindlib=$(usex default-compiler-rt libunwind libgcc)
	EOF
}
