# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Examine values for unexpected thunks"
HOMEPAGE="https://hackage.haskell.org/package/nothunks"

LICENSE="Apache-2.0"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="+bytestring +text +vector"

CABAL_CHDEPS=(
	'hedgehog       >= 1.1 && < 1.3' 'hedgehog >= 1.1'
)

RDEPEND="
	>=dev-lang/ghc-8.10.6:=
	text? (
		|| (
			( >=dev-haskell/text-1.2 <dev-haskell/text-1.3 )
			( >=dev-haskell/text-2 <dev-haskell/text-2.1 )
		)
		dev-haskell/text:=[profile?]
	)
	vector? (
		>=dev-haskell/vector-0.12:=[profile?] <dev-haskell/vector-0.14:=[profile?]
	)
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.2.1.0
	test? (
		>=dev-haskell/hedgehog-1.1
		>=dev-haskell/random-1.1 <dev-haskell/random-1.3
		>=dev-haskell/tasty-1.3 <dev-haskell/tasty-1.5
		>=dev-haskell/tasty-hedgehog-1.1 <dev-haskell/tasty-hedgehog-1.5
	)
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag bytestring bytestring) \
		$(cabal_flag text text) \
		$(cabal_flag vector vector)
}
