/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private int resultNamespaceCode;

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String stylesheetPrefix = null;
        String resultPrefix = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("stylesheet-prefix")) {
                stylesheetPrefix = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("result-prefix")) {
                resultPrefix = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (stylesheetPrefix == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (stylesheetPrefix.equals("#default")) {
            stylesheetPrefix = "";
        }
        if (resultPrefix == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (resultPrefix.equals("#default")) {
            resultPrefix = "";
        }
        try {
            String ssURI = this.getURIForPrefix(stylesheetPrefix, true);
            if (ssURI == null) {
                this.compileError("stylesheet-prefix " + stylesheetPrefix + " has not been declared", "XTSE0812");
                this.stylesheetURICode = 0;
                this.resultNamespaceCode = 0;
                return;
            }
            this.stylesheetURICode = ssURI.equals("") ? (short)0 : this.getURICodeForPrefix(stylesheetPrefix);
            NamePool pool = this.getNamePool();
            String resultURI = this.getURIForPrefix(resultPrefix, true);
            if (resultURI == null) {
                this.compileError("result-prefix " + resultPrefix + " has not been declared", "XTSE0812");
                this.stylesheetURICode = 0;
                this.resultNamespaceCode = 0;
            } else {
                this.resultNamespaceCode = resultURI.equals("") ? 0 : pool.getNamespaceCode(resultPrefix, resultURI);
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage());
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkTopLevel(null);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return null;
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.addNamespaceAlias(decl);
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public int getResultNamespaceCode() {
        return this.resultNamespaceCode;
    }
}

