/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class IDFilter
extends XMLFilterImpl {
    private String id;
    private int activeDepth = 0;
    private Stack namespacePrefixes = new Stack();
    private Stack namespaceURIs = new Stack();

    public IDFilter(String string) {
        this.id = string;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.startPrefixMapping(string, string2);
        } else {
            this.namespacePrefixes.push(string);
            this.namespaceURIs.push(string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.activeDepth > 0) {
            super.endPrefixMapping(string);
        } else {
            this.namespacePrefixes.pop();
            this.namespaceURIs.pop();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.activeDepth == 0) {
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getType(n).equals("ID") && attributes.getValue(n).equals(this.id)) {
                    this.activeDepth = 1;
                    break;
                }
                ++n;
            }
            if (this.activeDepth == 1) {
                int n2 = 0;
                while (n2 < this.namespacePrefixes.size()) {
                    super.startPrefixMapping((String)this.namespacePrefixes.elementAt(n2), (String)this.namespaceURIs.elementAt(n2));
                    ++n2;
                }
            }
        } else {
            ++this.activeDepth;
        }
        if (this.activeDepth > 0) {
            super.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.activeDepth > 0) {
            super.endElement(string, string2, string3);
            --this.activeDepth;
            if (this.activeDepth == 0) {
                int n = this.namespacePrefixes.size() - 1;
                while (n >= 0) {
                    super.endPrefixMapping((String)this.namespacePrefixes.elementAt(n));
                    --n;
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.processingInstruction(string, string2);
        }
    }
}

