/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Step;
import java.util.logging.Logger;
import net.sf.saxon.s9api.XdmNode;

public class Pipe
implements ReadablePipe,
WritablePipe {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static int idCounter = 0;
    private int id = 0;
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private int pos = 0;
    private boolean readSeqOk = false;
    private boolean writeSeqOk = false;
    private Step writer = null;
    private Step reader = null;

    public Pipe(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.documents = new DocumentSequence(xProcRuntime);
        this.documents.addReader();
        this.id = idCounter++;
    }

    public Pipe(XProcRuntime xProcRuntime, DocumentSequence documentSequence) {
        this.runtime = xProcRuntime;
        this.documents = documentSequence;
        documentSequence.addReader();
        this.id = ++idCounter;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void canWriteSequence(boolean bl) {
        this.writeSeqOk = bl;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void resetWriter() {
        this.documents.reset();
        this.pos = 0;
    }

    @Override
    public void canReadSequence(boolean bl) {
        this.readSeqOk = bl;
    }

    @Override
    public boolean readSequence() {
        return this.readSeqOk;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    @Override
    public boolean moreDocuments() {
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return this.documents.closed();
    }

    @Override
    public void close() {
        this.documents.close();
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() {
        if (this.pos > 0 && !this.readSeqOk) {
            throw XProcException.dynamicError(6);
        }
        XdmNode xdmNode = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    @Override
    public void write(XdmNode xdmNode) {
        if (this.writer != null) {
            this.runtime.finest(null, this.writer.getNode(), this.writer.getName() + " wrote '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' to " + this);
        }
        this.documents.add(xdmNode);
        if (this.documents.size() > 1 && !this.writeSeqOk) {
            throw XProcException.dynamicError(7);
        }
    }

    public String toString() {
        return "[pipe #" + this.id + "] (" + this.documents + ")";
    }
}

