/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class FormatNumber
extends Function {
    private DecimalFormat decimalFormat = new DecimalFormat();
    private String previousFormat = "[null]";
    private DecimalFormatSymbols previousDFS = null;
    private Controller boundController = null;

    public String getName() {
        return "format-number";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(2, 3);
        this.argument[0] = this.argument[0].simplify();
        this.argument[1] = this.argument[1].simplify();
        if (n == 3) {
            this.argument[2] = this.argument[2].simplify();
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        DecimalFormatSymbols decimalFormatSymbols;
        int n = this.getNumberOfArguments();
        Controller controller = this.boundController;
        if (controller == null) {
            controller = context.getController();
        }
        DecimalFormatManager decimalFormatManager = controller.getDecimalFormatManager();
        double d = this.argument[0].evaluateAsNumber(context);
        String string = this.argument[1].evaluateAsString(context);
        if (n == 2) {
            decimalFormatSymbols = decimalFormatManager.getDefaultDecimalFormat();
        } else {
            String string2 = this.argument[2].evaluateAsString(context);
            int n2 = this.getStaticContext().getFingerprint(string2, false);
            decimalFormatSymbols = decimalFormatManager.getNamedDecimalFormat(n2);
            if (decimalFormatSymbols == null) {
                throw new XPathException("format-number function: decimal-format " + string2 + " not registered");
            }
        }
        return this.formatNumber(d, string, decimalFormatSymbols);
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public synchronized String formatNumber(double d, String string, DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
        try {
            DecimalFormat decimalFormat = this.decimalFormat;
            if (decimalFormatSymbols != this.previousDFS || !string.equals(this.previousFormat)) {
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                decimalFormat.applyLocalizedPattern(string);
                this.previousDFS = decimalFormatSymbols;
                this.previousFormat = string;
            }
            return decimalFormat.format(d);
        }
        catch (Exception exception) {
            throw new XPathException("Unable to interpret format pattern " + string + " (" + exception + ")");
        }
    }

    public int getDependencies() {
        int n = 0;
        if (this.boundController == null) {
            n = 64;
        }
        n |= this.argument[0].getDependencies();
        n |= this.argument[1].getDependencies();
        if (this.getNumberOfArguments() == 3) {
            n |= this.argument[2].getDependencies();
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        FormatNumber formatNumber = new FormatNumber();
        formatNumber.addArgument(this.argument[0].reduce(n, context));
        formatNumber.addArgument(this.argument[1].reduce(n, context));
        if (this.getNumberOfArguments() == 3) {
            formatNumber.addArgument(this.argument[2].reduce(n, context));
        }
        if ((n & 0x40) != 0) {
            formatNumber.boundController = context.getController();
        }
        formatNumber.setStaticContext(this.getStaticContext());
        return formatNumber;
    }
}

