/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.exslt;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public final class Date {
    private Date() {
    }

    public static String dateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        char c = '+';
        if (n < 0) {
            c = '-';
            n = -n;
        }
        int n2 = n / 60000;
        int n3 = n2 / 60;
        n2 %= 60;
        String string = "" + n3;
        while (string.length() < 2) {
            string = "0" + string;
        }
        String string2 = "" + n2;
        while (string2.length() < 2) {
            string2 = "0" + string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String string3 = simpleDateFormat.format(new java.util.Date());
        return string3 + c + string + ':' + string2;
    }

    public static String date(String string) {
        int n = 0;
        if (string.length() >= 1 && (string.charAt(0) == '-' || string.charAt(0) == '+')) {
            n = 1;
        }
        if (string.length() >= n + 10) {
            return string.substring(0, n + 10);
        }
        return "";
    }

    public static String date() {
        return Date.date(Date.dateTime());
    }

    public static String time(String string) {
        int n = string.indexOf(84);
        if (n < 0 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String time() {
        return Date.time(Date.dateTime());
    }

    public static double year(String string) {
        if (string.startsWith("-")) {
            return Double.NaN;
        }
        try {
            return Integer.parseInt(string.substring(0, 4));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double year() {
        return Date.year(Date.dateTime());
    }

    public static boolean leapYear(String string) {
        double d = Date.year(string);
        if (Double.isNaN(d)) {
            return false;
        }
        int n = (int)d;
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static boolean leapYear() {
        return Date.leapYear(Date.dateTime());
    }

    public static double monthInYear(String string) {
        try {
            if (string.startsWith("--")) {
                return Integer.parseInt(string.substring(2, 4));
            }
            if (string.indexOf(45) != 4) {
                return Double.NaN;
            }
            return Integer.parseInt(string.substring(5, 7));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double monthInYear() {
        return Date.monthInYear(Date.date());
    }

    public static String monthName(String string) {
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        double d = Date.monthInYear(string);
        if (Double.isNaN(d)) {
            return "";
        }
        return stringArray[(int)d - 1];
    }

    public static String monthName() {
        return Date.monthName(Date.date());
    }

    public static String monthAbbreviation(String string) {
        String[] stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double d = Date.monthInYear(string);
        if (Double.isNaN(d)) {
            return "";
        }
        return stringArray[(int)d - 1];
    }

    public static String monthAbbreviation() {
        return Date.monthAbbreviation(Date.date());
    }

    public static double weekInYear(String string) {
        int n = (int)Date.dayInYear(string);
        int n2 = ((int)Date.dayInWeek(string) + 5) % 7;
        String string2 = string.substring(0, 4) + "-01-01";
        int n3 = ((int)Date.dayInWeek(string2) + 5) % 7;
        int n4 = n3 == 0 ? 0 : 7 - n3;
        int n5 = (n - n4 + 6) / 7;
        if (n4 >= 4) {
            return n5 + 1;
        }
        if (n5 > 0) {
            return n5;
        }
        int n6 = Integer.parseInt(string.substring(0, 4)) - 1;
        String string3 = n6 + "-12-31";
        return Date.weekInYear(string3);
    }

    public static double weekInYear() {
        return Date.weekInYear(Date.date());
    }

    public static double weekInMonth(String string) {
        return (int)((Date.dayInMonth(string) - 1.0) / 7.0 + 1.0);
    }

    public static double weekInMonth() {
        return Date.weekInMonth(Date.date());
    }

    public static double dayInYear(String string) {
        int n = (int)Date.monthInYear(string);
        int n2 = (int)Date.dayInMonth(string);
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        int n3 = n > 2 && Date.leapYear(string) ? 1 : 0;
        return nArray[n - 1] + n3 + n2;
    }

    public static double dayInYear() {
        return Date.dayInYear(Date.date());
    }

    public static double dayInMonth(String string) {
        try {
            if (string.startsWith("---")) {
                return Integer.parseInt(string.substring(3, 5));
            }
            if (string.startsWith("--")) {
                return Integer.parseInt(string.substring(5, 7));
            }
            return Integer.parseInt(string.substring(8, 10));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double dayInMonth() {
        return Date.dayInMonth(Date.date());
    }

    public static double dayOfWeekInMonth(String string) {
        double d = Date.dayInMonth(string);
        if (Double.isNaN(d)) {
            return d;
        }
        return ((int)d - 1) / 7 + 1;
    }

    public static double dayOfWeekInMonth() {
        return Date.dayOfWeekInMonth(Date.date());
    }

    public static double dayInWeek(String string) {
        double d = Date.year(string);
        double d2 = Date.monthInYear(string);
        double d3 = Date.dayInMonth(string);
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar((int)d, (int)d2 - 1, (int)d3);
        gregorianCalendar.setFirstDayOfWeek(1);
        return gregorianCalendar.get(7);
    }

    public static double dayInWeek() {
        return Date.dayInWeek(Date.date());
    }

    public static String dayName(String string) {
        String[] stringArray = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        double d = Date.dayInWeek(string);
        if (Double.isNaN(d)) {
            return "";
        }
        return stringArray[(int)d - 1];
    }

    public static String dayName() {
        return Date.dayName(Date.date());
    }

    public static String dayAbbreviation(String string) {
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        double d = Date.dayInWeek(string);
        if (Double.isNaN(d)) {
            return "";
        }
        return stringArray[(int)d - 1];
    }

    public static String dayAbbreviation() {
        return Date.dayAbbreviation(Date.date());
    }

    public static double hourInDay(String string) {
        int n = string.indexOf(84);
        try {
            int n2 = Integer.parseInt(string.substring(n + 1, n + 3));
            return n2;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double hourInDay() {
        return Date.hourInDay(Date.time());
    }

    public static double minuteInHour(String string) {
        int n = string.indexOf(84);
        try {
            int n2 = Integer.parseInt(string.substring(n + 4, n + 6));
            return n2;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double minuteInHour() {
        return Date.minuteInHour(Date.time());
    }

    public static double secondInMinute(String string) {
        int n = string.indexOf(84);
        try {
            int n2 = Integer.parseInt(string.substring(n + 7, n + 9));
            return n2;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double secondInMinute() {
        return Date.secondInMinute(Date.time());
    }
}

