/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import com.nwalsh.xalan.FormatCallout;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormatGraphicCallout
extends FormatCallout {
    String graphicsPath = "";
    String graphicsExt = "";
    int graphicsMax = 0;
    String iconSize = "";

    public FormatGraphicCallout(String path, String ext, int max, String size, boolean fo) {
        this.graphicsPath = path;
        this.graphicsExt = ext;
        this.graphicsMax = max;
        this.stylesheetFO = fo;
        this.iconSize = size;
    }

    public void formatCallout(DOMBuilder rtf, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String label = this.areaLabel(area);
        String id = this.areaID(area);
        try {
            if (label == null && num <= this.graphicsMax) {
                AttributesImpl imgAttr = new AttributesImpl();
                String ns = "";
                String prefix = "";
                String imgName = "";
                if (this.stylesheetFO) {
                    ns = "http://www.w3.org/1999/XSL/Format";
                    prefix = "fo:";
                    imgName = "external-graphic";
                    imgAttr.addAttribute("", "src", "src", "CDATA", "url(" + this.graphicsPath + num + this.graphicsExt + ")");
                    imgAttr.addAttribute("", "id", "id", "ID", id);
                    imgAttr.addAttribute("", "content-width", "content-width", "CDATA", this.iconSize);
                    imgAttr.addAttribute("", "width", "width", "CDATA", this.iconSize);
                } else {
                    ns = "";
                    prefix = "";
                    imgName = "img";
                    imgAttr.addAttribute("", "src", "src", "CDATA", this.graphicsPath + num + this.graphicsExt);
                    imgAttr.addAttribute("", "alt", "alt", "CDATA", label);
                    imgAttr.addAttribute("", "id", "id", "ID", id);
                }
                this.startSpan(rtf, id);
                rtf.startElement(ns, imgName, prefix + imgName, (Attributes)imgAttr);
                rtf.endElement(ns, imgName, prefix + imgName);
                this.endSpan(rtf);
            } else {
                this.formatTextCallout(rtf, callout);
            }
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in graphics formatCallout");
        }
    }
}

