/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public final class Rounding
extends SystemFunction {
    public static final int FLOOR = 0;
    public static final int CEILING = 1;
    public static final int ROUND = 2;
    public static final int HALF_EVEN = 3;
    public static final int ABS = 4;

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue val0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (val0 == null) {
            return null;
        }
        NumericValue val = (NumericValue)val0;
        switch (this.operation) {
            case 0: {
                return val.floor();
            }
            case 1: {
                return val.ceiling();
            }
            case 2: {
                int scaleRnd = 0;
                if (this.argument.length == 2) {
                    AtomicValue scaleVal0 = (AtomicValue)this.argument[1].evaluateItem(context);
                    NumericValue scaleVal = (NumericValue)scaleVal0;
                    scaleRnd = (int)scaleVal.longValue();
                }
                return val.round(scaleRnd);
            }
            case 3: {
                int scale = 0;
                if (this.argument.length == 2) {
                    AtomicValue scaleVal0 = (AtomicValue)this.argument[1].evaluateItem(context);
                    NumericValue scaleVal = (NumericValue)scaleVal0;
                    scale = (int)scaleVal.longValue();
                }
                return val.roundHalfToEven(scale);
            }
            case 4: {
                return val.abs();
            }
        }
        throw new UnsupportedOperationException("Unknown rounding function");
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }
}

