/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "নাউরু";
        final String metaValue_TK = "টোকেলাউ";
        final String metaValue_TV = "টুভালু";
        final String metaValue_ar = "আরবি";
        final String metaValue_bn = "বাংলা";
        final String metaValue_ccp = "চাকমা";
        final String metaValue_chr = "চেরোকি";
        final String metaValue_el = "গ্রিক";
        final String metaValue_gu = "গুজরাটি";
        final String metaValue_he = "হিব্রু";
        final String metaValue_jv = "জাভানিজ";
        final String metaValue_km = "খমের";
        final String metaValue_ko = "কোরিয়ান";
        final String metaValue_lo = "লাও";
        final String metaValue_mn = "মোঙ্গোলীয়";
        final String metaValue_nqo = "এন’কো";
        final String metaValue_or = "ওড়িয়া";
        final String metaValue_si = "সিংহলি";
        final String metaValue_ta = "তামিল";
        final String metaValue_th = "থাই";
        final String metaValue_bo = "তিব্বতি";
        final String metaValue_uga = "উগারিটিক";
        final String metaValue_vai = "ভাই";
        final String metaValue_peo = "প্রাচীন ফার্সি";
        final Object[][] data = new Object[][] {
            { "001", "পৃথিবী" },
            { "002", "আফ্রিকা" },
            { "003", "উত্তর আমেরিকা" },
            { "005", "দক্ষিণ আমেরিকা" },
            { "009", "ওশিয়ানিয়া" },
            { "011", "পশ্চিম আফ্রিকা" },
            { "013", "মধ্য আমেরিকা" },
            { "014", "পূর্ব আফ্রিকা" },
            { "015", "উত্তর আফ্রিকা" },
            { "017", "মধ্য আফ্রিকা" },
            { "018", "দক্ষিন আফ্রিকা" },
            { "019", "আমেরিকা" },
            { "021", "উত্তরাঞ্চলীয় আমেরিকা" },
            { "029", "ক্যারিবিয়ান" },
            { "030", "পূর্ব এশিয়া" },
            { "034", "দক্ষিণ এশিয়া" },
            { "035", "দক্ষিণ পূর্ব এশিয়া" },
            { "039", "দক্ষিণ ইউরোপ" },
            { "053", "অস্ট্রেলেশিয়া" },
            { "054", "মেলানেশিয়া" },
            { "057", "মাইক্রোনেশিয়া অঞ্চল" },
            { "061", "পলিনেশিয়া" },
            { "142", "এশিয়া" },
            { "143", "মধ্য এশিয়া" },
            { "145", "পশ্চিম এশিয়া" },
            { "150", "ইউরোপ" },
            { "151", "পূর্ব ইউরোপ" },
            { "154", "উত্তর ইউরোপ" },
            { "155", "পশ্চিম ইউরোপ" },
            { "202", "উপ সাহারান আফ্রিকা" },
            { "419", "লাতিন আমেরিকা" },
            { "AC", "অ্যাসেনশন দ্বীপপুঞ্জ" },
            { "AD", "আন্ডোরা" },
            { "AE", "সংযুক্ত আরব আমিরাত" },
            { "AF", "আফগানিস্তান" },
            { "AG", "অ্যান্টিগুয়া ও বারবুডা" },
            { "AI", "অ্যাঙ্গুইলা" },
            { "AL", "আলবেনিয়া" },
            { "AM", "আর্মেনিয়া" },
            { "AO", "অ্যাঙ্গোলা" },
            { "AQ", "অ্যান্টার্কটিকা" },
            { "AR", "আর্জেন্টিনা" },
            { "AS", "আমেরিকান সামোয়া" },
            { "AT", "অস্ট্রিয়া" },
            { "AU", "অস্ট্রেলিয়া" },
            { "AW", "আরুবা" },
            { "AX", "অলান্ড দ্বীপপুঞ্জ" },
            { "AZ", "আজারবাইজান" },
            { "BA", "বসনিয়া ও হার্জেগোভিনা" },
            { "BB", "বার্বাডোজ" },
            { "BD", "বাংলাদেশ" },
            { "BE", "বেলজিয়াম" },
            { "BF", "বুরকিনা ফাসো" },
            { "BG", "বুলগেরিয়া" },
            { "BH", "বাহারিন" },
            { "BI", "বুরুন্ডি" },
            { "BJ", "বেনিন" },
            { "BL", "সেন্ট বার্থেলেমি" },
            { "BM", "বারমুডা" },
            { "BN", "ব্রুনেই" },
            { "BO", "বলিভিয়া" },
            { "BQ", "ক্যারিবিয়ান নেদারল্যান্ডস" },
            { "BR", "ব্রাজিল" },
            { "BS", "বাহামা দ্বীপপুঞ্জ" },
            { "BT", "ভুটান" },
            { "BV", "বোভেট দ্বীপ" },
            { "BW", "বতসোয়ানা" },
            { "BY", "বেলারুশ" },
            { "BZ", "বেলিজ" },
            { "CA", "কানাডা" },
            { "CC", "কোকোস (কিলিং) দ্বীপপুঞ্জ" },
            { "CD", "কঙ্গো-কিনশাসা" },
            { "CF", "মধ্য আফ্রিকান প্রজাতন্ত্র" },
            { "CG", "কঙ্গো - ব্রাজাভিল" },
            { "CH", "সুইজারল্যান্ড" },
            { "CI", "কোট ডি‘আইভোর" },
            { "CK", "কুক দ্বীপপুঞ্জ" },
            { "CL", "চিলি" },
            { "CM", "ক্যামেরুন" },
            { "CN", "চীন" },
            { "CO", "কলম্বিয়া" },
            { "CP", "ক্লিপারটন দ্বীপপুঞ্জ" },
            { "CQ", "সার্ক দ্বীপ" },
            { "CR", "কোস্টারিকা" },
            { "CU", "কিউবা" },
            { "CV", "কেপ ভার্দে" },
            { "CW", "কুরাসাও" },
            { "CX", "ক্রিসমাস দ্বীপ" },
            { "CY", "সাইপ্রাস" },
            { "CZ", "চেকিয়া" },
            { "DE", "জার্মানি" },
            { "DG", "দিয়েগো গার্সিয়া" },
            { "DJ", "জিবুতি" },
            { "DK", "ডেনমার্ক" },
            { "DM", "ডোমিনিকা" },
            { "DO", "ডোমেনিকান প্রজাতন্ত্র" },
            { "DZ", "আলজেরিয়া" },
            { "EA", "কুউটা এবং মেলিলা" },
            { "EC", "ইকুয়েডর" },
            { "EE", "এস্তোনিয়া" },
            { "EG", "মিশর" },
            { "EH", "পশ্চিম সাহারা" },
            { "ER", "ইরিত্রিয়া" },
            { "ES", "স্পেন" },
            { "ET", "ইথিওপিয়া" },
            { "EU", "ইউরোপীয় ইউনিয়ন" },
            { "EZ", "ইউরোজোন" },
            { "FI", "ফিনল্যান্ড" },
            { "FJ", "ফিজি" },
            { "FK", "ফকল্যান্ড দ্বীপপুঞ্জ" },
            { "FM", "মাইক্রোনেশিয়া" },
            { "FO", "ফ্যারো দ্বীপপুঞ্জ" },
            { "FR", "ফ্রান্স" },
            { "GA", "গ্যাবন" },
            { "GB", "যুক্তরাজ্য" },
            { "GD", "গ্রেনাডা" },
            { "GE", "জর্জিয়া" },
            { "GF", "ফরাসী গায়ানা" },
            { "GG", "গার্নসি" },
            { "GH", "ঘানা" },
            { "GI", "জিব্রাল্টার" },
            { "GL", "গ্রীনল্যান্ড" },
            { "GM", "গাম্বিয়া" },
            { "GN", "গিনি" },
            { "GP", "গুয়াদেলৌপ" },
            { "GQ", "নিরক্ষীয় গিনি" },
            { "GR", "গ্রীস" },
            { "GS", "দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ্জ" },
            { "GT", "গুয়াতেমালা" },
            { "GU", "গুয়াম" },
            { "GW", "গিনি-বিসাউ" },
            { "GY", "গিয়ানা" },
            { "HK", "হংকং এসএআর চীনা" },
            { "HM", "হার্ড এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ" },
            { "HN", "হন্ডুরাস" },
            { "HR", "ক্রোয়েশিয়া" },
            { "HT", "হাইতি" },
            { "HU", "হাঙ্গেরি" },
            { "IC", "ক্যানারি দ্বীপপুঞ্জ" },
            { "ID", "ইন্দোনেশিয়া" },
            { "IE", "আয়ারল্যান্ড" },
            { "IL", "ইজরায়েল" },
            { "IM", "আইল অফ ম্যান" },
            { "IN", "ভারত" },
            { "IO", "ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল" },
            { "IQ", "ইরাক" },
            { "IR", "ইরান" },
            { "IS", "আইসল্যান্ড" },
            { "IT", "ইতালি" },
            { "JE", "জার্সি" },
            { "JM", "জামাইকা" },
            { "JO", "জর্ডন" },
            { "JP", "জাপান" },
            { "KE", "কেনিয়া" },
            { "KG", "কিরগিজিস্তান" },
            { "KH", "কম্বোডিয়া" },
            { "KI", "কিরিবাতি" },
            { "KM", "কমোরোস" },
            { "KN", "সেন্ট কিটস ও নেভিস" },
            { "KP", "উত্তর কোরিয়া" },
            { "KR", "দক্ষিণ কোরিয়া" },
            { "KW", "কুয়েত" },
            { "KY", "কেম্যান দ্বীপপুঞ্জ" },
            { "KZ", "কাজাখস্তান" },
            { "LA", "লাওস" },
            { "LB", "লেবানন" },
            { "LC", "সেন্ট লুসিয়া" },
            { "LI", "লিচেনস্টেইন" },
            { "LK", "শ্রীলঙ্কা" },
            { "LR", "লাইবেরিয়া" },
            { "LS", "লেসোথো" },
            { "LT", "লিথুয়ানিয়া" },
            { "LU", "লাক্সেমবার্গ" },
            { "LV", "লাটভিয়া" },
            { "LY", "লিবিয়া" },
            { "MA", "মরক্কো" },
            { "MC", "মোনাকো" },
            { "MD", "মলডোভা" },
            { "ME", "মন্টিনিগ্রো" },
            { "MF", "সেন্ট মার্টিন" },
            { "MG", "মাদাগাস্কার" },
            { "MH", "মার্শাল দ্বীপপুঞ্জ" },
            { "MK", "উত্তর ম্যাসেডোনিয়া" },
            { "ML", "মালি" },
            { "MM", "মায়ানমার (বার্মা)" },
            { "MN", "মঙ্গোলিয়া" },
            { "MO", "ম্যাকাও এসএআর চীন" },
            { "MP", "উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ" },
            { "MQ", "মার্টিনিক" },
            { "MR", "মরিতানিয়া" },
            { "MS", "মন্টসেরাট" },
            { "MT", "মাল্টা" },
            { "MU", "মরিশাস" },
            { "MV", "মালদ্বীপ" },
            { "MW", "মালাউই" },
            { "MX", "মেক্সিকো" },
            { "MY", "মালয়েশিয়া" },
            { "MZ", "মোজাম্বিক" },
            { "NA", "নামিবিয়া" },
            { "NC", "নিউ ক্যালেডোনিয়া" },
            { "NE", "নাইজার" },
            { "NF", "নরফোক দ্বীপ" },
            { "NG", "নাইজেরিয়া" },
            { "NI", "নিকারাগুয়া" },
            { "NL", "নেদারল্যান্ডস" },
            { "NO", "নরওয়ে" },
            { "NP", "নেপাল" },
            { "NR", metaValue_NR },
            { "NU", "নিউয়ে" },
            { "NZ", "নিউজিল্যান্ড" },
            { "OM", "ওমান" },
            { "PA", "পানামা" },
            { "PE", "পেরু" },
            { "PF", "ফরাসী পলিনেশিয়া" },
            { "PG", "পাপুয়া নিউ গিনি" },
            { "PH", "ফিলিপাইন" },
            { "PK", "পাকিস্তান" },
            { "PL", "পোল্যান্ড" },
            { "PM", "সেন্ট পিয়ের ও মিকুয়েলন" },
            { "PN", "পিটকেয়ার্ন দ্বীপপুঞ্জ" },
            { "PR", "পুয়ের্তো রিকো" },
            { "PS", "প্যালেস্টাইন ভূখণ্ড" },
            { "PT", "পর্তুগাল" },
            { "PW", "পালাউ" },
            { "PY", "প্যারাগুয়ে" },
            { "QA", "কাতার" },
            { "QO", "আউটলাইনিং ওসানিয়া" },
            { "RE", "রিইউনিয়ন" },
            { "RO", "রোমানিয়া" },
            { "RS", "সার্বিয়া" },
            { "RU", "রাশিয়া" },
            { "RW", "রুয়ান্ডা" },
            { "SA", "সৌদি আরব" },
            { "SB", "সলোমন দ্বীপপুঞ্জ" },
            { "SC", "সিসিলি" },
            { "SD", "সুদান" },
            { "SE", "সুইডেন" },
            { "SG", "সিঙ্গাপুর" },
            { "SH", "সেন্ট হেলেনা" },
            { "SI", "স্লোভানিয়া" },
            { "SJ", "স্বালবার্ড ও জান মেয়েন" },
            { "SK", "স্লোভাকিয়া" },
            { "SL", "সিয়েরা লিওন" },
            { "SM", "সান মারিনো" },
            { "SN", "সেনেগাল" },
            { "SO", "সোমালিয়া" },
            { "SR", "সুরিনাম" },
            { "SS", "দক্ষিণ সুদান" },
            { "ST", "সাওটোমা ও প্রিন্সিপি" },
            { "SV", "এল সালভেদর" },
            { "SX", "সিন্ট মার্টেন" },
            { "SY", "সিরিয়া" },
            { "SZ", "ইসওয়াতিনি" },
            { "TA", "ট্রিস্টান ডা কুনহা" },
            { "TC", "তুর্কস ও কাইকোস দ্বীপপুঞ্জ" },
            { "TD", "চাদ" },
            { "TF", "ফরাসী দক্ষিণাঞ্চল" },
            { "TG", "টোগো" },
            { "TH", "থাইল্যান্ড" },
            { "TJ", "তাজিকিস্তান" },
            { "TK", metaValue_TK },
            { "TL", "তিমুর-লেস্তে" },
            { "TM", "তুর্কমেনিস্তান" },
            { "TN", "তিউনিসিয়া" },
            { "TO", "টোঙ্গা" },
            { "TR", "তুরস্ক" },
            { "TT", "ত্রিনিদাদ ও টোবাগো" },
            { "TV", metaValue_TV },
            { "TW", "তাইওয়ান" },
            { "TZ", "তাঞ্জানিয়া" },
            { "UA", "ইউক্রেন" },
            { "UG", "উগান্ডা" },
            { "UM", "যুক্তরাষ্ট্রের পার্শ্ববর্তী দ্বীপপুঞ্জ" },
            { "UN", "জাতিসংঘ" },
            { "US", "মার্কিন যুক্তরাষ্ট্র" },
            { "UY", "উরুগুয়ে" },
            { "UZ", "উজবেকিস্তান" },
            { "VA", "ভ্যাটিকান সিটি" },
            { "VC", "সেন্ট ভিনসেন্ট ও গ্রেনাডিনস" },
            { "VE", "ভেনেজুয়েলা" },
            { "VG", "ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ" },
            { "VI", "মার্কিন যুক্তরাষ্ট্রীয় ভার্জিন দ্বীপপুঞ্জ" },
            { "VN", "ভিয়েতনাম" },
            { "VU", "ভানুয়াটু" },
            { "WF", "ওয়ালিস ও ফুটুনা" },
            { "WS", "সামোয়া" },
            { "XA", "সিউডো-অ্যাকসেন্ট" },
            { "XB", "সিউডো-বিডি" },
            { "XK", "কসোভো" },
            { "YE", "ইয়েমেন" },
            { "YT", "মায়োত্তে" },
            { "ZA", "দক্ষিণ আফ্রিকা" },
            { "ZM", "জাম্বিয়া" },
            { "ZW", "জিম্বাবোয়ে" },
            { "ZZ", "অজানা অঞ্চল" },
            { "aa", "আফার" },
            { "ab", "আবখাজিয়ান" },
            { "ae", "আবেস্তীয়" },
            { "af", "আফ্রিকান" },
            { "ak", "আকান" },
            { "am", "আমহারিক" },
            { "an", "আর্গোনিজ" },
            { "ar", metaValue_ar },
            { "as", "অসমীয়া" },
            { "av", "আভেরিক" },
            { "ay", "আয়মারা" },
            { "az", "আজারবাইজানী" },
            { "ba", "বাশকির" },
            { "be", "বেলারুশীয়" },
            { "bg", "বুলগেরিয়" },
            { "bi", "বিসলামা" },
            { "bm", "বামবারা" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ব্রেটন" },
            { "bs", "বসনীয়" },
            { "ca", "কাতালান" },
            { "ce", "চেচেন" },
            { "ch", "চামোরো" },
            { "co", "কর্সিকান" },
            { "cr", "ক্রি" },
            { "cs", "চেক" },
            { "cu", "চার্চ স্লাভিক" },
            { "cv", "চুবাস" },
            { "cy", "ওয়েলশ" },
            { "da", "ডেনিশ" },
            { "de", "জার্মান" },
            { "dv", "দিবেহি" },
            { "dz", "জোংখা" },
            { "ee", "ইউয়ি" },
            { "el", metaValue_el },
            { "en", "ইংরেজি" },
            { "eo", "এস্পেরান্তো" },
            { "es", "স্প্যানিশ" },
            { "et", "এস্তোনীয়" },
            { "eu", "বাস্ক" },
            { "fa", "ফার্সি" },
            { "ff", "ফুলা" },
            { "fi", "ফিনিশ" },
            { "fj", "ফিজিয়ান" },
            { "fo", "ফেরোইস" },
            { "fr", "ফরাসি" },
            { "fy", "পশ্চিম ফ্রিসিয়ান" },
            { "ga", "আইরিশ" },
            { "gd", "স্কটিশ-গ্যেলিক" },
            { "gl", "গ্যালিশীয়" },
            { "gn", "গুয়ারানি" },
            { "gu", metaValue_gu },
            { "gv", "ম্যাঙ্কস" },
            { "ha", "হাউসা" },
            { "he", metaValue_he },
            { "hi", "হিন্দি" },
            { "ho", "হিরি মোতু" },
            { "hr", "ক্রোয়েশীয়" },
            { "ht", "হাইতিয়ান ক্রেওল" },
            { "hu", "হাঙ্গেরীয়" },
            { "hy", "আর্মেনিয়" },
            { "hz", "হেরেরো" },
            { "ia", "ইন্টারলিঙ্গুয়া" },
            { "id", "ইন্দোনেশীয়" },
            { "ie", "ইন্টারলিঙ্গ" },
            { "ig", "ইগবো" },
            { "ii", "সিচুয়ান য়ি" },
            { "ik", "ইনুপিয়াক" },
            { "io", "ইডো" },
            { "is", "আইসল্যান্ডীয়" },
            { "it", "ইতালীয়" },
            { "iu", "ইনুক্টিটুট" },
            { "ja", "জাপানি" },
            { "jv", metaValue_jv },
            { "ka", "জর্জিয়ান" },
            { "kg", "কঙ্গো" },
            { "ki", "কিকুয়ু" },
            { "kj", "কোয়ানিয়ামা" },
            { "kk", "কাজাখ" },
            { "kl", "কালাল্লিসুট" },
            { "km", metaValue_km },
            { "kn", "কন্নড়" },
            { "ko", metaValue_ko },
            { "kr", "কানুরি" },
            { "ks", "কাশ্মীরি" },
            { "ku", "কুরমাঞ্জি" },
            { "kv", "কোমি" },
            { "kw", "কর্ণিশ" },
            { "ky", "কিরগিজ" },
            { "la", "লাতিন" },
            { "lb", "লুক্সেমবার্গীয়" },
            { "lg", "গান্ডা" },
            { "li", "লিম্বুর্গিশ" },
            { "ln", "লিঙ্গালা" },
            { "lo", metaValue_lo },
            { "lt", "লিথুয়ানীয়" },
            { "lu", "লুবা-কাটাঙ্গা" },
            { "lv", "লাটভিয়" },
            { "mg", "মালাগাসি" },
            { "mh", "মার্শালিজ" },
            { "mi", "মাওরি" },
            { "mk", "ম্যাসেডোনিয়া" },
            { "ml", "মালয়ালম" },
            { "mn", metaValue_mn },
            { "mr", "মারাঠি" },
            { "ms", "মালয়" },
            { "mt", "মল্টীয়" },
            { "my", "বর্মি" },
            { "na", metaValue_NR },
            { "nb", "নরওয়েজিয়ান বোকমাল" },
            { "nd", "উত্তর এন্দেবেলে" },
            { "ne", "নেপালি" },
            { "ng", "এন্দোঙ্গা" },
            { "nl", "ওলন্দাজ" },
            { "nn", "নরওয়েজিয়ান নিনর্স্ক" },
            { "no", "নরওয়েজীয়" },
            { "nr", "দক্ষিণ এনডেবেলে" },
            { "nv", "নাভাজো" },
            { "ny", "নায়াঞ্জা" },
            { "oc", "অক্সিটান" },
            { "oj", "ওজিবওয়া" },
            { "om", "ওরোমো" },
            { "or", metaValue_or },
            { "os", "ওসেটিক" },
            { "pa", "পাঞ্জাবি" },
            { "pi", "পালি" },
            { "pl", "পোলিশ" },
            { "ps", "পাশতু" },
            { "pt", "পর্তুগিজ" },
            { "qu", "কেচুয়া" },
            { "rm", "রোমান্স" },
            { "rn", "রুন্দি" },
            { "ro", "রোমানীয়" },
            { "ru", "রুশ" },
            { "rw", "কিনয়ারোয়ান্ডা" },
            { "sa", "সংস্কৃত" },
            { "sc", "সার্ডিনিয়ান" },
            { "sd", "সিন্ধি" },
            { "se", "উত্তরাঞ্চলীয় সামি" },
            { "sg", "সাঙ্গো" },
            { "sh", "সার্বো-ক্রোয়েশিয়" },
            { "si", metaValue_si },
            { "sk", "স্লোভাক" },
            { "sl", "স্লোভেনীয়" },
            { "sm", "সামোয়ান" },
            { "sn", "শোনা" },
            { "so", "সোমালি" },
            { "sq", "আলবেনীয়" },
            { "sr", "সার্বীয়" },
            { "ss", "সোয়াতি" },
            { "st", "দক্ষিন সোথো" },
            { "su", "সুদানী" },
            { "sv", "সুইডিশ" },
            { "sw", "সোয়াহিলি" },
            { "ta", metaValue_ta },
            { "te", "তেলুগু" },
            { "tg", "তাজিক" },
            { "th", metaValue_th },
            { "ti", "তিগরিনিয়া" },
            { "tk", "তুর্কমেনী" },
            { "tl", "তাগালগ" },
            { "tn", "সোয়ানা" },
            { "to", "টোঙ্গান" },
            { "tr", "তুর্কি" },
            { "ts", "সঙ্গা" },
            { "tt", "তাতার" },
            { "tw", "টোয়াই" },
            { "ty", "তাহিতিয়ান" },
            { "ug", "উইঘুর" },
            { "uk", "ইউক্রেনীয়" },
            { "ur", "উর্দু" },
            { "uz", "উজবেক" },
            { "ve", "ভেন্ডা" },
            { "vi", "ভিয়েতনামী" },
            { "vo", "ভোলাপুক" },
            { "wa", "ওয়ালুন" },
            { "wo", "ওলোফ" },
            { "xh", "খোসা" },
            { "yi", "ইদ্দিশ" },
            { "yo", "ইওরুবা" },
            { "za", "ঝুয়াং" },
            { "zh", "চীনা" },
            { "zu", "জুলু" },
            { "ace", "অ্যাচাইনিজ" },
            { "ach", "আকোলি" },
            { "ada", "অদাগ্মে" },
            { "ady", "আদেগে" },
            { "afh", "আফ্রিহিলি" },
            { "agq", "এঘেম" },
            { "ain", "আইনু" },
            { "akk", "আক্কাদিয়ান" },
            { "ale", "আলেউত" },
            { "alt", "দক্ষিন আলতাই" },
            { "ang", "প্রাচীন ইংরেজী" },
            { "ann", "ওবোলো" },
            { "anp", "আঙ্গিকা" },
            { "arc", "আরামাইক" },
            { "arn", "মাপুচে" },
            { "arp", "আরাপাহো" },
            { "ars", "নজদি আরবি" },
            { "arw", "আরাওয়াক" },
            { "asa", "আসু" },
            { "ast", "আস্তুরিয়" },
            { "atj", "আটিকামেকিউ" },
            { "awa", "আওয়াধি" },
            { "bal", "বেলুচী" },
            { "ban", "বালিনীয়" },
            { "bas", "বাসা" },
            { "bej", "বেজা" },
            { "bem", "বেম্বা" },
            { "bez", "বেনা" },
            { "bgc", "হরিয়ানভি" },
            { "bgn", "পশ্চিম বালোচি" },
            { "bho", "ভোজপুরি" },
            { "bik", "বিকোল" },
            { "bin", "বিনি" },
            { "bla", "সিকসিকা" },
            { "blo", "অ্যানি" },
            { "bra", "ব্রাজ" },
            { "brx", "বোড়ো" },
            { "bua", "বুরিয়াত" },
            { "bug", "বুগিনিজ" },
            { "byn", "ব্লিন" },
            { "cad", "ক্যাডো" },
            { "car", "ক্যারিব" },
            { "cay", "কায়ুগা" },
            { "cch", "আত্সাম" },
            { "ccp", metaValue_ccp },
            { "ceb", "চেবুয়ানো" },
            { "cgg", "চিগা" },
            { "chb", "চিবচা" },
            { "chg", "চাগাতাই" },
            { "chk", "চুকিজ" },
            { "chm", "মারি" },
            { "chn", "চিনুক জার্গন" },
            { "cho", "চকটাও" },
            { "chp", "চিপেওয়ান" },
            { "chr", metaValue_chr },
            { "chy", "চেইয়েন" },
            { "ckb", "মধ্য কুর্দিশ" },
            { "clc", "চিলকোটিন" },
            { "cop", "কপটিক" },
            { "crg", "মিচিফ" },
            { "crh", "ক্রিমিয়ান তুর্কি" },
            { "crj", "দক্ষিণ পূর্ব ক্রী" },
            { "crk", "প্লেনস ক্রী" },
            { "crl", "উত্তর পূর্ব ক্রী" },
            { "crm", "মুস ক্রী" },
            { "crr", "ক্যারোলিনা অ্যাল্গঙ্কুইয়ান" },
            { "crs", "সেসেলওয়া ক্রেওল ফ্রেঞ্চ" },
            { "csb", "কাশুবিয়ান" },
            { "csw", "সোয়াম্পি ক্রী" },
            { "dak", "ডাকোটা" },
            { "dar", "দার্গওয়া" },
            { "dav", "তাইতা" },
            { "del", "ডেলাওয়ের" },
            { "den", "স্ল্যাভ" },
            { "dgr", "দোগ্রীব" },
            { "din", "ডিংকা" },
            { "dje", "জার্মা" },
            { "doi", "ডোগরি" },
            { "dsb", "সোর্বিয়ান (নিম্নতর)" },
            { "dua", "দুয়ালা" },
            { "dum", "মধ্য ডাচ" },
            { "dyo", "জোলা-ফনী" },
            { "dyu", "ডিউলা" },
            { "dzg", "দাজাগা" },
            { "ebu", "এম্বু" },
            { "efi", "এফিক" },
            { "egy", "প্রাচীন মিশরীয়" },
            { "eka", "ইকাজুক" },
            { "elx", "এলামাইট" },
            { "enm", "মধ্য ইংরেজি" },
            { "ewo", "ইওন্ডো" },
            { "fan", "ফ্যাঙ্গ" },
            { "fat", "ফান্তি" },
            { "fil", "ফিলিপিনো" },
            { "fon", "ফন" },
            { "frc", "কাজুন ফরাসি" },
            { "frm", "মধ্য ফরাসি" },
            { "fro", "প্রাচীন ফরাসি" },
            { "frr", "উত্তরাঞ্চলীয় ফ্রিসিয়ান" },
            { "frs", "পূর্ব ফ্রিসিয়" },
            { "fur", "ফ্রিউলিও" },
            { "gaa", "গা" },
            { "gag", "গাগাউজ" },
            { "gan", "gan" },
            { "gay", "গায়ো" },
            { "gba", "বায়া" },
            { "gez", "গীজ" },
            { "gil", "গিলবার্টিজ" },
            { "gmh", "মধ্য-উচ্চ জার্মানি" },
            { "goh", "প্রাচীন উচ্চ জার্মানি" },
            { "gon", "গোন্ডি" },
            { "gor", "গোরোন্তালো" },
            { "got", "গথিক" },
            { "grb", "গ্রেবো" },
            { "grc", "প্রাচীন গ্রীক" },
            { "gsw", "সুইস জার্মান" },
            { "guz", "গুসী" },
            { "gwi", "গওইচ্’ইন" },
            { "hai", "হাইডা" },
            { "haw", "হাওয়াইয়ান" },
            { "hax", "দক্ষিণী হায়দা" },
            { "hil", "হিলিগ্যায়নোন" },
            { "hit", "হিট্টিট" },
            { "hmn", "হ্‌মোঙ" },
            { "hsb", "সোর্বিয়ান (উচ্চ)" },
            { "hsn", "Xiang চীনা" },
            { "hup", "হুপা" },
            { "hur", "হাল্কোমেলেম" },
            { "iba", "ইবান" },
            { "ibb", "ইবিবিও" },
            { "ikt", "পশ্চিম কানাডিয় ইনুক্টিটুট" },
            { "ilo", "ইলোকো" },
            { "inh", "ইঙ্গুশ" },
            { "jbo", "লোজবান" },
            { "jgo", "গোম্বা" },
            { "jmc", "মাকামে" },
            { "jpr", "জুদেও ফার্সি" },
            { "jrb", "জুদেও আরবি" },
            { "kaa", "কারা-কাল্পাক" },
            { "kab", "কাবাইলে" },
            { "kac", "কাচিন" },
            { "kaj", "জজু" },
            { "kam", "কাম্বা" },
            { "kaw", "কাউই" },
            { "kbd", "কাবার্ডিয়ান" },
            { "kcg", "টিয়াপ" },
            { "kde", "মাকোন্দে" },
            { "kea", "কাবুভারদিয়ানু" },
            { "kfo", "কোরো" },
            { "kgp", "কেইনগ্যাং" },
            { "kha", "খাশি" },
            { "kho", "খোটানিজ" },
            { "khq", "কোয়রা চীনি" },
            { "kkj", "কাকো" },
            { "kln", "কালেনজিন" },
            { "kmb", "কিম্বুন্দু" },
            { "koi", "কমি-পারমিআক" },
            { "kok", "কোঙ্কণী" },
            { "kos", "কোস্রাইন" },
            { "kpe", "ক্‌পেল্লে" },
            { "krc", "কারচে-বাল্কার" },
            { "krl", "কারেলিয়ান" },
            { "kru", "কুরুখ" },
            { "ksb", "শাম্বালা" },
            { "ksf", "বাফিয়া" },
            { "ksh", "কলোগনিয়ান" },
            { "kum", "কুমিয়াক" },
            { "kut", "কুটেনাই" },
            { "kwk", "কোয়াক’ওয়ালা" },
            { "kxv", "কুভি" },
            { "lad", "লাদিনো" },
            { "lag", "লাঙ্গি" },
            { "lah", "লান্ডা" },
            { "lam", "লাম্বা" },
            { "lez", "লেজঘিয়ান" },
            { "lij", "লিগুরিয়ান" },
            { "lil", "লিল্লুয়েট" },
            { "lkt", "লাকোটা" },
            { "lmo", "লম্বার্ড" },
            { "lol", "মোঙ্গো" },
            { "lou", "লুইসিয়ানা ক্রেওল" },
            { "loz", "লোজি" },
            { "lrc", "উত্তরাঞ্চলীয় লুরি" },
            { "lsm", "সামিয়া" },
            { "lua", "লুবা-লুলুয়া" },
            { "lui", "লুইসেনো" },
            { "lun", "লুন্ডা" },
            { "luo", "লুয়ো" },
            { "lus", "মিজো" },
            { "luy", "লুইয়া" },
            { "mad", "মাদুরেজ" },
            { "mag", "মাগাহি" },
            { "mai", "মৈথিলি" },
            { "mak", "ম্যাকাসার" },
            { "man", "ম্যান্ডিঙ্গো" },
            { "mas", "মাসাই" },
            { "mdf", "মোকশা" },
            { "mdr", "ম্যাণ্ডার" },
            { "men", "মেন্ডে" },
            { "mer", "মেরু" },
            { "mfe", "মরিসিয়েন" },
            { "mga", "মধ্য আইরিশ" },
            { "mgh", "মাখুয়া-মেত্তো" },
            { "mgo", "মেটা" },
            { "mic", "মিকম্যাক" },
            { "min", "মিনাংকাবাউ" },
            { "mnc", "মাঞ্চু" },
            { "mni", "মণিপুরী" },
            { "moe", "ইন্নু-এমুন" },
            { "moh", "মোহাওক" },
            { "mos", "মসি" },
            { "mua", "মুদাঙ্গ" },
            { "mul", "একাধিক ভাষা" },
            { "mus", "মুস্কোগী" },
            { "mwl", "মিরান্ডিজ" },
            { "mwr", "মারোয়ারি" },
            { "myv", "এরজিয়া" },
            { "mzn", "মাজানদেরানি" },
            { "nap", "নেয়াপোলিটান" },
            { "naq", "নামা" },
            { "nds", "জার্মান (নিম্ন)" },
            { "new", "নেওয়ারি" },
            { "nia", "নিয়াস" },
            { "niu", "নিউয়ান" },
            { "nmg", "কোয়াসিও" },
            { "nnh", "নগিয়েম্বুন" },
            { "nog", "নোগাই" },
            { "non", "প্রাচীন নর্স" },
            { "nqo", metaValue_nqo },
            { "nso", "উত্তরাঞ্চলীয় সোথো" },
            { "nus", "নুয়ার" },
            { "nwc", "প্রাচীন নেওয়ারী" },
            { "nym", "ন্যায়ামওয়েজি" },
            { "nyn", "ন্যায়াঙ্কোলে" },
            { "nyo", "ন্যোরো" },
            { "nzi", "এনজিমা" },
            { "ojb", "উত্তর পশ্চিম ওজিবোয়া" },
            { "ojc", "মধ্য ওজিবুয়া" },
            { "ojs", "ওজি-ক্রী" },
            { "ojw", "পশ্চিম ওজিবোয়া" },
            { "oka", "ওকানাগান" },
            { "osa", "ওসেজ" },
            { "ota", "অটোমান তুর্কি" },
            { "pag", "পাঙ্গাসিনান" },
            { "pal", "পাহ্লাভি" },
            { "pam", "পাম্পাঙ্গা" },
            { "pap", "পাপিয়ামেন্টো" },
            { "pau", "পালায়ুয়ান" },
            { "pcm", "নাইজেরীয় পিজিন" },
            { "peo", metaValue_peo },
            { "phn", "ফোনিশীয়ান" },
            { "pis", "পিজিন" },
            { "pon", "পোহ্নপেইয়ান" },
            { "pqm", "মালিসেট-পাসামাকুয়োড্ডি" },
            { "prg", "প্রুশিয়ান" },
            { "pro", "প্রাচীন প্রোভেনসাল" },
            { "quc", "কি‘চে" },
            { "raj", "রাজস্থানী" },
            { "rap", "রাপানুই" },
            { "rar", "রারোটোংগান" },
            { "rhg", "রোহিঙ্গা" },
            { "rof", "রম্বো" },
            { "rom", "রোমানি" },
            { "rup", "আরোমেনিয়" },
            { "rwk", "রাওয়া" },
            { "sad", "সান্দাওয়ে" },
            { "sah", "ইয়াকুট" },
            { "sam", "সামারিটান আরামিক" },
            { "saq", "সামবুরু" },
            { "sas", "সাসাক" },
            { "sat", "সাঁওতালি" },
            { "sba", "গাম্বে" },
            { "sbp", "সাঙ্গু" },
            { "scn", "সিসিলিয়ান" },
            { "sco", "স্কটস" },
            { "sdh", "দক্ষিণ কুর্দিশ" },
            { "seh", "সেনা" },
            { "sel", "সেল্কুপ" },
            { "ses", "কোয়রাবোরো সেন্নি" },
            { "sga", "প্রাচীন আইরিশ" },
            { "shi", "তাচেলহিত" },
            { "shn", "শান" },
            { "sid", "সিডামো" },
            { "slh", "দক্ষিণী লুশুটসীড" },
            { "sma", "দক্ষিণাঞ্চলীয় সামি" },
            { "smj", "লুলে সামি" },
            { "smn", "ইনারি সামি" },
            { "sms", "স্কোল্ট সামি" },
            { "snk", "সোনিঙ্কে" },
            { "sog", "সোগডিয়ান" },
            { "srn", "স্রানান টোঙ্গো" },
            { "srr", "সেরের" },
            { "ssy", "সাহো" },
            { "str", "স্ট্রেটস সালিস" },
            { "suk", "সুকুমা" },
            { "sus", "সুসু" },
            { "sux", "সুমেরীয়" },
            { "swb", "কমোরিয়ান" },
            { "syc", "প্রাচীন সিরিও" },
            { "syr", "সিরিয়াক" },
            { "szl", "সিলেশিয়ান" },
            { "tce", "দক্ষিণী টুচোন" },
            { "tem", "টাইম্নে" },
            { "teo", "তেসো" },
            { "ter", "তেরেনো" },
            { "tet", "তেতুম" },
            { "tgx", "তাগিশ" },
            { "tht", "তাহ্লতান" },
            { "tig", "টাইগ্রে" },
            { "tiv", "টিভ" },
            { "tkl", metaValue_TK },
            { "tlh", "ক্লিঙ্গন" },
            { "tli", "ত্লিঙ্গিট" },
            { "tmh", "তামাশেক" },
            { "tog", "নায়াসা টোঙ্গা" },
            { "tok", "টোকি পোনা" },
            { "tpi", "টোক পিসিন" },
            { "trv", "তারোকো" },
            { "tsi", "সিমশিয়ান" },
            { "ttm", "উত্তরাঞ্চলীয় টুচোন" },
            { "tum", "তুম্বুকা" },
            { "tvl", metaValue_TV },
            { "twq", "তাসাওয়াক" },
            { "tyv", "টুভিনিয়ান" },
            { "tzm", "সেন্ট্রাল আটলাস তামাজিগাত" },
            { "udm", "উডমুর্ট" },
            { "uga", metaValue_uga },
            { "umb", "উম্বুন্দু" },
            { "und", "অজানা ভাষা" },
            { "vai", metaValue_vai },
            { "vec", "ভেনেশিয়ান" },
            { "vmw", "মাখুওয়া" },
            { "vot", "ভোটিক" },
            { "vun", "ভুঞ্জো" },
            { "wae", "ওয়ালসার" },
            { "wal", "ওলায়ট্টা" },
            { "war", "ওয়ারে" },
            { "was", "ওয়াশো" },
            { "wbp", "ওয়ার্লপিরি" },
            { "wuu", "উ চীনা" },
            { "xal", "কাল্মাইক" },
            { "xnr", "কাংরি" },
            { "xog", "সোগা" },
            { "yao", "ইয়াও" },
            { "yap", "ইয়াপেসে" },
            { "yav", "ইয়াঙ্গবেন" },
            { "ybb", "ইয়েম্বা" },
            { "yrl", "নহিংগাটু" },
            { "yue", "ক্যান্টোনিজ" },
            { "zap", "জাপোটেক" },
            { "zbl", "চিত্র ভাষা" },
            { "zen", "জেনাগা" },
            { "zgh", "আদর্শ মরক্কোন তামাজিগাত" },
            { "zun", "জুনি" },
            { "zxx", "ভাষাভিত্তিক বিষয়বস্তু নেই" },
            { "zza", "জাজা" },
            { "Adlm", "আদলাম" },
            { "Arab", metaValue_ar },
            { "Aran", "নাস্তালিক" },
            { "Armi", "আরমি" },
            { "Armn", "আর্মেনীয়" },
            { "Avst", "আভেসতান" },
            { "Bali", "বালীয়" },
            { "Batk", "বাটাক" },
            { "Beng", metaValue_bn },
            { "Blis", "ব্লিসপ্রতীক" },
            { "Bopo", "বোপোমোফো" },
            { "Brah", "ব্রাহ্মী" },
            { "Brai", "ব্রেইল" },
            { "Bugi", "বুগি" },
            { "Buhd", "বুহিড" },
            { "Cakm", metaValue_ccp },
            { "Cans", "সংযুক্ত কানাডিয়ান অ্যাবোরিজিনাল সিলেবিক্স" },
            { "Cari", "ক্যারিয়ান" },
            { "Cham", "চ্যাম" },
            { "Cher", metaValue_chr },
            { "Cirt", "কির্ট" },
            { "Copt", "কোপ্টিক" },
            { "Cprt", "সাইপ্রোয়েট" },
            { "Cyrl", "সিরিলিক" },
            { "Cyrs", "প্রাচীন চার্চ স্লাভোনিক সিরিলিক" },
            { "Deva", "দেবনাগরী" },
            { "Dsrt", "দেসেরাত" },
            { "Egyd", "মিশরীয় ডেমোটিক" },
            { "Egyh", "মিশরীয় হায়রেটিক" },
            { "Egyp", "মিশরীয় হায়ারোগ্লিপ" },
            { "Ethi", "ইথিওপিয়" },
            { "Geok", "জর্জিয় খুৎসুরি" },
            { "Geor", "জর্জীয়" },
            { "Glag", "গ্লাগোলিটিক" },
            { "Goth", "গোথিক" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "গুরুমুখি" },
            { "Hanb", "হ্যান-বোপোমোফো" },
            { "Hang", "হাঙ্গুল" },
            { "Hani", "হ্যান" },
            { "Hano", "হ্যানুনু" },
            { "Hans", "সরলীকৃত" },
            { "Hant", "ঐতিহ্যবাহী" },
            { "Hebr", metaValue_he },
            { "Hira", "হিরাগানা" },
            { "Hmng", "ফাহাও মঙ" },
            { "Hrkt", "জাপানি অক্ষরমালা" },
            { "Hung", "পুরোনো হাঙ্গেরীয়" },
            { "Inds", "সিন্ধু" },
            { "Ital", "প্রাচীন ইতালি" },
            { "Jamo", "জ্যামো" },
            { "Java", metaValue_jv },
            { "Jpan", "জাপানী" },
            { "Kali", "কায়াহ লি" },
            { "Kana", "কাটাকানা" },
            { "Khar", "খরোষ্ঠী" },
            { "Khmr", metaValue_km },
            { "Knda", "কানাড়া" },
            { "Kore", metaValue_ko },
            { "Kthi", "কাইথি" },
            { "Lana", "লান্না" },
            { "Laoo", metaValue_lo },
            { "Latf", "ফ্রাক্টুর ল্যাটিন" },
            { "Latg", "গ্যালিক ল্যাটিন" },
            { "Latn", "ল্যাটিন" },
            { "Lepc", "লেপ্চা" },
            { "Limb", "লিম্বু" },
            { "Lina", "লিনিয়ার এ" },
            { "Linb", "লিনিয়ার বি" },
            { "Lyci", "লাইসিয়ান" },
            { "Lydi", "লাইডিয়ান" },
            { "Mand", "ম্যান্ডায়ীন" },
            { "Mani", "ম্যানিচাইন" },
            { "Maya", "মায়ান হায়ারোগ্লিপ" },
            { "Mero", "মেরোইটিক" },
            { "Mlym", "মালায়ালাম" },
            { "Mong", metaValue_mn },
            { "Moon", "মুন" },
            { "Mtei", "মেইতেই মায়েক" },
            { "Mymr", "মায়ানমার" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ওঘাম" },
            { "Olck", "অলচিকি" },
            { "Orkh", "অর্খোন" },
            { "Orya", metaValue_or },
            { "Osma", "ওসমানিয়" },
            { "Perm", "প্রাচীন পার্মিক" },
            { "Phag", "ফাগ্স-পা" },
            { "Phli", "খদিত পাহলভি" },
            { "Phlp", "সল্টার পাহলভি" },
            { "Phlv", "পুস্তক পাহলভি" },
            { "Phnx", "ফিনিশিয়" },
            { "Plrd", "পোলার্ড ধ্বনিক" },
            { "Prti", "পার্থিয়ন" },
            { "Rjng", "রেজ্যাঙ্গ" },
            { "Rohg", "হানিফি" },
            { "Roro", "রোঙ্গোরোঙ্গো" },
            { "Runr", "রুনিক" },
            { "Samr", "সমেরিটন" },
            { "Sara", "সারাতি" },
            { "Saur", "সৌরাষ্ট্র" },
            { "Sgnw", "চিহ্ন লিখন" },
            { "Shaw", "সাভিয়ান" },
            { "Sinh", metaValue_si },
            { "Sund", "সুন্দানিজ" },
            { "Sylo", "সিলেটি নাগরি" },
            { "Syrc", "সিরীয়" },
            { "Syre", "এস্ট্রেঙ্গেলো সিরিয়াক" },
            { "Syrj", "পশ্চিমাঞ্চলীয় সিরিয়াক" },
            { "Syrn", "পূর্বাঞ্চলীয় সিরিয়াক" },
            { "Tagb", "টাগোওয়ানা" },
            { "Tale", "তাইলে" },
            { "Talu", "নতুন তাই লু" },
            { "Taml", metaValue_ta },
            { "Tavt", "তাই ভিয়েৎ" },
            { "Telu", "তেলেগু" },
            { "Teng", "তেঙ্গোয়ার" },
            { "Tfng", "তিফিনাগ" },
            { "Tglg", "টাগালগ" },
            { "Thaa", "থানা" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "দৃশ্যমান ভাষা" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "সুমের-আক্কাদীয় কীলকরূপ" },
            { "Yiii", "ই" },
            { "Zinh", "কাই" },
            { "Zmth", "গাণিতিক চিহ্ন" },
            { "Zsye", "ইমোজি" },
            { "Zsym", "প্রতীক" },
            { "Zxxx", "অলিখিত" },
            { "Zyyy", "সাধারন" },
            { "Zzzz", "অজানা লিপি" },
            { "es_ES", "স্প্যানিশ (ইউরোপ)" },
            { "fa_AF", "দারি" },
            { "nl_BE", "ফ্লেমিশ" },
            { "pt_BR", "পর্তুগিজ (ব্রাজিল)" },
            { "pt_PT", "পর্তুগিজ (ইউরোপ)" },
            { "ro_MD", "মলদাভিয়" },
            { "sw_CD", "কঙ্গো সোয়াহিলি" },
            { "ar_001", "আধুনিক আদর্শ আরবি" },
            { "key.ca", "ক্যালেন্ডার" },
            { "key.cf", "মুদ্রা বিন্যাস" },
            { "key.co", "বাছাই বিন্যাস" },
            { "key.cu", "মুদ্রা" },
            { "key.em", "ইমোজি উপস্থাপনা" },
            { "key.hc", "সময়ের হিসাব (১২ বা ২৪)" },
            { "key.lb", "লাইন বিভাজক শৈলী" },
            { "key.lw", "শব্দদ্বয়ের মধ্যে লাইন বিভাজক" },
            { "key.ms", "পরিমাপ পদ্ধতি" },
            { "key.nu", "সংখ্যা" },
            { "key.ss", "শব্দ সংক্ষেপণের পর বাক্য ভাঙা" },
            { "key.tz", "সময় অঞ্চল" },
            { "key.va", "স্থানীয় ভিন্নতা" },
            { "nds_NL", "লো স্যাক্সন" },
            { "type.ca.roc", "মিঙ্গুও ক্যালেন্ডার" },
            { "type.co.eor", "ইউরোপীয় ক্রম বিন্যাসের নিয়মাবলী" },
            { "type.hc.h11", "১২ ঘণ্টার হিসাবে (০–১১)" },
            { "type.hc.h12", "১২ ঘণ্টার হিসাবে (১–১২)" },
            { "type.hc.h23", "২৪ ঘণ্টার হিসাবে (০–২৩)" },
            { "type.hc.h24", "২৪ ঘণ্টার হিসাবে (১–২৪)" },
            { "type.m0.bgn", "ইউএস বিজিএন বর্ণান্তরণ" },
            { "type.nu.ahom", "অহম সংখ্যা" },
            { "type.nu.arab", "আরবি-ভারতীয় সংখ্যা" },
            { "type.nu.armn", "আর্মেনীয় সংখ্যা" },
            { "type.nu.bali", "বালিনীয় সংখ্যা" },
            { "type.nu.beng", "বাংলা সংখ্যা" },
            { "type.nu.brah", "ব্রাহ্মী সংখ্যা" },
            { "type.nu.cakm", "চাকমা সংখ্যা" },
            { "type.nu.cham", "চাম সংখ্যা" },
            { "type.nu.cyrl", "সিরিলিক সংখ্যা" },
            { "type.nu.deva", "দেবনাগরি সংখ্যা" },
            { "type.nu.ethi", "ইথিয়োপিক সংখ্যা" },
            { "type.nu.geor", "জর্জিয়ান সংখ্যা" },
            { "type.nu.gonm", "মাসারাম গন্ডি সংখ্যা" },
            { "type.nu.grek", "গ্রিক সংখ্যা" },
            { "type.nu.gujr", "গুজরাতি সংখ্যা" },
            { "type.nu.guru", "গুরুমুখি সংখ্যা" },
            { "type.nu.hans", "সরলিকৃত চৈনিক সংখ্যা" },
            { "type.nu.hant", "ঐতিহ্যাবাহী চৈনিক সংখ্যা" },
            { "type.nu.hebr", "হিব্রু সংখ্যা" },
            { "type.nu.hmng", "পাহয়া মং সংখ্যা" },
            { "type.nu.java", "জাভানিজ সংখ্যা" },
            { "type.nu.jpan", "জাপানি সংখ্যা" },
            { "type.nu.kali", "কায়াহ লি সংখ্যা" },
            { "type.nu.khmr", "খেমের সংখ্যা" },
            { "type.nu.knda", "কন্নড় সংখ্যা" },
            { "type.nu.lana", "টাই থাম হোরা সংখ্যা" },
            { "type.nu.laoo", "লাও সংখ্যা" },
            { "type.nu.latn", "ওয়েস্টার্ন ডিজিট" },
            { "type.nu.lepc", "লেপচা সংখ্যা" },
            { "type.nu.limb", "লিম্বু সংখ্যা" },
            { "type.nu.mlym", "মালয়ালম সংখ্যা" },
            { "type.nu.modi", "মোদি সংখ্যা" },
            { "type.nu.mong", "মঙ্গোলীয় সংখ্যা" },
            { "type.nu.mroo", "ম্রো সংখ্যা" },
            { "type.nu.mtei", "মিটিই মায়েক সংখ্যা" },
            { "type.nu.mymr", "মায়ানমার সংখ্যা" },
            { "type.nu.nkoo", "এন’কো সংখ্যা" },
            { "type.nu.olck", "অলচিকি সংখ্যা" },
            { "type.nu.orya", "ওড়িয়া সংখ্যা" },
            { "type.nu.osma", "ওসমানিয় সংখ্যা" },
            { "type.nu.saur", "সৌরাষ্ট্রের সংখ্যা" },
            { "type.nu.shrd", "সারদা সংখ্যা" },
            { "type.nu.sind", "কুদয়াদি সংখ্যা" },
            { "type.nu.sinh", "সিংহলী লিথ সংখ্যা" },
            { "type.nu.sora", "সোরা সম্পেং সংখ্যা" },
            { "type.nu.sund", "সুদানীয় সংখ্যা" },
            { "type.nu.takr", "তাক্রি সংখ্যা" },
            { "type.nu.talu", "নতুন তাই লিউ সংখ্যা" },
            { "type.nu.taml", "ঐতিহ্যবাহী তামিল সংখ্যা" },
            { "type.nu.telu", "তেলুগু সংখ্যা" },
            { "type.nu.thai", "থাই সংখ্যা" },
            { "type.nu.tibt", "তিব্বতি সংখ্যা" },
            { "type.nu.tirh", "তিরহুতা সংখ্যা" },
            { "type.nu.vaii", "ভাই সংখ্যা" },
            { "type.nu.wara", "ওয়ারেং সিটি সংখ্যা" },
            { "type.ca.dangi", "দাঙ্গি ক্যালেন্ডার" },
            { "type.co.ducet", "ডিফল্ট ইউনিকোড বাছাই বিন্যাস" },
            { "type.co.emoji", "ইমোজি বাছাই ক্রম" },
            { "type.lb.loose", "আলগা লাইন বিভাজক শৈলী" },
            { "type.nu.roman", "রোমান সংখ্যা" },
            { "type.ca.coptic", "কপটিক ক্যালেন্ডার" },
            { "type.ca.hebrew", "হিব্রু ক্যালেন্ডার" },
            { "type.ca.indian", "ভারতীয় জাতীয় বর্ষপঞ্জী" },
            { "type.co.compat", "আগের বাছাইয়ের ক্রম, সামঞ্জস্যের জন্য" },
            { "type.co.pinyin", "পিনিন সজ্জাক্রম" },
            { "type.co.search", "সাধারণ-উদ্দেশ্যে অনুসন্ধান" },
            { "type.co.stroke", "আবর্তিত সজ্জাক্রম" },
            { "type.co.unihan", "রাডিকেল স্ট্রোক বাছাই বিন্যাস" },
            { "type.co.zhuyin", "ঝুইন সজ্জাক্রম" },
            { "type.d0.fwidth", "পূর্ণপ্রস্থ পর্যন্ত" },
            { "type.d0.hwidth", "অর্ধপ্রস্থ পর্যন্ত" },
            { "type.lb.normal", "সাধারণ লাইন বিভাজক শৈলী" },
            { "type.lb.strict", "টাইট লাইন বিভাজক শৈলী" },
            { "type.m0.ungegn", "ইউএন জিইজিএন বর্ণান্তরণ" },
            { "type.ms.metric", "মেট্রিক পদ্ধতি" },
            { "type.nu.native", "স্থানীয় সংখ্যা" },
            { "type.ca.chinese", "চীনা ক্যালেন্ডার" },
            { "type.ca.islamic", "ইসলামিক ক্যালেন্ডার" },
            { "type.ca.iso8601", "গ্রেগরীয় ক্যালেন্ডার (প্রথম বর্ষ)" },
            { "type.ca.persian", "ফারসি ক্যালেন্ডার" },
            { "type.cf.account", "হিসাবের মুদ্রা বিন্যাস" },
            { "type.d0.npinyin", "সাংখিক" },
            { "type.nu.arabext", "প্রসারিত আরবি -ভারতীয় সংখ্যা" },
            { "type.nu.armnlow", "আর্মেনীয় ছোটহাতের সংখ্যা" },
            { "type.nu.finance", "অর্থনৈতিক সংখ্যাসূচক" },
            { "type.nu.greklow", "গ্রীক ছোট হাতের সংখ্যা" },
            { "type.nu.hanidec", "চৈনিক দশমিক সংখ্যা" },
            { "type.nu.hansfin", "সরলিকৃত চৈনিক আর্থিক সংখ্যা" },
            { "type.nu.hantfin", "ঐতিহ্যবাহী চৈনিক আর্থিক সংখ্যা" },
            { "type.nu.jpanfin", "জাপানি আর্থিক সংখ্যা" },
            { "type.nu.mathdbl", "গাণিতিক ডাবল-স্ট্রাক সংখ্যা" },
            { "type.nu.tamldec", "তামিল সংখ্যা" },
            { "type.ca.buddhist", "বৌদ্ধ ক্যালেন্ডার" },
            { "type.ca.ethiopic", "ইথিওপিক ক্যালেন্ডার" },
            { "type.ca.japanese", "জাপানি ক্যালেন্ডার" },
            { "type.cf.standard", "মানক মুদ্রা বিন্যাস" },
            { "type.co.phonetic", "ধ্বনি নির্দেশক বাছাই ক্রম" },
            { "type.co.reformed", "রিফর্মড বাছাই বিন্যাস" },
            { "type.co.searchjl", "হাঙ্গুল প্রাথমিক ব্যঞ্জনবর্ণ দ্বারা অনুসন্ধান করুন" },
            { "type.co.standard", "আদর্শ বাছাই বিন্যাস" },
            { "type.ms.uksystem", "ইম্পেরিয়াল পরিমাপ সিস্টেম" },
            { "type.ms.ussystem", "মার্কিন যুক্তরাষ্ট্রের পরিমাপ সিস্টেম" },
            { "type.nu.fullwide", "পূর্ণ চওড়া সংখ্যা" },
            { "type.nu.lanatham", "টাই থাম থাম সংখ্যা" },
            { "type.nu.mathbold", "গাণিতিক বোল্ড সংখ্যা" },
            { "type.nu.mathmono", "গাণিতিক মোনোস্পেস সংখ্যা" },
            { "type.nu.mathsanb", "গাণিতিক স্যান্স-শেরিফ বোল্ড সংখ্যা" },
            { "type.nu.mathsans", "গাণিতিক স্যান্স-শেরিফ সংখ্যা" },
            { "type.nu.mymrshan", "মায়ানমার শান সংখ্যা" },
            { "type.nu.mymrtlng", "মায়ানমার থাই লেয়িং সংখ্যা" },
            { "type.nu.romanlow", "রোমান ছোটহাতের সংখ্যা" },
            { "type.ca.gregorian", "গ্রিগোরিয়ান ক্যালেন্ডার" },
            { "type.co.phonebook", "ফোনবুক সজ্জাক্রম" },
            { "type.co.dictionary", "অভিধান বাছাই বিন্যাস" },
            { "type.co.traditional", "প্রথাগত বাছাই বিন্যাস" },
            { "type.nu.traditional", "ঐতিহ্যগত সংখ্যাসূচক" },
            { "type.ca.islamic-rgsa", "ইসলামিক বর্ষপঞ্জী (সৌদি আরব, দৃশ্যমান)" },
            { "type.ca.islamic-tbla", "ইসলামিক বর্ষপঞ্জী (ছকবদ্ধ, জ্যোতির্বিদ্যীয় যুগ)" },
            { "type.ca.islamic-civil", "ইসলামিক ক্যালেন্ডার (ছকবদ্ধ, নাগরিক বর্ষপঞ্জি)" },
            { "type.ca.islamic-umalqura", "ইসলামিক বর্ষপঞ্জী (উম্মা আল-কুরআ)" },
            { "type.ca.ethiopic-amete-alem", "ইথিওপিও আমেতে আলেম ক্যালেন্ডার" },
        };
        return data;
    }
}
