/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.provider.file.ModuleTypeFileProvider;
import org.openhab.core.automation.internal.provider.file.WatchServiceUtil;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ValidationException;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true, service={ModuleTypeProvider.class})
public class ModuleTypeFileProviderWatcher
extends ModuleTypeFileProvider {
    private final WatchService watchService;

    @Activate
    public ModuleTypeFileProviderWatcher(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.watchService = watchService;
    }

    @Override
    protected void initializeWatchService(String watchingDir) {
        WatchServiceUtil.initializeWatchService(watchingDir, this, this.watchService);
    }

    @Override
    protected void deactivateWatchService(String watchingDir) {
        WatchServiceUtil.deactivateWatchService(watchingDir, this);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.module.type)")
    public void addParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.addParser(parser, properties);
    }

    @Override
    public void removeParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.removeParser(parser, properties);
    }

    @Override
    protected void validateObject(ModuleType moduleType) throws ValidationException {
        String s = moduleType.getUID();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.MODULE_TYPE, null, "UID cannot be blank");
        }
        s = moduleType.getLabel();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.MODULE_TYPE, moduleType.getUID(), "Label cannot be blank");
        }
    }
}

