/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gd extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Bun-àm Acre",
               "",
               "Tìde samhraidh Acre",
               "",
               "Àm Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Bun-àm Apia",
               "",
               "Tìde samhraidh Apia",
               "",
               "Àm Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Bun-àm Eileanan Cook",
               "",
               "Leth-thìde samhraidh Eileanan Cook",
               "",
               "Àm Eileanan Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Bun-àm Cùba",
               "CST",
               "Tìde samhraidh Cùba",
               "CDT",
               "Àm Cùba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Bun-àm Fìdi",
               "",
               "Tìde samhraidh Fìdi",
               "",
               "Àm Fìdi",
               "",
            };
        final String[] Gulf = new String[] {
               "Àm a’ Chamais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Bun-àm Khovd",
               "",
               "Tìde samhraidh Khovd",
               "",
               "Àm Khovd",
               "",
            };
        final String[] Iran = new String[] {
               "Bun-àm Ioràin",
               "",
               "Tìde samhraidh Ioràin",
               "",
               "Àm Ioràin",
               "",
            };
        final String[] Niue = new String[] {
               "Àm Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Bun-àm Omsk",
               "",
               "Tìde samhraidh Omsk",
               "",
               "Àm Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Bun-àm Pearù",
               "",
               "Tìde samhraidh Pearù",
               "",
               "Àm Pearù",
               "",
            };
        final String[] Truk = new String[] {
               "Àm Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Àm Eilean Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Bun-àm na Sile",
               "",
               "Tìde samhraidh na Sile",
               "",
               "Àm na Sile",
               "",
            };
        final String[] China = new String[] {
               "Bun-àm na Sìne",
               "CST",
               "Tìde samhraidh na Sìne",
               "CDT",
               "Àm na Sìne",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Àm Eileanan Chocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Àm Dhavis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Àm nan Innseachan",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Bun-àm na Seapaine",
               "JST",
               "Tìde samhraidh na Seapaine",
               "JDT",
               "Àm na Seapaine",
               "JT",
            };
        final String[] Korea = new String[] {
               "Bun-àm Choirèa",
               "KST",
               "Tìde samhraidh Choirèa",
               "KST",
               "Àm Choirèa",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Àm Nabhru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Àm Neapàl",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Àm Palabh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Bun-àm Samotha",
               "SST",
               "Tìde samhraidh Samotha",
               "SST",
               "Àm Samotha",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Àm Shyowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Bun-àm Tonga",
               "",
               "Tìde samhraidh Tonga",
               "",
               "Àm Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Àm Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Bun-àm Alaska",
               "AKST",
               "Tìde samhraidh Alaska",
               "AKDT",
               "Àm Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Bun-àm Amasoin",
               "",
               "Tìde samhraidh Amasoin",
               "",
               "Àm Amasoin",
               "",
            };
        final String[] Azores = new String[] {
               "Bun-àm nan Eileanan Asorach",
               "",
               "Tìde samhraidh nan Eileanan Asorach",
               "",
               "Àm nan Eileanan Asorach",
               "",
            };
        final String[] Bhutan = new String[] {
               "Àm Butàin",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Àm Bhrùnaigh Dàr as-Salàm",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Bun-àm Eilean na Càisge",
               "",
               "Tìde samhraidh Eilean na Càisge",
               "",
               "Àm Eilean na Càisge",
               "",
            };
        final String[] Guyana = new String[] {
               "Àm Guidheàna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Bun-àm nan Eileanan Hawai’i ’s Aleutach",
               "HAST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Bun-àm Iosrael",
               "IST",
               "Tìde samhraidh Iosrael",
               "IDT",
               "Àm Iosrael",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Àm Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Àm Mhawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Bun-àm Mhosgo",
               "MSK",
               "Tìde samhraidh Mhosgo",
               "MSK",
               "Àm Mhosgo",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Àm Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Bun-àm Samara",
               "",
               "Tìde samhraidh Samara",
               "",
               "Àm Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Àm Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Bun-àm Taipei",
               "CST",
               "Tìde samhraidh Taipei",
               "CDT",
               "Àm Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Àm Tubhalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Àm Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Àm Uallas agus Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Bun-àm Arabach",
               "",
               "Tìde samhraidh Arabach",
               "",
               "Àm Arabach",
               "",
            };
        final String[] Armenia = new String[] {
               "Bun-àm Airmeinia",
               "",
               "Tìde samhraidh Airmeinia",
               "",
               "Àm Airmeinia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Àm Boilibhia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Bun-àm Chatham",
               "",
               "Tìde samhraidh Chatham",
               "",
               "Àm Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Àm Uile-choitcheann Co-òrdanaichte",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Àm Eacuadoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Àm Ghambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Bun-àm na Cairtbheile",
               "",
               "Tìde samhraidh na Cairtbheile",
               "",
               "Àm na Cairtbheile",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Bun-àm Irkutsk",
               "",
               "Tìde Samhraidh Irkutsk",
               "",
               "Àm Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Bun-àm Magadan",
               "",
               "Tìde Samhraidh Magadan",
               "",
               "Àm Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Àm Miànmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Bun-àm Eilein Norfolk",
               "",
               "Tìde samhraidh Eilein Norfolk",
               "",
               "Àm Eilein Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Bun-àm Fernando de Noronha",
               "",
               "Tìde Samhraidh Fernando de Noronha",
               "",
               "Àm Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Àm Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Àm Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Àm Eileanan Sholaimh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Àm Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Bun-àm Uruguaidh",
               "",
               "Tìde samhraidh Uruguaidh",
               "",
               "Àm Uruguaidh",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Bun-àm Vanuatu",
               "",
               "Tìde samhraidh Vanuatu",
               "",
               "Àm Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Bun-àm Yakutsk",
               "",
               "Tìde samhraidh Yakutsk",
               "",
               "Àm Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Bun-àm a’ Chuain Shiar",
               "AST",
               "Tìde samhraidh a’ Chuain Shiar",
               "ADT",
               "Àm a’ Chuain Shiar",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Bun-àm Bhrasília",
               "",
               "Tìde samhraidh Bhrasília",
               "",
               "Àm Bhrasília",
               "",
            };
        final String[] Chamorro = new String[] {
               "Àm Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Bun-àm Coloimbia",
               "",
               "Tìde samhraidh Coloimbia",
               "",
               "Àm Coloimbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Bun-àm nan Eileanan Fàclannach",
               "",
               "Tìde samhraidh nan Eileanan Fàclannach",
               "",
               "Àm nan Eileanan Fàclannach",
               "",
            };
        final String[] Malaysia = new String[] {
               "Àm Mhalaidhsea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Àm nan Eileanan Mhaladaibh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Bun-àm Ulan Bator",
               "",
               "Tìde samhraidh Ulan Bator",
               "",
               "Àm Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Bun-àm Pagastàin",
               "PKT",
               "Tìde samhraidh Pagastàin",
               "PKST",
               "Àm Pagastàin",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Bun-àm Paraguaidh",
               "",
               "Tìde samhraidh Paraguaidh",
               "",
               "Àm Paraguaidh",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Àm Peit a’ Chàirn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Àm Suranaim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Bun-àm na h-Argantaine",
               "",
               "Tìde samhraidh na h-Argantaine",
               "",
               "Àm na h-Argantaine",
               "",
            };
        final String[] Christmas = new String[] {
               "Àm Eilean na Nollaig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Àm Ghalapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland = new String[] {
               "Bun-àm na Graonlainne",
               "",
               "Tìde samhraidh na Graonlainne",
               "",
               "Àm na Graonlainne",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Bun-àm Hong Kong",
               "HKT",
               "Tìde samhraidh Hong Kong",
               "HKST",
               "Àm Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Àm Sìn-Innseanach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Bun-àm Petropavlovsk-Kamchatsky",
               "",
               "Tìde samhraidh Petropavlovsk-Kamchatsky",
               "",
               "Àm Petropavlovsk-Kamchatsky",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Àm Cìorgastain",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Bun-àm Lord Howe",
               "",
               "Tìde samhraidh Lord Howe",
               "",
               "Àm Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Àm Eileanan a’ Mharcais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Bun-àm nan Eileanan Mhoiriseas",
               "",
               "Tìde samhraidh nan Eileanan Mhoiriseas",
               "",
               "Àm nan Eileanan Mhoiriseas",
               "",
            };
        final String[] Singapore = new String[] {
               "Àm Singeapòr",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Àm na Bheiniseala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Bun-àm Asarbaideàin",
               "",
               "Tìde samhraidh Asarbaideàin",
               "",
               "Àm Asarbaideàin",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bun-àm Bangladais",
               "",
               "Tìde samhraidh Bangladais",
               "",
               "Àm Bangladais",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Bun-àm a’ Chip Uaine",
               "",
               "Tìde samhraidh a’ Chip Uaine",
               "",
               "Àm a’ Chip Uaine",
               "",
            };
        final String[] East_Timor = new String[] {
               "Àm Thìomor an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Àm Casachstàin",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Àm nan Eileanan Sheiseall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Àm Taidigeastàin",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Bun-àm Usbagastàn",
               "",
               "Tìde samhraidh Usbagastàn",
               "",
               "Àm Usbagastàn",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Àm Afghanastàin",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Bun-àm Krasnoyarsk",
               "",
               "Tìde samhraidh Krasnoyarsk",
               "",
               "Àm Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Bun-àm Shealainn Nuaidh",
               "NZST",
               "Tìde samhraidh Shealainn Nuaidh",
               "NZDT",
               "Àm Shealainn Nuaidh",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Bun-àm nan Eilean Filipineach",
               "PST",
               "Tìde samhraidh nan Eilean Filipineach",
               "PDT",
               "Àm nan Eilean Filipineach",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Bun-àm Vladivostok",
               "",
               "Tìde Samhraidh Vladivostok",
               "",
               "Àm Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Àm Cuan nan Innseachan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Àm Eileanan Teraina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Bun-àm Talamh an Èisg",
               "NST",
               "Tìde samhraidh Talamh an Èisg",
               "NDT",
               "Àm Talamh an Èisg",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Bun-àm Turcmanastàin",
               "",
               "Tìde samhraidh Turcmanastàin",
               "",
               "Àm Turcmanastàin",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Àm Guidheàna na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Bun-àm Chailleann Nuaidh",
               "",
               "Tìde samhraidh Chailleann Nuaidh",
               "",
               "Àm Chailleann Nuaidh",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Àm Seòrsea a Deas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Bun-àm Yekaterinburg",
               "",
               "Tìde samhraidh Yekaterinburg",
               "",
               "Àm Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Àm Meadhan Afraga",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Àm Afraga an Ear",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Àm Afraga an Iar",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Àm Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Bun-àm Meadhan na Roinn-Eòrpa",
               "CET",
               "Tìde samhraidh Meadhan na Roinn-Eòrpa",
               "CEST",
               "Àm Meadhan na Roinn-Eòrpa",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Bun-àm na Roinn-Eòrpa an Ear",
               "EET",
               "Tìde samhraidh na Roinn-Eòrpa an Ear",
               "EEST",
               "Àm na Roinn-Eòrpa an Ear",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Bun-àm na Roinn-Eòrpa an Iar",
               "WET",
               "Tìde samhraidh na Roinn-Eòrpa an Iar",
               "WEST",
               "Àm na Roinn-Eòrpa an Iar",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Bun-àm a’ Chuain Shèimh Mheagsago",
               "MST",
               "Tìde samhraidh a’ Chuain Shèimh Mheagsago",
               "MDT",
               "Àm a’ Chuain Shèimh Mheagsago",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Àm Afraga a Deas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Bun-àm Meadhan Aimeireaga",
               "CST",
               "Tìde samhraidh Meadhan Aimeireaga",
               "CDT",
               "Àm Meadhan Aimeireaga",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Bun-àm Aimeireaga an Ear",
               "EST",
               "Tìde samhraidh Aimeireaga an Ear",
               "EDT",
               "Àm Aimeireaga an Ear",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Bun-àm a’ Chuain Shèimh",
               "PST",
               "Tìde samhraidh a’ Chuain Shèimh",
               "PDT",
               "Àm a’ Chuain Shèimh",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Àm Deasach agus Antartaigeach na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Àm Eileanan Ghileabairt",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Bun-àm nan Eileanan Hawai’i ’s Aleutach",
               "HAST",
               "Tìde Samhraidh nan Eileanan Hawai’i ’s Aleutach",
               "HADT",
               "Àm nan Eileanan Hawai’i ’s Aleutach",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Àm Eileanan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Bun-àm Saint Pierre agus Miquelon",
               "",
               "Tìde Samhraidh Saint Pierre agus Miquelon",
               "",
               "Àm Saint Pierre agus Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Bun-àm Monadh Aimeireaga",
               "MST",
               "Tìde samhraidh Monadh Aimeireaga",
               "MDT",
               "Àm Monadh Aimeireaga",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Àm Eileanan Mharshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Àm Gini Nuaidh Paputhaiche",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Bun-àm Meadhan Astràilia",
               "ACST",
               "Tìde samhraidh Meadhan Astràilia",
               "ACDT",
               "Àm Meadhan Astràilia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Bun-àm Astràilia an Ear",
               "AEST",
               "Tìde samhraidh Astràilia an Ear",
               "AEDT",
               "Àm Astràilia an Ear",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Bun-àm Astràilia an Iar",
               "AWST",
               "Tìde samhraidh Astràilia an Iar",
               "AWDT",
               "Àm Astràilia an Iar",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Àm Meadhan nan Innd-Innse",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Àm nan Innd-Innse an Ear",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Àm nan Innd-Innse an Iar",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Bun-àm Meadhan Astràilia an Iar",
               "",
               "Tìde samhraidh Meadhan Astràilia an Iar",
               "",
               "Àm Meadhan Astràilia an Iar",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Bun-àm na h-Èireann",
                    "TSÈ (Èirinn)",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "America/Nuuk", Greenland },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Àm Uile-choitcheann Co-òrdanaichte",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Bun-àm na h-Èireann",
                    "TSÈ (Èirinn)",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Tìde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Scoresbysund", Greenland },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Gàsa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammān" },
            { "timezone.excity.Asia/Macau", "Macàthu" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Tokyo", "Tōkyō" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aqtöbe" },
            { "timezone.excity.Asia/Brunei", "Brùnaigh" },
            { "timezone.excity.Asia/Kuwait", "Cuibhèit" },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Tehrān" },
            { "timezone.excity.Etc/Unknown", "Baile neo-aithnichte" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Riga", "Rīga" },
            { "timezone.excity.Europe/Rome", "An Ròimh" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baghdād" },
            { "timezone.excity.Asia/Bahrain", "Bachrain" },
            { "timezone.excity.Asia/Bishkek", "Biškek" },
            { "timezone.excity.Asia/Karachi", "Karācī" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "T’bilisi" },
            { "timezone.excity.Europe/Paris", "Paras" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "timezone.excity.Pacific/Fiji", "Fìdi" },
            { "timezone.excity.Africa/Asmera", "Asmarà" },
            { "timezone.excity.America/Aruba", "Arùba" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "Aşgabat" },
            { "timezone.excity.Asia/Dushanbe", "Dušanbe" },
            { "timezone.excity.Asia/Qostanay", "Qostanaı" },
            { "timezone.excity.Asia/Tashkent", "Toškent" },
            { "timezone.excity.Europe/Athens", "An Àithne" },
            { "timezone.excity.Europe/Dublin", "Baile Àtha Cliath" },
            { "timezone.excity.Europe/Jersey", "Deàrsaidh" },
            { "timezone.excity.Europe/London", "Dùn Èideann/Lunnainn" },
            { "timezone.excity.Europe/Moscow", "Mosgo" },
            { "timezone.excity.Europe/Prague", "Pràg" },
            { "timezone.excity.Europe/Tirane", "Tiranë" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Pacific/Nauru", "Nabhru" },
            { "timezone.excity.Pacific/Palau", "Palabh" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "A’ Bheilìs" },
            { "timezone.excity.America/Cayman", "Caimean" },
            { "timezone.excity.America/Guyana", "Guidheàna" },
            { "timezone.excity.America/Inuvik", "Inuuvik" },
            { "timezone.excity.Asia/Jerusalem", "Ierusalam" },
            { "timezone.excity.Asia/Pyongyang", "Pyeongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Qızılorda" },
            { "timezone.excity.Asia/Singapore", "Singeapòr" },
            { "timezone.excity.Asia/Vientiane", "Viang Chan" },
            { "timezone.excity.Europe/Vatican", "A’ Bhatacan" },
            { "timezone.excity.Pacific/Easter", "Rapa Nui" },
            { "timezone.excity.Pacific/Wallis", "Uallas" },
            { "timezone.excity.Africa/Djibouti", "Diobùtaidh" },
            { "timezone.excity.Africa/Ndjamena", "N’Djaména" },
            { "timezone.excity.America/Antigua", "Aintìoga" },
            { "timezone.excity.America/Grenada", "Greanàda" },
            { "timezone.excity.America/Jamaica", "Diameuga" },
            { "timezone.excity.Atlantic/Azores", "Ponta Delgada" },
            { "timezone.excity.Atlantic/Canary", "Na h-Eileanan Canàrach" },
            { "timezone.excity.Atlantic/Faeroe", "Fàro" },
            { "timezone.excity.Europe/Brussels", "A’ Bhruiseal" },
            { "timezone.excity.Europe/Guernsey", "Geàrnsaidh" },
            { "timezone.excity.Indian/Maldives", "Na h-Eileanan Mhaladaibh" },
            { "timezone.excity.Pacific/Gambier", "Mangareva" },
            { "timezone.excity.America/Anguilla", "Anguillia" },
            { "timezone.excity.America/Dominica", "Doiminicea" },
            { "timezone.excity.America/New_York", "Nuadh Eabhrac" },
            { "timezone.excity.America/Resolute", "Qausuittuq" },
            { "timezone.excity.America/St_Kitts", "Naomh Crìstean" },
            { "timezone.excity.America/St_Lucia", "Naomh Lùisea" },
            { "timezone.excity.Atlantic/Bermuda", "Bearmùda" },
            { "timezone.excity.Australia/Sydney", "Sidni" },
            { "timezone.excity.Europe/Gibraltar", "Diobraltar" },
            { "timezone.excity.Indian/Christmas", "Nollaig" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenn" },
            { "timezone.excity.Indian/Mauritius", "Na h-Eileanan Mhoiriseas" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Peit a’ Chàirn" },
            { "timezone.excity.America/Glace_Bay", "Glasbaidh" },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "timezone.excity.Europe/Copenhagen", "Beirbh" },
            { "timezone.excity.Europe/Luxembourg", "Lugsamburg" },
            { "timezone.excity.Pacific/Enderbury", "Eilean Canton" },
            { "timezone.excity.Pacific/Marquesas", "Eileanan a’ Mharcais" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abäba" },
            { "timezone.excity.America/Costa_Rica", "Costa Rìcea" },
            { "timezone.excity.America/Grand_Turk", "An Turc Mhòr" },
            { "timezone.excity.America/Guadeloupe", "Guadalup" },
            { "timezone.excity.America/Martinique", "Mairtinic" },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "timezone.excity.America/St_Vincent", "Naomh Bhionsant" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Eilean Naomh Eilidh" },
            { "timezone.excity.Europe/Isle_of_Man", "Eilean Mhanainn" },
            { "timezone.excity.Africa/Johannesburg", "Hannsaborgh" },
            { "timezone.excity.America/El_Salvador", "An Salbhador" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheagsago" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rìceo" },
            { "timezone.excity.Atlantic/Cape_Verde", "An Ceap Uaine" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dàr as-Salàm" },
            { "timezone.excity.America/Rankin_Inlet", "Kangiqliniq" },
            { "timezone.excity.Antarctica/Macquarie", "Eilean MhicGuaire" },
            { "timezone.excity.America/Port_of_Spain", "Port na Spàinne" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthélemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Seòrsea a Deas" },
        };
        return data;
    }
}
