// Copyright 2019 The Fuchsia Authors
//
// Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
// <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
// This file may not be copied, modified, or distributed except according to
// those terms.

#[macro_use]
extern crate zerocopy_renamed;

#[path = "../include.rs"]
mod util;

use zerocopy_renamed::KnownLayout;

use self::util::util::{NotZerocopy, AU16};

fn main() {}

// These tests cause errors which are generated by a later compilation pass than
// the other errors we generate, and so if they're compiled in the same file,
// the compiler will never get to that pass, and so we won't get the errors.

//
// TryFromBytes errors
//

#[derive(TryFromBytes)]
#[zerocopy(crate = "zerocopy_renamed")]
struct TryFromBytes1 {
    value: NotZerocopy,
}

//
// FromZeros errors
//

#[derive(FromZeros)]
#[zerocopy(crate = "zerocopy_renamed")]
struct FromZeros1 {
    value: NotZerocopy,
}

//
// FromBytes errors
//

#[derive(FromBytes)]
#[zerocopy(crate = "zerocopy_renamed")]
struct FromBytes1 {
    value: NotZerocopy,
}

//
// IntoBytes errors
//

#[derive(IntoBytes)]
#[zerocopy(crate = "zerocopy_renamed")]
#[repr(C)]
struct IntoBytes1 {
    value: NotZerocopy,
}

//
// Unaligned errors
//

#[derive(Unaligned)]
#[zerocopy(crate = "zerocopy_renamed")]
#[repr(C)]
struct Unaligned1 {
    aligned: AU16,
}

// This specifically tests a bug we had in an old version of the code in which
// the trait bound would only be enforced for the first field's type.
#[derive(Unaligned)]
#[zerocopy(crate = "zerocopy_renamed")]
#[repr(C)]
struct Unaligned2 {
    unaligned: u8,
    aligned: AU16,
}

#[derive(Unaligned)]
#[zerocopy(crate = "zerocopy_renamed")]
#[repr(transparent)]
struct Unaligned3 {
    aligned: AU16,
}
