// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::create_token_with_iam::_create_token_with_iam_input::CreateTokenWithIamInputBuilder;

pub use crate::operation::create_token_with_iam::_create_token_with_iam_output::CreateTokenWithIamOutputBuilder;

impl crate::operation::create_token_with_iam::builders::CreateTokenWithIamInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::create_token_with_iam::CreateTokenWithIamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_token_with_iam::CreateTokenWithIAMError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.create_token_with_iam();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CreateTokenWithIAM`.
///
/// <p>Creates and returns access and refresh tokens for authorized client applications that are authenticated using any IAM entity, such as a service role or user. These tokens might contain defined scopes that specify permissions such as <code>read:profile</code> or <code>write:data</code>. Through downscoping, you can use the scopes parameter to request tokens with reduced permissions compared to the original client application's permissions or, if applicable, the refresh token's scopes. The access token can be used to fetch short-lived credentials for the assigned Amazon Web Services accounts or to access application APIs using <code>bearer</code> authentication.</p><note>
/// <p>This API is used with Signature Version 4. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">Amazon Web Services Signature Version 4 for API Requests</a>.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CreateTokenWithIAMFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::create_token_with_iam::builders::CreateTokenWithIamInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::create_token_with_iam::CreateTokenWithIamOutput,
        crate::operation::create_token_with_iam::CreateTokenWithIAMError,
    > for CreateTokenWithIAMFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::create_token_with_iam::CreateTokenWithIamOutput,
            crate::operation::create_token_with_iam::CreateTokenWithIAMError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CreateTokenWithIAMFluentBuilder {
    /// Creates a new `CreateTokenWithIAMFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CreateTokenWithIAM as a reference.
    pub fn as_input(&self) -> &crate::operation::create_token_with_iam::builders::CreateTokenWithIamInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_token_with_iam::CreateTokenWithIamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_token_with_iam::CreateTokenWithIAMError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::create_token_with_iam::CreateTokenWithIAM::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::create_token_with_iam::CreateTokenWithIAM::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::create_token_with_iam::CreateTokenWithIamOutput,
        crate::operation::create_token_with_iam::CreateTokenWithIAMError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.</p>
    pub fn client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_id(input.into());
        self
    }
    /// <p>The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.</p>
    pub fn set_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_id(input);
        self
    }
    /// <p>The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.</p>
    pub fn get_client_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_id()
    }
    /// <p>Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:</p>
    /// <p>* Authorization Code - <code>authorization_code</code></p>
    /// <p>* Refresh Token - <code>refresh_token</code></p>
    /// <p>* JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code></p>
    /// <p>* Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code></p>
    pub fn grant_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_type(input.into());
        self
    }
    /// <p>Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:</p>
    /// <p>* Authorization Code - <code>authorization_code</code></p>
    /// <p>* Refresh Token - <code>refresh_token</code></p>
    /// <p>* JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code></p>
    /// <p>* Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code></p>
    pub fn set_grant_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_type(input);
        self
    }
    /// <p>Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:</p>
    /// <p>* Authorization Code - <code>authorization_code</code></p>
    /// <p>* Refresh Token - <code>refresh_token</code></p>
    /// <p>* JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code></p>
    /// <p>* Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code></p>
    pub fn get_grant_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_type()
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This short-lived code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.</p>
    pub fn code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.code(input.into());
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This short-lived code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.</p>
    pub fn set_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_code(input);
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This short-lived code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.</p>
    pub fn get_code(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_code()
    }
    /// <p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-lived tokens, such as the access token, that might expire.</p>
    /// <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>
    pub fn refresh_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.refresh_token(input.into());
        self
    }
    /// <p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-lived tokens, such as the access token, that might expire.</p>
    /// <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>
    pub fn set_refresh_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_refresh_token(input);
        self
    }
    /// <p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-lived tokens, such as the access token, that might expire.</p>
    /// <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>
    pub fn get_refresh_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_refresh_token()
    }
    /// <p>Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.</p>
    pub fn assertion(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.assertion(input.into());
        self
    }
    /// <p>Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.</p>
    pub fn set_assertion(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_assertion(input);
        self
    }
    /// <p>Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.</p>
    pub fn get_assertion(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_assertion()
    }
    ///
    /// Appends an item to `scope`.
    ///
    /// To override the contents of this collection use [`set_scope`](Self::set_scope).
    ///
    /// <p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: <code>openid</code>, <code>aws</code>, <code>sts:identity_context</code>.</p>
    pub fn scope(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.scope(input.into());
        self
    }
    /// <p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: <code>openid</code>, <code>aws</code>, <code>sts:identity_context</code>.</p>
    pub fn set_scope(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_scope(input);
        self
    }
    /// <p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: <code>openid</code>, <code>aws</code>, <code>sts:identity_context</code>.</p>
    pub fn get_scope(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_scope()
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p>
    pub fn redirect_uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.redirect_uri(input.into());
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p>
    pub fn set_redirect_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_redirect_uri(input);
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p>
    pub fn get_redirect_uri(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_redirect_uri()
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.</p>
    pub fn subject_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.subject_token(input.into());
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.</p>
    pub fn set_subject_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_subject_token(input);
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.</p>
    pub fn get_subject_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_subject_token()
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    pub fn subject_token_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.subject_token_type(input.into());
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    pub fn set_subject_token_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_subject_token_type(input);
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    pub fn get_subject_token_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_subject_token_type()
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    /// <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code></p>
    pub fn requested_token_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.requested_token_type(input.into());
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    /// <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code></p>
    pub fn set_requested_token_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_requested_token_type(input);
        self
    }
    /// <p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:</p>
    /// <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p>
    /// <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code></p>
    pub fn get_requested_token_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_requested_token_type()
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.</p>
    pub fn code_verifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.code_verifier(input.into());
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.</p>
    pub fn set_code_verifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_code_verifier(input);
        self
    }
    /// <p>Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.</p>
    pub fn get_code_verifier(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_code_verifier()
    }
}
