package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadVpnConnectionConfig invokes the vpc.DownloadVpnConnectionConfig API synchronously
func (client *Client) DownloadVpnConnectionConfig(request *DownloadVpnConnectionConfigRequest) (response *DownloadVpnConnectionConfigResponse, err error) {
	response = CreateDownloadVpnConnectionConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadVpnConnectionConfigWithChan invokes the vpc.DownloadVpnConnectionConfig API asynchronously
func (client *Client) DownloadVpnConnectionConfigWithChan(request *DownloadVpnConnectionConfigRequest) (<-chan *DownloadVpnConnectionConfigResponse, <-chan error) {
	responseChan := make(chan *DownloadVpnConnectionConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadVpnConnectionConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadVpnConnectionConfigWithCallback invokes the vpc.DownloadVpnConnectionConfig API asynchronously
func (client *Client) DownloadVpnConnectionConfigWithCallback(request *DownloadVpnConnectionConfigRequest, callback func(response *DownloadVpnConnectionConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadVpnConnectionConfigResponse
		var err error
		defer close(result)
		response, err = client.DownloadVpnConnectionConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadVpnConnectionConfigRequest is the request struct for api DownloadVpnConnectionConfig
type DownloadVpnConnectionConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
}

// DownloadVpnConnectionConfigResponse is the response struct for api DownloadVpnConnectionConfig
type DownloadVpnConnectionConfigResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	VpnConnectionConfig VpnConnectionConfig `json:"VpnConnectionConfig" xml:"VpnConnectionConfig"`
}

// CreateDownloadVpnConnectionConfigRequest creates a request to invoke DownloadVpnConnectionConfig API
func CreateDownloadVpnConnectionConfigRequest() (request *DownloadVpnConnectionConfigRequest) {
	request = &DownloadVpnConnectionConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DownloadVpnConnectionConfig", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDownloadVpnConnectionConfigResponse creates a response to parse from DownloadVpnConnectionConfig response
func CreateDownloadVpnConnectionConfigResponse() (response *DownloadVpnConnectionConfigResponse) {
	response = &DownloadVpnConnectionConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
