package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KeepAlive invokes the unimkt.KeepAlive API synchronously
func (client *Client) KeepAlive(request *KeepAliveRequest) (response *KeepAliveResponse, err error) {
	response = CreateKeepAliveResponse()
	err = client.DoAction(request, response)
	return
}

// KeepAliveWithChan invokes the unimkt.KeepAlive API asynchronously
func (client *Client) KeepAliveWithChan(request *KeepAliveRequest) (<-chan *KeepAliveResponse, <-chan error) {
	responseChan := make(chan *KeepAliveResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KeepAlive(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KeepAliveWithCallback invokes the unimkt.KeepAlive API asynchronously
func (client *Client) KeepAliveWithCallback(request *KeepAliveRequest, callback func(response *KeepAliveResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KeepAliveResponse
		var err error
		defer close(result)
		response, err = client.KeepAlive(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KeepAliveRequest is the request struct for api KeepAlive
type KeepAliveRequest struct {
	*requests.RpcRequest
	Tac         string           `position:"Body" name:"Tac"`
	NetworkType requests.Integer `position:"Body" name:"NetworkType"`
	CellId      string           `position:"Body" name:"CellId"`
	DeviceSn    string           `position:"Body" name:"DeviceSn"`
	ChannelId   string           `position:"Body" name:"ChannelId"`
}

// KeepAliveResponse is the response struct for api KeepAlive
type KeepAliveResponse struct {
	*responses.BaseResponse
	Status    bool   `json:"Status" xml:"Status"`
	Msg       string `json:"Msg" xml:"Msg"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateKeepAliveRequest creates a request to invoke KeepAlive API
func CreateKeepAliveRequest() (request *KeepAliveRequest) {
	request = &KeepAliveRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "KeepAlive", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateKeepAliveResponse creates a response to parse from KeepAlive response
func CreateKeepAliveResponse() (response *KeepAliveResponse) {
	response = &KeepAliveResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
