package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplication invokes the ens.DescribeApplication API synchronously
func (client *Client) DescribeApplication(request *DescribeApplicationRequest) (response *DescribeApplicationResponse, err error) {
	response = CreateDescribeApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationWithChan invokes the ens.DescribeApplication API asynchronously
func (client *Client) DescribeApplicationWithChan(request *DescribeApplicationRequest) (<-chan *DescribeApplicationResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationWithCallback invokes the ens.DescribeApplication API asynchronously
func (client *Client) DescribeApplicationWithCallback(request *DescribeApplicationRequest, callback func(response *DescribeApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationRequest is the request struct for api DescribeApplication
type DescribeApplicationRequest struct {
	*requests.RpcRequest
	AppVersions         string `position:"Query" name:"AppVersions"`
	OutDetailStatParams string `position:"Query" name:"OutDetailStatParams"`
	Level               string `position:"Query" name:"Level"`
	AppId               string `position:"Query" name:"AppId"`
}

// DescribeApplicationResponse is the response struct for api DescribeApplication
type DescribeApplicationResponse struct {
	*responses.BaseResponse
	Application string `json:"Application" xml:"Application"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeApplicationRequest creates a request to invoke DescribeApplication API
func CreateDescribeApplicationRequest() (request *DescribeApplicationRequest) {
	request = &DescribeApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeApplication", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApplicationResponse creates a response to parse from DescribeApplication response
func CreateDescribeApplicationResponse() (response *DescribeApplicationResponse) {
	response = &DescribeApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
