package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIDCImportCommand invokes the edas.CreateIDCImportCommand API synchronously
func (client *Client) CreateIDCImportCommand(request *CreateIDCImportCommandRequest) (response *CreateIDCImportCommandResponse, err error) {
	response = CreateCreateIDCImportCommandResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIDCImportCommandWithChan invokes the edas.CreateIDCImportCommand API asynchronously
func (client *Client) CreateIDCImportCommandWithChan(request *CreateIDCImportCommandRequest) (<-chan *CreateIDCImportCommandResponse, <-chan error) {
	responseChan := make(chan *CreateIDCImportCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIDCImportCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIDCImportCommandWithCallback invokes the edas.CreateIDCImportCommand API asynchronously
func (client *Client) CreateIDCImportCommandWithCallback(request *CreateIDCImportCommandRequest, callback func(response *CreateIDCImportCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIDCImportCommandResponse
		var err error
		defer close(result)
		response, err = client.CreateIDCImportCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIDCImportCommandRequest is the request struct for api CreateIDCImportCommand
type CreateIDCImportCommandRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Body" name:"ClusterId"`
}

// CreateIDCImportCommandResponse is the response struct for api CreateIDCImportCommand
type CreateIDCImportCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateIDCImportCommandRequest creates a request to invoke CreateIDCImportCommand API
func CreateCreateIDCImportCommandRequest() (request *CreateIDCImportCommandRequest) {
	request = &CreateIDCImportCommandRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateIDCImportCommand", "/pop/v5/create_idc_import_command", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIDCImportCommandResponse creates a response to parse from CreateIDCImportCommand response
func CreateCreateIDCImportCommandResponse() (response *CreateIDCImportCommandResponse) {
	response = &CreateIDCImportCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
