package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCompliancePacks invokes the config.DeleteCompliancePacks API synchronously
func (client *Client) DeleteCompliancePacks(request *DeleteCompliancePacksRequest) (response *DeleteCompliancePacksResponse, err error) {
	response = CreateDeleteCompliancePacksResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCompliancePacksWithChan invokes the config.DeleteCompliancePacks API asynchronously
func (client *Client) DeleteCompliancePacksWithChan(request *DeleteCompliancePacksRequest) (<-chan *DeleteCompliancePacksResponse, <-chan error) {
	responseChan := make(chan *DeleteCompliancePacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCompliancePacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCompliancePacksWithCallback invokes the config.DeleteCompliancePacks API asynchronously
func (client *Client) DeleteCompliancePacksWithCallback(request *DeleteCompliancePacksRequest, callback func(response *DeleteCompliancePacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCompliancePacksResponse
		var err error
		defer close(result)
		response, err = client.DeleteCompliancePacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCompliancePacksRequest is the request struct for api DeleteCompliancePacks
type DeleteCompliancePacksRequest struct {
	*requests.RpcRequest
	ClientToken       string           `position:"Body" name:"ClientToken"`
	CompliancePackIds string           `position:"Body" name:"CompliancePackIds"`
	DeleteRule        requests.Boolean `position:"Body" name:"DeleteRule"`
}

// DeleteCompliancePacksResponse is the response struct for api DeleteCompliancePacks
type DeleteCompliancePacksResponse struct {
	*responses.BaseResponse
	RequestId                    string                       `json:"RequestId" xml:"RequestId"`
	OperateCompliancePacksResult OperateCompliancePacksResult `json:"OperateCompliancePacksResult" xml:"OperateCompliancePacksResult"`
}

// CreateDeleteCompliancePacksRequest creates a request to invoke DeleteCompliancePacks API
func CreateDeleteCompliancePacksRequest() (request *DeleteCompliancePacksRequest) {
	request = &DeleteCompliancePacksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "DeleteCompliancePacks", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCompliancePacksResponse creates a response to parse from DeleteCompliancePacks response
func CreateDeleteCompliancePacksResponse() (response *DeleteCompliancePacksResponse) {
	response = &DeleteCompliancePacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
