package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOperatorPermission invokes the adb.DescribeOperatorPermission API synchronously
func (client *Client) DescribeOperatorPermission(request *DescribeOperatorPermissionRequest) (response *DescribeOperatorPermissionResponse, err error) {
	response = CreateDescribeOperatorPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOperatorPermissionWithChan invokes the adb.DescribeOperatorPermission API asynchronously
func (client *Client) DescribeOperatorPermissionWithChan(request *DescribeOperatorPermissionRequest) (<-chan *DescribeOperatorPermissionResponse, <-chan error) {
	responseChan := make(chan *DescribeOperatorPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOperatorPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOperatorPermissionWithCallback invokes the adb.DescribeOperatorPermission API asynchronously
func (client *Client) DescribeOperatorPermissionWithCallback(request *DescribeOperatorPermissionRequest, callback func(response *DescribeOperatorPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOperatorPermissionResponse
		var err error
		defer close(result)
		response, err = client.DescribeOperatorPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOperatorPermissionRequest is the request struct for api DescribeOperatorPermission
type DescribeOperatorPermissionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeOperatorPermissionResponse is the response struct for api DescribeOperatorPermission
type DescribeOperatorPermissionResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Privileges  string `json:"Privileges" xml:"Privileges"`
	CreatedTime string `json:"CreatedTime" xml:"CreatedTime"`
	ExpiredTime string `json:"ExpiredTime" xml:"ExpiredTime"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
}

// CreateDescribeOperatorPermissionRequest creates a request to invoke DescribeOperatorPermission API
func CreateDescribeOperatorPermissionRequest() (request *DescribeOperatorPermissionRequest) {
	request = &DescribeOperatorPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeOperatorPermission", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOperatorPermissionResponse creates a response to parse from DescribeOperatorPermission response
func CreateDescribeOperatorPermissionResponse() (response *DescribeOperatorPermissionResponse) {
	response = &DescribeOperatorPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
