/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jn\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\b\b\u0000\u0010\b*\u00020\n\"\u0004\b\u0001\u0010\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r0\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "<init>", "()V", "OFFLOAD_IO", "", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSizeHint", "", "totalReads", "", "totalReadsUncached", "totalEvicted", "CaffeineCache", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,559:1\n25#2:560\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider\n*L\n333#1:560\n*E\n"})
public final class CaffeineIndexStorageCacheProvider
implements MapIndexStorageCacheProvider {
    private final boolean OFFLOAD_IO = SystemProperties.getBooleanProperty("indexes.storage-cache.offload-io", false);

    public CaffeineIndexStorageCacheProvider() {
        CaffeineIndexStorageCacheProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CaffeineIndexStorageCacheProvider.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        logger.info("Caffeine cache will be used for indexes (offload IO: " + this.OFFLOAD_IO + ')');
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSizeHint) {
        Intrinsics.checkNotNullParameter(valueReader, "valueReader");
        Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
        Intrinsics.checkNotNullParameter(hashingStrategy, "hashingStrategy");
        return new CaffeineCache<Key, Value>(valueReader, evictedValuesPersister, this.OFFLOAD_IO, hashingStrategy, cacheSizeHint);
    }

    @Override
    public long totalReads() {
        return 0L;
    }

    @Override
    public long totalReadsUncached() {
        return 0L;
    }

    @Override
    public long totalEvicted() {
        return 0L;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001\u001dBY\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider$CaffeineCache;", "Key", "", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "offloadIO", "", "equalityPolicy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "<init>", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;ZLcom/intellij/util/containers/hash/EqualityPolicy;I)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider$CaffeineCache$KeyWithCustomEquality;", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "getCachedValues", "", "invalidateAll", "", "KeyWithCustomEquality", "intellij.platform.util"})
    private static final class CaffeineCache<Key, Value>
    implements MapIndexStorageCache<Key, Value> {
        @NotNull
        private final EqualityPolicy<Key> equalityPolicy;
        @NotNull
        private final LoadingCache<KeyWithCustomEquality<Key>, ChangeTrackingValueContainer<Value>> cache;

        public CaffeineCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, boolean offloadIO, @NotNull EqualityPolicy<Key> equalityPolicy, int cacheSize) {
            Intrinsics.checkNotNullParameter(valueReader, "valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
            Intrinsics.checkNotNullParameter(equalityPolicy, "equalityPolicy");
            this.equalityPolicy = equalityPolicy;
            CacheLoader valuesLoader = arg_0 -> CaffeineCache._init_$lambda$0(valueReader, arg_0);
            RemovalListener onEvict = (arg_0, arg_1, arg_2) -> CaffeineCache._init_$lambda$1(evictedValuesPersister, arg_0, arg_1, arg_2);
            Executor evictionExecutor = offloadIO ? ExecutorsKt.asExecutor(Dispatchers.getIO()) : CaffeineCache::_init_$lambda$2;
            this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).executor(evictionExecutor).removalListener(onEvict).build(valuesLoader);
        }

        @Override
        @NotNull
        public ChangeTrackingValueContainer<Value> read(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            Object object = this.cache.get(new KeyWithCustomEquality<Key>(key, this.equalityPolicy));
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            return (ChangeTrackingValueContainer)object;
        }

        @Override
        @Nullable
        public ChangeTrackingValueContainer<Value> readIfCached(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return (ChangeTrackingValueContainer)this.cache.getIfPresent(new KeyWithCustomEquality<Key>(key, this.equalityPolicy));
        }

        @Override
        @NotNull
        public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
            return this.cache.asMap().values();
        }

        @Override
        public void invalidateAll() {
            this.cache.invalidateAll();
        }

        private static final ChangeTrackingValueContainer _init_$lambda$0(Function $valueReader, KeyWithCustomEquality wrappedKey) {
            return (ChangeTrackingValueContainer)$valueReader.apply(wrappedKey.getKey());
        }

        private static final void _init_$lambda$1(BiConsumer $evictedValuesPersister, KeyWithCustomEquality wrappedKey, ChangeTrackingValueContainer container, RemovalCause removalCause) {
            if (container != null && wrappedKey != null) {
                $evictedValuesPersister.accept(wrappedKey.getKey(), container);
            }
        }

        private static final void _init_$lambda$2(Runnable it) {
            it.run();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/impl/CaffeineIndexStorageCacheProvider$CaffeineCache$KeyWithCustomEquality;", "K", "", "key", "equality", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "<init>", "(Ljava/lang/Object;Lcom/intellij/util/containers/hash/EqualityPolicy;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "intellij.platform.util"})
        private static final class KeyWithCustomEquality<K> {
            private final K key;
            @NotNull
            private final EqualityPolicy<K> equality;

            public KeyWithCustomEquality(K key, @NotNull EqualityPolicy<K> equality) {
                Intrinsics.checkNotNullParameter(equality, "equality");
                this.key = key;
                this.equality = equality;
            }

            public final K getKey() {
                return this.key;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.util.indexing.impl.CaffeineIndexStorageCacheProvider.CaffeineCache.KeyWithCustomEquality<K of com.intellij.util.indexing.impl.CaffeineIndexStorageCacheProvider.CaffeineCache.KeyWithCustomEquality>");
                KeyWithCustomEquality cfr_ignored_0 = (KeyWithCustomEquality)other;
                if (this.equality != ((KeyWithCustomEquality)other).equality) {
                    return false;
                }
                return this.equality.isEqual(this.key, ((KeyWithCustomEquality)other).key);
            }

            public int hashCode() {
                return this.equality.getHashCode(this.key);
            }
        }
    }
}

