/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColorIcon;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.repo.GitRepository;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0013\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\t0\t\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/ui/branch/GitBranchesTreeIconProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "forRef", "Ljavax/swing/Icon;", "gitReference", "Lgit4idea/GitReference;", "current", "", "favorite", "selected", "favoriteToggleOnClick", "forRepository", "Lcom/intellij/util/ui/ColorIcon;", "repository", "Lgit4idea/repo/GitRepository;", "forGroup", "kotlin.jvm.PlatformType", "()Ljavax/swing/Icon;", "intellij.vcs.git"})
public final class GitBranchesTreeIconProvider {
    @NotNull
    private final VcsLogColorManager colorManager;

    public GitBranchesTreeIconProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(project);
    }

    @NotNull
    public final Icon forRef(@NotNull GitReference gitReference, boolean current, boolean favorite, boolean selected, boolean favoriteToggleOnClick) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)gitReference, (String)"gitReference");
        if (selected && !favorite && favoriteToggleOnClick) {
            Icon icon2 = AllIcons.Nodes.NotFavoriteOnHover;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NotFavoriteOnHover");
        } else if (current && favorite) {
            Icon icon3 = DvcsImplIcons.CurrentBranchFavoriteLabel;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CurrentBranchFavoriteLabel");
        } else if (current) {
            Icon icon4 = DvcsImplIcons.CurrentBranchLabel;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"CurrentBranchLabel");
        } else if (favorite) {
            Icon icon5 = AllIcons.Nodes.Favorite;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Favorite");
        } else if (gitReference instanceof GitTag) {
            Icon icon6 = DvcsImplIcons.BranchLabel;
            icon = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"BranchLabel");
        } else {
            Icon icon7 = AllIcons.Vcs.BranchNode;
            icon = icon7;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"BranchNode");
        }
        return icon;
    }

    public static /* synthetic */ Icon forRef$default(GitBranchesTreeIconProvider gitBranchesTreeIconProvider, GitReference gitReference, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        return gitBranchesTreeIconProvider.forRef(gitReference, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final ColorIcon forRepository(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return RepositoryChangesBrowserNode.Companion.getRepositoryIcon((Repository)repository, this.colorManager);
    }

    public final Icon forGroup() {
        return PlatformIcons.FOLDER_ICON;
    }
}

