/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeBundle;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageInstallationErrorDialog;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.management.PythonPackagesInstaller;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class PyPackageManagerUI {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PyPackageManagerUI.class);
    @Nullable
    private final Listener myListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Sdk mySdk;

    public PyPackageManagerUI(@NotNull Project project, @NotNull Sdk sdk2, @Nullable Listener listener2) {
        if (project == null) {
            PyPackageManagerUI.$$$reportNull$$$0(0);
        }
        if (sdk2 == null) {
            PyPackageManagerUI.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySdk = sdk2;
        this.myListener = listener2;
    }

    public void installManagement() {
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        ProgressManager.getInstance().run((Task)new InstallManagementTask(this.myProject, this.mySdk, this.myListener));
    }

    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) {
        if (extraArgs == null) {
            PyPackageManagerUI.$$$reportNull$$$0(2);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        ProgressManager.getInstance().run((Task)new InstallTask(this.myProject, this.mySdk, requirements, extraArgs, this.myListener));
    }

    public void uninstall(@NotNull List<PyPackage> packages2) {
        if (packages2 == null) {
            PyPackageManagerUI.$$$reportNull$$$0(3);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        if (this.checkDependents(packages2)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new UninstallTask(this.myProject, this.mySdk, this.myListener, packages2));
    }

    private boolean checkDependents(@NotNull List<PyPackage> packages2) {
        if (packages2 == null) {
            PyPackageManagerUI.$$$reportNull$$$0(4);
        }
        try {
            Map<String, Set<PyPackage>> dependentPackages = PyPackageManagerUI.collectDependents(packages2, this.mySdk);
            if (dependentPackages.isEmpty()) {
                return false;
            }
            boolean[] warning = new boolean[]{true};
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (dependentPackages.size() == 1) {
                    Map.Entry packageToDependents = (Map.Entry)ContainerUtil.getOnlyItem(dependentPackages.entrySet());
                    assert (packageToDependents != null);
                    Set dependents = (Set)packageToDependents.getValue();
                    String message = PyBundle.message("python.packaging.dialog.description.attempt.to.uninstall.for.one.dependent.package", packageToDependents.getKey(), StringUtil.join((Iterable)dependents, (String)", "), dependents.size());
                    warning[0] = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)PyBundle.message("python.packaging.warning", new Object[0]), (String)message).asWarning()).ask(this.myProject);
                } else {
                    ArrayList<String> dep = new ArrayList<String>();
                    for (Map.Entry entry : dependentPackages.entrySet()) {
                        dep.add(PyBundle.message("python.packaging.dialog.description.attempt.to.uninstall.for.several.dependent.packages.single.package.description", entry.getKey(), StringUtil.join((Iterable)((Iterable)entry.getValue()), (String)", ")));
                    }
                    String message = PyBundle.message("python.packaging.dialog.description.attempt.to.uninstall.for.several.dependent.packages", StringUtil.join(dep, (String)"\n"));
                    warning[0] = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)PyBundle.message("python.packaging.warning", new Object[0]), (String)message).asWarning()).ask(this.myProject);
                }
            }, ModalityState.current());
            if (!warning[0]) {
                return true;
            }
        }
        catch (ExecutionException e) {
            LOG.info("Error loading packages dependents: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static Map<String, Set<PyPackage>> collectDependents(@NotNull List<PyPackage> packages2, Sdk sdk2) throws ExecutionException {
        if (packages2 == null) {
            PyPackageManagerUI.$$$reportNull$$$0(5);
        }
        HashMap<String, Set<PyPackage>> dependentPackages = new HashMap<String, Set<PyPackage>>();
        for (PyPackage pkg : packages2) {
            Set<PyPackage> dependents = PyPackageManager.getInstance(sdk2).getDependents(pkg);
            if (dependents.isEmpty()) continue;
            for (PyPackage dependent : dependents) {
                if (packages2.contains((Object)dependent)) continue;
                dependentPackages.put(pkg.getName(), dependents);
            }
        }
        return dependentPackages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDependents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDependents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void started();

        public void finished(List<ExecutionException> var1);
    }

    private static class InstallManagementTask
    extends InstallTask {
        InstallManagementTask(@Nullable Project project, @NotNull Sdk sdk2, @Nullable Listener listener2) {
            if (sdk2 == null) {
                InstallManagementTask.$$$reportNull$$$0(0);
            }
            super(project, sdk2, Collections.emptyList(), Collections.emptyList(), listener2);
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                InstallManagementTask.$$$reportNull$$$0(1);
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setText(PyBundle.message("python.packaging.installing.packaging.tools", new Object[0]));
            indicator.setIndeterminate(true);
            try {
                manager.installManagement();
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
            manager.refresh();
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                InstallManagementTask.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String string = PyBundle.message("python.packaging.notification.description.installed.python.packaging.tools", new Object[0]);
            if (string == null) {
                InstallManagementTask.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class InstallTask
    extends PackagingTask {
        @Nullable
        private final List<PyRequirement> myRequirements;
        @NotNull
        private final List<String> myExtraArgs;

        InstallTask(@Nullable Project project, @NotNull Sdk sdk2, @Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs, @Nullable Listener listener2) {
            if (sdk2 == null) {
                InstallTask.$$$reportNull$$$0(0);
            }
            if (extraArgs == null) {
                InstallTask.$$$reportNull$$$0(1);
            }
            super(project, sdk2, PyBundle.message("python.packaging.progress.title.installing.packages", new Object[0]), listener2);
            this.myRequirements = requirements;
            this.myExtraArgs = extraArgs;
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                InstallTask.$$$reportNull$$$0(2);
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            if (this.myProject == null) {
                ArrayList<ExecutionException> arrayList = exceptions;
                if (arrayList == null) {
                    InstallTask.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            ExecutionException result2 = PythonPackagesInstaller.Companion.installPackages(this.myProject, this.mySdk, this.myRequirements, this.myExtraArgs, indicator);
            if (result2 != null) {
                exceptions.add(result2);
            }
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                InstallTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            String string = PyBundle.message("python.packaging.notification.title.packages.installed.successfully", new Object[0]);
            if (string == null) {
                InstallTask.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String string = this.myRequirements != null ? PyBundle.message("python.packaging.notification.description.installed.packages", PyPackageUtil.requirementsToString(this.myRequirements)) : PyBundle.message("python.packaging.notification.description.installed.all.requirements", new Object[0]);
            if (string == null) {
                InstallTask.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            String string = PyBundle.message("python.packaging.notification.title.install.packages.failed", new Object[0]);
            if (string == null) {
                InstallTask.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class UninstallTask
    extends PackagingTask {
        @NotNull
        private final List<PyPackage> myPackages;

        UninstallTask(@Nullable Project project, @NotNull Sdk sdk2, @Nullable Listener listener2, @NotNull List<PyPackage> packages2) {
            if (sdk2 == null) {
                UninstallTask.$$$reportNull$$$0(0);
            }
            if (packages2 == null) {
                UninstallTask.$$$reportNull$$$0(1);
            }
            super(project, sdk2, PyBundle.message("python.packaging.progress.title.uninstalling.packages", new Object[0]), listener2);
            this.myPackages = packages2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            List<ExecutionException> list;
            if (indicator == null) {
                UninstallTask.$$$reportNull$$$0(2);
            }
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setIndeterminate(true);
            try {
                manager.uninstall(this.myPackages);
                List<ExecutionException> list2 = Collections.emptyList();
                list = list2;
            }
            catch (ExecutionException e) {
                List<ExecutionException> list3 = Collections.singletonList(e);
                List<ExecutionException> list4 = list3;
                if (list4 == null) {
                    UninstallTask.$$$reportNull$$$0(4);
                }
                return list4;
            }
            finally {
                manager.refresh();
            }
            if (list == null) {
                UninstallTask.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            String string = PyBundle.message("python.packaging.notification.title.packages.uninstalled.successfully", new Object[0]);
            if (string == null) {
                UninstallTask.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String packagesString = StringUtil.join(this.myPackages, pkg -> "'" + pkg.getName() + "'", (String)", ");
            String string = PyBundle.message("python.packaging.notification.description.uninstalled.packages", packagesString);
            if (string == null) {
                UninstallTask.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            String string = PyBundle.message("python.packaging.notification.title.uninstall.packages.failed", new Object[0]);
            if (string == null) {
                UninstallTask.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class PackagingTask
    extends Task.Backgroundable {
        private static final String PACKAGING_GROUP_ID = "Packaging";
        @NotNull
        protected final Sdk mySdk;
        @Nullable
        protected final Listener myListener;

        PackagingTask(@Nullable Project project, @NotNull Sdk sdk2, @NotNull @NlsContexts.ProgressTitle String title, @Nullable Listener listener2) {
            if (sdk2 == null) {
                PackagingTask.$$$reportNull$$$0(0);
            }
            if (title == null) {
                PackagingTask.$$$reportNull$$$0(1);
            }
            super(project, title);
            this.mySdk = sdk2;
            this.myListener = listener2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PackagingTask.$$$reportNull$$$0(2);
            }
            this.taskStarted(indicator);
            this.taskFinished(this.runTask(indicator));
        }

        @NotNull
        protected abstract List<ExecutionException> runTask(@NotNull ProgressIndicator var1);

        @NotNull
        @NlsContexts.NotificationTitle
        protected abstract String getSuccessTitle();

        @NotNull
        @NlsContexts.NotificationContent
        protected abstract String getSuccessDescription();

        @NotNull
        @NlsContexts.NotificationTitle
        protected abstract String getFailureTitle();

        protected void taskStarted(@NotNull ProgressIndicator indicator) {
            PackagingNotification[] notifications;
            if (indicator == null) {
                PackagingTask.$$$reportNull$$$0(3);
            }
            for (PackagingNotification notification2 : notifications = (PackagingNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(PackagingNotification.class, this.getProject())) {
                notification2.expire();
            }
            indicator.setText(this.getTitle() + "...");
            if (this.myListener != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myListener.started());
            }
        }

        protected void taskFinished(@NotNull List<ExecutionException> exceptions) {
            if (exceptions == null) {
                PackagingTask.$$$reportNull$$$0(4);
            }
            Ref notificationRef = new Ref(null);
            if (exceptions.isEmpty()) {
                notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getSuccessTitle(), this.getSuccessDescription(), NotificationType.INFORMATION, null));
            } else {
                List requirements = this instanceof InstallTask && ((InstallTask)this).myRequirements != null ? ContainerUtil.flatMap(((InstallTask)this).myRequirements, req -> ContainerUtil.map(req.getInstallOptions(), option -> Pair.create((Object)option, (Object)req.getName()))) : null;
                List packageManagerArguments = exceptions.stream().flatMap(e -> e instanceof PyExecutionException ? ((PyExecutionException)e).getArgs().stream() : null).toList();
                final String packageNames = requirements != null ? requirements.stream().filter(req -> packageManagerArguments.contains(req.first)).map(req -> (String)req.second).collect(Collectors.joining(", ")) : "";
                final PyPackageManagementService.PyPackageInstallationErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, this.mySdk, packageNames);
                if (description != null) {
                    String firstLine = PyBundle.message("python.packaging.notification.title.error.occurred", this.getTitle());
                    NotificationListener listener2 = new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                            if (notification2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (event == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            assert (myProject != null);
                            PyPackageInstallationErrorDialog dialog2 = new PyPackageInstallationErrorDialog(packageNames.isEmpty() ? IdeBundle.message((String)"failed.to.install.packages.dialog.title", (Object[])new Object[0]) : IdeBundle.message((String)"failed.to.install.package.dialog.title", (Object[])new Object[]{packageNames}), description);
                            dialog2.show();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    String content2 = PackagingTask.wrapIntoLink(firstLine, "python.packaging.notification.description.details.link");
                    notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getFailureTitle(), content2, NotificationType.ERROR, listener2));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Notification notification2;
                if (this.myListener != null) {
                    this.myListener.finished(exceptions);
                }
                if ((notification2 = (Notification)notificationRef.get()) != null) {
                    notification2.notify(this.myProject);
                }
            });
        }

        @NotNull
        @Nls
        private static String wrapIntoLink(@NotNull @Nls String prefix, @NotNull @PropertyKey(resourceBundle="messages.PyBundle") @NotNull @PropertyKey(resourceBundle="messages.PyBundle") String key) {
            if (prefix == null) {
                PackagingTask.$$$reportNull$$$0(5);
            }
            if (key == null) {
                PackagingTask.$$$reportNull$$$0(6);
            }
            String string = prefix + " <a href=\"xxx\">" + PyBundle.message(key, new Object[0]) + "</a>";
            if (string == null) {
                PackagingTask.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapIntoLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "taskStarted";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "taskFinished";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapIntoLink";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }

        private static class PackagingNotification
        extends Notification {
            PackagingNotification(@NotNull String groupDisplayId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content2, @NotNull NotificationType type2, @Nullable NotificationListener listener2) {
                if (groupDisplayId == null) {
                    PackagingNotification.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    PackagingNotification.$$$reportNull$$$0(1);
                }
                if (content2 == null) {
                    PackagingNotification.$$$reportNull$$$0(2);
                }
                if (type2 == null) {
                    PackagingNotification.$$$reportNull$$$0(3);
                }
                super(groupDisplayId, title, content2, type2);
                if (listener2 != null) {
                    this.setListener(listener2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupDisplayId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

