/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.google.common.base.MoreObjects;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;

public class TableValueDescriptor {
    private final String myValue;
    private final ArrayChunk.ColHeader myHeader;

    public TableValueDescriptor(String value, ArrayChunk.ColHeader header) {
        this.myValue = value;
        this.myHeader = header;
    }

    public String getValue() {
        return this.myValue;
    }

    public double getRangedValue() {
        double max;
        double min;
        if (this.myValue == null || this.myHeader == null) {
            return Double.NaN;
        }
        String dataType = this.myHeader.getType();
        if ("o".equals(dataType)) {
            return Double.NaN;
        }
        String minValue = (String)MoreObjects.firstNonNull((Object)this.myHeader.getMin(), (Object)"0");
        String maxValue = (String)MoreObjects.firstNonNull((Object)this.myHeader.getMax(), (Object)"0");
        if ("c".equals(dataType)) {
            min = 0.0;
            max = 1.0;
        } else if ("b".equals(dataType)) {
            min = minValue.equals("True") ? 1.0 : 0.0;
            max = maxValue.equals("True") ? 1.0 : 0.0;
        } else {
            min = Double.parseDouble(minValue);
            max = Double.parseDouble(maxValue);
        }
        return min == max ? 0.0 : PyNumericViewUtil.getRangedValue(this.myValue, dataType, min, max, minValue, maxValue);
    }

    public String toString() {
        if (this.myValue == null || this.myHeader == null) {
            return "";
        }
        return this.myValue;
    }
}

