/*
 *  Copyright 2022 René Ferdinand Rivera Morell
 *  Copyright 2001-2004 David Abrahams.
 *  Copyright 2019 Rene Rivera.
 *  Distributed under the Boost Software License, Version 1.0.
 *  (See accompanying file LICENSE.txt or https://www.bfgroup.xyz/b2/LICENSE.txt)
 */
#ifndef MODULES_DWA10182001_H
#define MODULES_DWA10182001_H

#include "config.h"
#include "bind.h"
#include "lists.h"
#include "object.h"

#include <string>
#include <vector>

typedef struct module_t module_t ;

typedef module_t * module_ptr;

struct module_t
{
    OBJECT * name = nullptr;
    struct hash * rules = nullptr;
    struct hash * variables = nullptr;
    struct hash * variable_indices = nullptr;
    int num_fixed_variables = 0;
    LIST * * fixed_variables = nullptr;
    struct hash * imported_modules = nullptr;
    module_t * class_module = nullptr;
    struct hash * native_rules = nullptr;
    int user_module = 0;
};

module_t * bindmodule( OBJECT * name );
module_t * root_module();
void delete_module( module_t * );

void import_module( LIST * module_names, module_t * target_module );
LIST * imported_modules( module_t * );

struct hash * demand_rules( module_t * );

void module_bind_variables( module_t * );

/*
 * After calling module_add_fixed_var, module_set_fixed_variables must be called
 * before accessing any variables in the module.
 */
int module_add_fixed_var( module_t *, OBJECT * name, int * n );
void module_set_fixed_variables( module_t *, int n );

/*
 * Returns the index of the variable or -1 if none exists.
 */
int module_get_fixed_var( module_t *, OBJECT * name );

LIST * module_rules( module_t * m = nullptr);

void modules_done();

#endif
