/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dita.dost.util.Graph;

public class UriGraph {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Graph graph;
    private final Map<URI, Integer> indexMap = new HashMap<URI, Integer>();

    public UriGraph(int initialSize) {
        this.graph = new Graph(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URI from, URI to) {
        assert (from.isAbsolute());
        assert (to.isAbsolute());
        this.writeLock.lock();
        try {
            int source = this.indexMap.computeIfAbsent(from.normalize(), uri -> this.indexMap.size());
            int destination = this.indexMap.computeIfAbsent(to.normalize(), uri -> this.indexMap.size());
            this.graph.addEdge(source, destination);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(URI from, URI to) {
        assert (from.isAbsolute());
        assert (to.isAbsolute());
        this.writeLock.lock();
        try {
            Integer source = this.indexMap.get(from);
            Integer destination = this.indexMap.get(to);
            if (source != null && destination != null) {
                this.graph.removeEdge(source, destination);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(URI from, URI to) {
        assert (from.isAbsolute());
        assert (to.isAbsolute());
        this.readLock.lock();
        try {
            Integer source = this.indexMap.get(from);
            Integer destination = this.indexMap.get(to);
            if (source != null && destination != null) {
                boolean bl = this.graph.isEdge(source, destination);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, List<URI>> getAll() {
        this.readLock.lock();
        try {
            HashMap<URI, List<URI>> res = new HashMap<URI, List<URI>>();
            int size = this.graph.getSize();
            URI[] uris = new URI[size];
            for (Map.Entry<URI, Integer> entry : this.indexMap.entrySet()) {
                uris[entry.getValue().intValue()] = entry.getKey();
            }
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    if (!this.graph.isEdge(i, j)) continue;
                    List value = res.getOrDefault(uris[i], new ArrayList());
                    value.add(uris[j]);
                    res.put(uris[i], value);
                }
            }
            HashMap<URI, List<URI>> hashMap = res;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> get(URI from) {
        this.readLock.lock();
        try {
            Integer i = this.indexMap.get(from);
            if (i == null) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            boolean[] data = this.graph.getData(i);
            int size = data.length;
            ArrayList<URI> res = new ArrayList<URI>(size);
            for (Map.Entry<URI, Integer> entry : this.indexMap.entrySet()) {
                if (!data[entry.getValue()]) continue;
                res.add(entry.getKey());
            }
            ArrayList<URI> arrayList = res;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

